/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsKeyring_Compile.KmsWrapInfo;
import MaterialWrapping_Compile.GenerateAndWrapInput;
import MaterialWrapping_Compile.GenerateAndWrapMaterial;
import MaterialWrapping_Compile.GenerateAndWrapOutput;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class KmsGenerateAndWrapKeyMaterial
implements GenerateAndWrapMaterial<KmsWrapInfo>,
ActionWithResult<GenerateAndWrapInput, GenerateAndWrapOutput<KmsWrapInfo>, Error>,
Action<GenerateAndWrapInput, Result<GenerateAndWrapOutput<KmsWrapInfo>, Error>> {
    public IKMSClient _client = null;
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<KmsGenerateAndWrapKeyMaterial> _TYPE = TypeDescriptor.referenceWithInitializer(KmsGenerateAndWrapKeyMaterial.class, () -> null);

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<GenerateAndWrapOutput<KmsWrapInfo>, Error> Invoke(GenerateAndWrapInput input) {
        Result<GenerateDataKeyResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out88;
        Result<GenerateAndWrapOutput<KmsWrapInfo>, Error> res = Result.Default(GenerateAndWrapOutput.Default(KmsWrapInfo.Default()));
        AlgorithmSuiteInfo _574_suite = input.dtor_algorithmSuite();
        Result<Object, Object> _576_valueOrError0 = Result.Default(DafnyMap.empty());
        _576_valueOrError0 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_encryptionContext());
        if (_576_valueOrError0.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            res = _576_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        DafnyMap _575_stringifiedEncCtx = (DafnyMap)_576_valueOrError0.Extract((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        GenerateDataKeyRequest _577_generatorRequest = GenerateDataKeyRequest.create(this.awsKmsKey(), Option.create_Some(_575_stringifiedEncCtx), Option.create_Some(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_574_suite)), Option.create_None(), Option.create_Some(this.grantTokens()));
        Result<GenerateDataKeyResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _578_maybeGenerateResponse = _out88 = this.client().GenerateDataKey(_577_generatorRequest);
        Result<GenerateDataKeyResponse, Object> _580_valueOrError1 = Result.Default(GenerateDataKeyResponse.Default());
        _580_valueOrError1 = _578_maybeGenerateResponse.MapFailure(GenerateDataKeyResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _581_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _581_e = _581_e_boxed0;
            return Error.create_ComAmazonawsKms(_581_e);
        });
        if (_580_valueOrError1.IsFailure(GenerateDataKeyResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _580_valueOrError1.PropagateFailure(GenerateDataKeyResponse._typeDescriptor(), Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        GenerateDataKeyResponse _579_generateResponse = _580_valueOrError1.Extract(GenerateDataKeyResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _582_valueOrError2 = Outcome.Default();
        _582_valueOrError2 = __default.Need(Error._typeDescriptor(), _579_generateResponse.dtor_KeyId().is_Some() && AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(_579_generateResponse.dtor_KeyId().dtor_value()).is_Success(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS GenerateDataKey:: Invalid Key Id")));
        if (_582_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _582_valueOrError2.PropagateFailure(Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        Outcome<Object> _583_valueOrError3 = Outcome.Default();
        _583_valueOrError3 = __default.Need(Error._typeDescriptor(), _579_generateResponse.dtor_Plaintext().is_Some() && Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_574_suite)), BigInteger.valueOf(_579_generateResponse.dtor_Plaintext().dtor_value().length())), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GenerateDataKey: Invalid data key")));
        if (_583_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _583_valueOrError3.PropagateFailure(Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        Outcome<Object> _584_valueOrError4 = Outcome.Default();
        _584_valueOrError4 = __default.Need(Error._typeDescriptor(), _579_generateResponse.dtor_CiphertextBlob().is_Some() && software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(_579_generateResponse.dtor_CiphertextBlob().dtor_value()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GeneratedDataKey: Invalid ciphertext")));
        if (_584_valueOrError4.IsFailure(Error._typeDescriptor())) {
            res = _584_valueOrError4.PropagateFailure(Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        GenerateAndWrapOutput<KmsWrapInfo> _585_output = GenerateAndWrapOutput.create(_579_generateResponse.dtor_Plaintext().dtor_value(), _579_generateResponse.dtor_CiphertextBlob().dtor_value(), KmsWrapInfo.create(_579_generateResponse.dtor_KeyId().dtor_value()));
        res = Result.create_Success(_585_output);
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<KmsGenerateAndWrapKeyMaterial> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsKeyring.KmsGenerateAndWrapKeyMaterial";
    }
}

