/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsHierarchicalKeyring_Compile;

import AwsKmsHierarchicalKeyring_Compile.DecryptSingleEncryptedDataKey;
import AwsKmsHierarchicalKeyring_Compile.HierarchyWrapInfo;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyGenerateAndWrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyWrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.OnDecryptHierarchyEncryptedDataKeyFilter;
import AwsKmsHierarchicalKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials;
import software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetBranchKeyIdInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetBranchKeyIdOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.IBranchKeyIdSupplier;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;

public class AwsKmsHierarchicalKeyring
implements VerifiableInterface,
IKeyring {
    public IKeyStoreClient _keyStore = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public Option<IBranchKeyIdSupplier> _branchKeyIdSupplier = Option.Default();
    public Option<DafnySequence<? extends Character>> _branchKeyId = Option.Default();
    public long _ttlSeconds = 0L;
    public ICryptographicMaterialsCache _cache = null;
    private static final TypeDescriptor<AwsKmsHierarchicalKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsHierarchicalKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out148 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out148;
    }

    @Override
    public Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out149 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out149;
    }

    public void __ctor(IKeyStoreClient keyStore, Option<DafnySequence<? extends Character>> branchKeyId, Option<IBranchKeyIdSupplier> branchKeyIdSupplier, long ttlSeconds, ICryptographicMaterialsCache cmc, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyStore = keyStore;
        this._branchKeyId = branchKeyId;
        this._branchKeyIdSupplier = branchKeyIdSupplier;
        this._ttlSeconds = ttlSeconds;
        this._cryptoPrimitives = cryptoPrimitives;
        this._cache = cmc;
    }

    public Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetBranchKeyId(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> context) {
        Result<Object, software.amazon.cryptography.materialproviders.internaldafny.types.Error> ret = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        if (this.branchKeyId().is_Some()) {
            ret = Result.create_Success(this.branchKeyId().dtor_value());
            return ret;
        }
        Result<GetBranchKeyIdOutput, Object> _819_valueOrError0 = Result.Default(GetBranchKeyIdOutput.Default());
        Result<GetBranchKeyIdOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out150 = this.branchKeyIdSupplier().dtor_value().GetBranchKeyId(GetBranchKeyIdInput.create(context));
        _819_valueOrError0 = _out150;
        if (_819_valueOrError0.IsFailure(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            ret = _819_valueOrError0.PropagateFailure(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            return ret;
        }
        GetBranchKeyIdOutput _818_GetBranchKeyIdOut = _819_valueOrError0.Extract(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        ret = Result.create_Success(_818_GetBranchKeyIdOut.dtor_branchKeyId());
        return ret;
    }

    @Override
    public Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        EncryptionMaterials _820_materials = input.dtor_materials();
        AlgorithmSuiteInfo _821_suite = _820_materials.dtor_algorithmSuite();
        Result<Object, Object> _823_valueOrError0 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out151 = this.GetBranchKeyId(_820_materials.dtor_encryptionContext());
        _823_valueOrError0 = _out151;
        if (_823_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _823_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _822_branchKeyIdForEncrypt = (DafnySequence)_823_valueOrError0.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence<? extends Byte>, Object> _825_valueOrError1 = Result.Default(ValidUTF8Bytes.defaultValue());
        _825_valueOrError1 = UTF8.__default.Encode((DafnySequence<? extends Character>)_822_branchKeyIdForEncrypt).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_825_valueOrError1.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _825_valueOrError1.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Byte> _824_branchKeyIdUtf8 = _825_valueOrError1.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _827_valueOrError2 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out152 = this.GetActiveCacheId((DafnySequence<? extends Character>)_822_branchKeyIdForEncrypt, _824_branchKeyIdUtf8, this.cryptoPrimitives());
        _827_valueOrError2 = _out152;
        if (_827_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _827_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _826_cacheId = (DafnySequence)_827_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<BranchKeyMaterials, Object> _829_valueOrError3 = Result.Default(BranchKeyMaterials.Default());
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out153 = this.GetActiveHierarchicalMaterials((DafnySequence<? extends Character>)_822_branchKeyIdForEncrypt, (DafnySequence<? extends Byte>)_826_cacheId, this.keyStore());
        _829_valueOrError3 = _out153;
        if (_829_valueOrError3.IsFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _829_valueOrError3.PropagateFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        BranchKeyMaterials _828_hierarchicalMaterials = _829_valueOrError3.Extract(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence<? extends Byte> _830_branchKey = _828_hierarchicalMaterials.dtor_branchKey();
        DafnySequence<? extends Byte> _831_branchKeyVersion = _828_hierarchicalMaterials.dtor_branchKeyVersion();
        Result<Object, Object> _833_valueOrError4 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _833_valueOrError4 = UTF8.__default.Decode(_831_branchKeyVersion).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_833_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _833_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _832_branchKeyVersionAsString = (DafnySequence)_833_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _835_valueOrError5 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _835_valueOrError5 = UUID.__default.ToByteArray((DafnySequence<? extends Character>)_832_branchKeyVersionAsString).MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_835_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _835_valueOrError5.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _834_branchKeyVersionAsBytes = (DafnySequence)_835_valueOrError5.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        KmsHierarchyGenerateAndWrapKeyMaterial _nw33 = new KmsHierarchyGenerateAndWrapKeyMaterial();
        _nw33.__ctor(_828_hierarchicalMaterials.dtor_branchKey(), _824_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_834_branchKeyVersionAsBytes, this.cryptoPrimitives());
        KmsHierarchyGenerateAndWrapKeyMaterial _836_kmsHierarchyGenerateAndWrap = _nw33;
        KmsHierarchyWrapKeyMaterial _nw34 = new KmsHierarchyWrapKeyMaterial();
        _nw34.__ctor(_828_hierarchicalMaterials.dtor_branchKey(), _824_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_834_branchKeyVersionAsBytes, this.cryptoPrimitives());
        KmsHierarchyWrapKeyMaterial _837_kmsHierarchyWrap = _nw34;
        Result<WrapEdkMaterialOutput<HierarchyWrapInfo>, Object> _839_valueOrError6 = Result.Default(WrapEdkMaterialOutput.Default(HierarchyWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<HierarchyWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out154 = EdkWrapping_Compile.__default.WrapEdkMaterial(HierarchyWrapInfo._typeDescriptor(), _820_materials, _837_kmsHierarchyWrap, _836_kmsHierarchyGenerateAndWrap);
        _839_valueOrError6 = _out154;
        if (_839_valueOrError6.IsFailure(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _839_valueOrError6.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<HierarchyWrapInfo> _838_wrapOutput = _839_valueOrError6.Extract(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _840_symmetricSigningKeyList = _838_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_838_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _841_edk = EncryptedDataKey.create(Constants_Compile.__default.PROVIDER__ID__HIERARCHY(), _824_branchKeyIdUtf8, _838_wrapOutput.dtor_wrappedMaterial());
        if (_838_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _843_valueOrError7 = null;
            _843_valueOrError7 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_820_materials, _838_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_841_edk}), _840_symmetricSigningKeyList);
            if (_843_valueOrError7.IsFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                res = _843_valueOrError7.PropagateFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _842_result = _843_valueOrError7.Extract(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_842_result));
            return res;
        }
        if (_838_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _845_valueOrError8 = null;
            _845_valueOrError8 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_820_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_841_edk}), _840_symmetricSigningKeyList);
            if (_845_valueOrError8.IsFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                res = _845_valueOrError8.PropagateFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _844_result = _845_valueOrError8.Extract(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_844_result));
            return res;
        }
        return res;
    }

    @Override
    public Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>> _out157;
        Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        DecryptionMaterials _846_materials = input.dtor_materials();
        AlgorithmSuiteInfo _847_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _848_valueOrError0 = Outcome.Default();
        _848_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_846_materials), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_848_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _848_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Result<Object, Object> _850_valueOrError1 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out155 = this.GetBranchKeyId(_846_materials.dtor_encryptionContext());
        _850_valueOrError1 = _out155;
        if (_850_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _850_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _849_branchKeyIdForDecrypt = (DafnySequence)_850_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        OnDecryptHierarchyEncryptedDataKeyFilter _nw35 = new OnDecryptHierarchyEncryptedDataKeyFilter();
        _nw35.__ctor((DafnySequence<? extends Character>)_849_branchKeyIdForDecrypt);
        OnDecryptHierarchyEncryptedDataKeyFilter _851_filter = _nw35;
        Result<Object, Object> _853_valueOrError2 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out156 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _851_filter, input.dtor_encryptedDataKeys());
        _853_valueOrError2 = _out156;
        if (_853_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _853_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _852_edksToAttempt = (DafnySequence)_853_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _854_valueOrError3 = Outcome.Default();
        _854_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_852_edksToAttempt.length()).signum() == 1, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to decrypt data key: No Encrypted Data Keys found to match.")));
        if (_854_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _854_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptSingleEncryptedDataKey _nw36 = new DecryptSingleEncryptedDataKey();
        _nw36.__ctor(_846_materials, this.keyStore(), this.cryptoPrimitives(), (DafnySequence<? extends Character>)_849_branchKeyIdForDecrypt, this.ttlSeconds(), this.cache());
        DecryptSingleEncryptedDataKey _855_decryptClosure = _nw36;
        Result<DecryptionMaterials, DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>> _856_outcome = _out157 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _855_decryptClosure, _852_edksToAttempt);
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _858_valueOrError4 = null;
        _858_valueOrError4 = _856_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>>)DafnySequence._typeDescriptor(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _859_errors_boxed0 -> {
            DafnySequence _859_errors = _859_errors_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_CollectionOfErrors((DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.Error>)_859_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_858_valueOrError4.IsFailure(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _858_valueOrError4.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _857_SealedDecryptionMaterials = _858_valueOrError4.Extract(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_857_SealedDecryptionMaterials));
        return res;
    }

    public Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetActiveCacheId(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> branchKeyIdUtf8, AtomicPrimitivesClient cryptoPrimitives) {
        Result<DafnySequence<? extends Byte>, Error> _out159;
        Result<DafnySequence<? extends Byte>, Error> _out158;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> cacheId = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Object> _860_valueOrError0 = Outcome.Default();
        _860_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).is_Success() && (Boolean)Helpers.Let(UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).dtor_value(), boxed38 -> {
            DafnySequence _pat_let19_0 = boxed38;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let19_0, boxed39 -> {
                DafnySequence _861_branchKeyId = boxed39;
                return BigInteger.valueOf(_861_branchKeyId.length()).signum() != -1 && BigInteger.valueOf(_861_branchKeyId.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT32__LIMIT()) < 0;
            }));
        }) != false, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Branch Key ID Length")));
        if (_860_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _860_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Character> _862_branchKeyId = UTF8.__default.Decode(branchKeyIdUtf8).dtor_value();
        DafnySequence<? extends Byte> _863_lenBranchKey = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(_862_branchKeyId.cardinalityInt());
        DigestAlgorithm _864_hashAlgorithm = DigestAlgorithm.create_SHA__512();
        Result<DafnySequence<? extends Byte>, Error> _865_maybeBranchKeyDigest = _out158 = cryptoPrimitives.Digest(DigestInput.create(_864_hashAlgorithm, branchKeyIdUtf8));
        Result<Object, Object> _867_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _867_valueOrError1 = _865_maybeBranchKeyDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _868_e_boxed0 -> {
            Error _868_e = _868_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_868_e);
        });
        if (_867_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _867_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _866_branchKeyDigest = (DafnySequence)_867_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence<? extends Byte>, Object> _870_valueOrError2 = Result.Default(ValidUTF8Bytes.defaultValue());
        _870_valueOrError2 = UTF8.__default.Encode(__default.EXPRESSION__ATTRIBUTE__VALUE__STATUS__VALUE()).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_870_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _870_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Byte> _869_activeUtf8 = _870_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence _871_identifier = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(_863_lenBranchKey, (DafnySequence)_866_branchKeyDigest), (DafnySequence)DafnySequence.of((byte[])new byte[]{0})), _869_activeUtf8);
        Result<DafnySequence<? extends Byte>, Error> _872_maybeCacheIdDigest = _out159 = cryptoPrimitives.Digest(DigestInput.create(_864_hashAlgorithm, (DafnySequence<? extends Byte>)_871_identifier));
        Result<Object, Object> _874_valueOrError3 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _874_valueOrError3 = _872_maybeCacheIdDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _875_e_boxed0 -> {
            Error _875_e = _875_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_875_e);
        });
        if (_874_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _874_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _873_cacheDigest = (DafnySequence)_874_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _876_valueOrError4 = Outcome.Default();
        _876_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(_873_cacheDigest.length()), Digest_Compile.__default.Length(_864_hashAlgorithm)), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Digest generated a message not equal to the expected length.")));
        if (_876_valueOrError4.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _876_valueOrError4.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        cacheId = Result.create_Success(_873_cacheDigest.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(32L))));
        return cacheId;
    }

    public Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetActiveHierarchicalMaterials(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> cacheId, IKeyStoreClient keyStore) {
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> material = Result.Default(BranchKeyMaterials.Default());
        GetCacheEntryInput _877_getCacheInput = GetCacheEntryInput.create(cacheId, Option.create_None());
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out160 = __default.getEntry(this.cache(), _877_getCacheInput);
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _878_getCacheOutput = _out160;
        if (_878_getCacheOutput.is_Failure()) {
            long _out162;
            Result<GetActiveBranchKeyOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _out161;
            Result<GetActiveBranchKeyOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _879_maybeGetActiveBranchKeyOutput = _out161 = keyStore.GetActiveBranchKey(GetActiveBranchKeyInput.create(branchKeyId));
            Result<GetActiveBranchKeyOutput, Object> _881_valueOrError0 = Result.Default(GetActiveBranchKeyOutput.Default());
            _881_valueOrError0 = _879_maybeGetActiveBranchKeyOutput.MapFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _882_e_boxed0 -> {
                software.amazon.cryptography.keystore.internaldafny.types.Error _882_e = _882_e_boxed0;
                return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyKeyStore(_882_e);
            });
            if (_881_valueOrError0.IsFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _881_valueOrError0.PropagateFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            GetActiveBranchKeyOutput _880_getActiveBranchKeyOutput = _881_valueOrError0.Extract(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            BranchKeyMaterials _883_branchKeyMaterials = _880_getActiveBranchKeyOutput.dtor_branchKeyMaterials();
            long _884_now = _out162 = Time.__default.CurrentRelativeTime().longValue();
            Outcome<Object> _885_valueOrError1 = Outcome.Default();
            _885_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_884_now).add(BigInteger.valueOf(this.ttlSeconds())).compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) < 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"INT64 Overflow when putting cache entry.")));
            if (_885_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _885_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            PutCacheEntryInput _886_putCacheEntryInput = PutCacheEntryInput.create(cacheId, Materials.create_BranchKey(_883_branchKeyMaterials), _884_now, this.ttlSeconds() + _884_now, Option.create_None(), Option.create_None());
            Result<Tuple0, Object> _888_valueOrError2 = Result.Default(Tuple0.Default());
            Result<Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out163 = __default.putEntry(this.cache(), _886_putCacheEntryInput);
            _888_valueOrError2 = _out163;
            if (_888_valueOrError2.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _888_valueOrError2.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            Tuple0 _887___v0 = _888_valueOrError2.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            material = Result.create_Success(_883_branchKeyMaterials);
            return material;
        }
        Outcome<Object> _889_valueOrError3 = Outcome.Default();
        _889_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _878_getCacheOutput.dtor_value().dtor_materials().is_BranchKey() && Objects.equals(_878_getCacheOutput.dtor_value().dtor_materials(), Materials.create_BranchKey(_878_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey())), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Material Type.")));
        if (_889_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            material = _889_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
            return material;
        }
        material = Result.create_Success(_878_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey());
        return material;
    }

    public IKeyStoreClient keyStore() {
        return this._keyStore;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public Option<IBranchKeyIdSupplier> branchKeyIdSupplier() {
        return this._branchKeyIdSupplier;
    }

    public Option<DafnySequence<? extends Character>> branchKeyId() {
        return this._branchKeyId;
    }

    public long ttlSeconds() {
        return this._ttlSeconds;
    }

    public ICryptographicMaterialsCache cache() {
        return this._cache;
    }

    public static TypeDescriptor<AwsKmsHierarchicalKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsHierarchicalKeyring.AwsKmsHierarchicalKeyring";
    }
}

