// Class ValidateCommitmentPolicyOnEncryptInput
// Dafny class ValidateCommitmentPolicyOnEncryptInput compiled into Java
package software.amazon.cryptography.materialproviders.internaldafny.types;

import software.amazon.cryptography.keystore.internaldafny.types.*;

@SuppressWarnings({"unchecked", "deprecation"})
public class ValidateCommitmentPolicyOnEncryptInput {
  public AlgorithmSuiteId _algorithm;
  public CommitmentPolicy _commitmentPolicy;
  public ValidateCommitmentPolicyOnEncryptInput (AlgorithmSuiteId algorithm, CommitmentPolicy commitmentPolicy) {
    this._algorithm = algorithm;
    this._commitmentPolicy = commitmentPolicy;
  }

  @Override
  public boolean equals(Object other) {
    if (this == other) return true;
    if (other == null) return false;
    if (getClass() != other.getClass()) return false;
    ValidateCommitmentPolicyOnEncryptInput o = (ValidateCommitmentPolicyOnEncryptInput)other;
    return true && java.util.Objects.equals(this._algorithm, o._algorithm) && java.util.Objects.equals(this._commitmentPolicy, o._commitmentPolicy);
  }
  @Override
  public int hashCode() {
    long hash = 5381;
    hash = ((hash << 5) + hash) + 0;
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._algorithm);
    hash = ((hash << 5) + hash) + java.util.Objects.hashCode(this._commitmentPolicy);
    return (int)hash;
  }

  @Override
  public String toString() {
    StringBuilder s = new StringBuilder();
    s.append("AwsCryptographyMaterialProvidersTypes.ValidateCommitmentPolicyOnEncryptInput.ValidateCommitmentPolicyOnEncryptInput");
    s.append("(");
    s.append(dafny.Helpers.toString(this._algorithm));
    s.append(", ");
    s.append(dafny.Helpers.toString(this._commitmentPolicy));
    s.append(")");
    return s.toString();
  }
  private static final dafny.TypeDescriptor<ValidateCommitmentPolicyOnEncryptInput> _TYPE = dafny.TypeDescriptor.<ValidateCommitmentPolicyOnEncryptInput>referenceWithInitializer(ValidateCommitmentPolicyOnEncryptInput.class, () -> ValidateCommitmentPolicyOnEncryptInput.Default());
  public static dafny.TypeDescriptor<ValidateCommitmentPolicyOnEncryptInput> _typeDescriptor() {
    return (dafny.TypeDescriptor<ValidateCommitmentPolicyOnEncryptInput>) (dafny.TypeDescriptor<?>) _TYPE;
  }

  private static final ValidateCommitmentPolicyOnEncryptInput theDefault = software.amazon.cryptography.materialproviders.internaldafny.types.ValidateCommitmentPolicyOnEncryptInput.create(AlgorithmSuiteId.Default(), CommitmentPolicy.Default());
  public static ValidateCommitmentPolicyOnEncryptInput Default() {
    return theDefault;
  }
  public static ValidateCommitmentPolicyOnEncryptInput create(AlgorithmSuiteId algorithm, CommitmentPolicy commitmentPolicy) {
    return new ValidateCommitmentPolicyOnEncryptInput(algorithm, commitmentPolicy);
  }
  public static ValidateCommitmentPolicyOnEncryptInput create_ValidateCommitmentPolicyOnEncryptInput(AlgorithmSuiteId algorithm, CommitmentPolicy commitmentPolicy) {
    return create(algorithm, commitmentPolicy);
  }
  public boolean is_ValidateCommitmentPolicyOnEncryptInput() { return true; }
  public AlgorithmSuiteId dtor_algorithm() {
    return this._algorithm;
  }
  public CommitmentPolicy dtor_commitmentPolicy() {
    return this._commitmentPolicy;
  }
}
