/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsKeyring_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsKmsKeyring_Compile.DecryptSingleEncryptedDataKey;
import AwsKmsKeyring_Compile.KmsGenerateAndWrapKeyMaterial;
import AwsKmsKeyring_Compile.KmsWrapInfo;
import AwsKmsKeyring_Compile.KmsWrapKeyMaterial;
import AwsKmsKeyring_Compile.OnDecryptEncryptedDataKeyFilter;
import BoundedInts_Compile.uint8;
import Constants_Compile.__default;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    public AwsKmsIdentifier _awsKmsArn = null;
    private static final TypeDescriptor<AwsKmsKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsKeyring.class, () -> null);

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out2 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out2;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out2 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out2;
    }

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _0_parsedAwsKmsId = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(awsKmsKey);
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._awsKmsArn = _0_parsedAwsKmsId.dtor_value();
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        EncryptionMaterials _0_materials = input.dtor_materials();
        AlgorithmSuiteInfo _1_suite = input.dtor_materials().dtor_algorithmSuite();
        Result<DafnyMap, Error> _2_valueOrError0 = Result.Default(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), DafnyMap.empty());
        _2_valueOrError0 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_materials().dtor_encryptionContext());
        if (_2_valueOrError0.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            res = _2_valueOrError0.PropagateFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnyMap _3_stringifiedEncCtx = _2_valueOrError0.Extract((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        KmsGenerateAndWrapKeyMaterial _nw0 = new KmsGenerateAndWrapKeyMaterial();
        _nw0.__ctor(this.client(), this.awsKmsKey(), this.grantTokens());
        KmsGenerateAndWrapKeyMaterial _4_kmsGenerateAndWrap = _nw0;
        KmsWrapKeyMaterial _nw1 = new KmsWrapKeyMaterial();
        _nw1.__ctor(this.client(), this.awsKmsKey(), this.grantTokens());
        KmsWrapKeyMaterial _5_kmsWrap = _nw1;
        Result<WrapEdkMaterialOutput<KmsWrapInfo>, Error> _6_valueOrError1 = Result.Default(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor(), WrapEdkMaterialOutput.Default(KmsWrapInfo._typeDescriptor(), KmsWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<KmsWrapInfo>, Error> _out0 = EdkWrapping_Compile.__default.WrapEdkMaterial(KmsWrapInfo._typeDescriptor(), _0_materials, _5_kmsWrap, _4_kmsGenerateAndWrap);
        _6_valueOrError1 = _out0;
        if (_6_valueOrError1.IsFailure(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _6_valueOrError1.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<KmsWrapInfo> _7_wrapOutput = _6_valueOrError1.Extract(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor());
        DafnySequence<? extends Character> _8_kmsKeyArn = _7_wrapOutput.dtor_wrapInfo().dtor_kmsKeyArn();
        Option<Object> _9_symmetricSigningKeyList = _7_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())), DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_7_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())));
        Result<DafnySequence<? extends Byte>, Error> _10_valueOrError2 = Result.Default(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), ValidUTF8Bytes.defaultValue());
        _10_valueOrError2 = UTF8.__default.Encode(_8_kmsKeyArn).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_10_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            res = _10_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Byte> _11_providerInfo = _10_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _12_valueOrError3 = Outcome.Default(Error._typeDescriptor());
        _12_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_11_providerInfo.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GenerateDataKey: Key ID too long.")));
        if (_12_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _12_valueOrError3.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        EncryptedDataKey _13_edk = EncryptedDataKey.create(__default.PROVIDER__ID(), _11_providerInfo, _7_wrapOutput.dtor_wrappedMaterial());
        if (_7_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _14_valueOrError4 = null;
            _14_valueOrError4 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_0_materials, _7_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_13_edk}), _9_symmetricSigningKeyList);
            if (_14_valueOrError4.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _14_valueOrError4.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _15_result = _14_valueOrError4.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput.create(_15_result));
            return res;
        }
        if (_7_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _16_valueOrError5 = null;
            _16_valueOrError5 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_0_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_13_edk}), _9_symmetricSigningKeyList);
            if (_16_valueOrError5.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _16_valueOrError5.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _17_result = _16_valueOrError5.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput.create(_17_result));
            return res;
        }
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out1;
        Result<OnDecryptOutput, Error> res = null;
        DecryptionMaterials _0_materials = input.dtor_materials();
        AlgorithmSuiteInfo _1_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Error> _2_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _2_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_0_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_2_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _2_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Error> _3_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _3_valueOrError1 = AwsKmsUtils_Compile.__default.OkForDecrypt(this.awsKmsArn(), this.awsKmsKey());
        if (_3_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _3_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        OnDecryptEncryptedDataKeyFilter _nw0 = new OnDecryptEncryptedDataKeyFilter();
        _nw0.__ctor(this.awsKmsKey());
        OnDecryptEncryptedDataKeyFilter _4_filter = _nw0;
        Result<DafnySequence, Error> _5_valueOrError2 = Result.Default(DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out0 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _4_filter, input.dtor_encryptedDataKeys());
        _5_valueOrError2 = _out0;
        if (_5_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _5_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _6_edksToAttempt = _5_valueOrError2.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_6_edksToAttempt.length()).signum() == 0) {
            Result<DafnySequence, Error> _7_valueOrError3 = Result.Default(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _7_valueOrError3 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_7_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _7_valueOrError3.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _8_errorMessage = _7_valueOrError3.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            res = Result.create_Failure(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_8_errorMessage));
            return res;
        }
        DecryptSingleEncryptedDataKey _nw1 = new DecryptSingleEncryptedDataKey();
        _nw1.__ctor(_0_materials, this.client(), this.awsKmsKey(), this.grantTokens());
        DecryptSingleEncryptedDataKey _9_decryptClosure = _nw1;
        Result<DecryptionMaterials, DafnySequence<Error>> _10_outcome = _out1 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _9_decryptClosure, _6_edksToAttempt);
        Result<DecryptionMaterials, Error> _11_valueOrError4 = null;
        _11_valueOrError4 = _10_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _12_errors_boxed0 -> {
            DafnySequence _12_errors = _12_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_12_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_11_valueOrError4.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _11_valueOrError4.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _13_SealedDecryptionMaterials = _11_valueOrError4.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput.create(_13_SealedDecryptionMaterials));
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public AwsKmsIdentifier awsKmsArn() {
        return this._awsKmsArn;
    }

    public static TypeDescriptor<AwsKmsKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsKeyring.AwsKmsKeyring";
    }
}

