/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.internaldafny.types;

import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;

public class DecryptionMaterials {
    public AlgorithmSuiteInfo _algorithmSuite;
    public DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> _encryptionContext;
    public DafnySequence<? extends DafnySequence<? extends Byte>> _requiredEncryptionContextKeys;
    public Option<DafnySequence<? extends Byte>> _plaintextDataKey;
    public Option<DafnySequence<? extends Byte>> _verificationKey;
    public Option<DafnySequence<? extends Byte>> _symmetricSigningKey;
    private static final DecryptionMaterials theDefault = DecryptionMaterials.create(AlgorithmSuiteInfo.Default(), (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)DafnyMap.empty(), (DafnySequence<? extends DafnySequence<? extends Byte>>)DafnySequence.empty(ValidUTF8Bytes._typeDescriptor()), Option.Default(), Option.Default(), Option.Default());
    private static final TypeDescriptor<DecryptionMaterials> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptionMaterials.class, () -> DecryptionMaterials.Default());

    public DecryptionMaterials(AlgorithmSuiteInfo algorithmSuite, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext, DafnySequence<? extends DafnySequence<? extends Byte>> requiredEncryptionContextKeys, Option<DafnySequence<? extends Byte>> plaintextDataKey, Option<DafnySequence<? extends Byte>> verificationKey, Option<DafnySequence<? extends Byte>> symmetricSigningKey) {
        this._algorithmSuite = algorithmSuite;
        this._encryptionContext = encryptionContext;
        this._requiredEncryptionContextKeys = requiredEncryptionContextKeys;
        this._plaintextDataKey = plaintextDataKey;
        this._verificationKey = verificationKey;
        this._symmetricSigningKey = symmetricSigningKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        DecryptionMaterials o = (DecryptionMaterials)other;
        return Objects.equals(this._algorithmSuite, o._algorithmSuite) && Objects.equals(this._encryptionContext, o._encryptionContext) && Objects.equals(this._requiredEncryptionContextKeys, o._requiredEncryptionContextKeys) && Objects.equals(this._plaintextDataKey, o._plaintextDataKey) && Objects.equals(this._verificationKey, o._verificationKey) && Objects.equals(this._symmetricSigningKey, o._symmetricSigningKey);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._algorithmSuite);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._encryptionContext);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._requiredEncryptionContextKeys);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._plaintextDataKey);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._verificationKey);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._symmetricSigningKey);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyMaterialProvidersTypes.DecryptionMaterials.DecryptionMaterials");
        s.append("(");
        s.append(Helpers.toString((Object)this._algorithmSuite));
        s.append(", ");
        s.append(Helpers.toString(this._encryptionContext));
        s.append(", ");
        s.append(Helpers.toString(this._requiredEncryptionContextKeys));
        s.append(", ");
        s.append(Helpers.toString(this._plaintextDataKey));
        s.append(", ");
        s.append(Helpers.toString(this._verificationKey));
        s.append(", ");
        s.append(Helpers.toString(this._symmetricSigningKey));
        s.append(")");
        return s.toString();
    }

    public static DecryptionMaterials Default() {
        return theDefault;
    }

    public static TypeDescriptor<DecryptionMaterials> _typeDescriptor() {
        return _TYPE;
    }

    public static DecryptionMaterials create(AlgorithmSuiteInfo algorithmSuite, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext, DafnySequence<? extends DafnySequence<? extends Byte>> requiredEncryptionContextKeys, Option<DafnySequence<? extends Byte>> plaintextDataKey, Option<DafnySequence<? extends Byte>> verificationKey, Option<DafnySequence<? extends Byte>> symmetricSigningKey) {
        return new DecryptionMaterials(algorithmSuite, encryptionContext, requiredEncryptionContextKeys, plaintextDataKey, verificationKey, symmetricSigningKey);
    }

    public static DecryptionMaterials create_DecryptionMaterials(AlgorithmSuiteInfo algorithmSuite, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext, DafnySequence<? extends DafnySequence<? extends Byte>> requiredEncryptionContextKeys, Option<DafnySequence<? extends Byte>> plaintextDataKey, Option<DafnySequence<? extends Byte>> verificationKey, Option<DafnySequence<? extends Byte>> symmetricSigningKey) {
        return DecryptionMaterials.create(algorithmSuite, encryptionContext, requiredEncryptionContextKeys, plaintextDataKey, verificationKey, symmetricSigningKey);
    }

    public boolean is_DecryptionMaterials() {
        return true;
    }

    public AlgorithmSuiteInfo dtor_algorithmSuite() {
        return this._algorithmSuite;
    }

    public DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> dtor_encryptionContext() {
        return this._encryptionContext;
    }

    public DafnySequence<? extends DafnySequence<? extends Byte>> dtor_requiredEncryptionContextKeys() {
        return this._requiredEncryptionContextKeys;
    }

    public Option<DafnySequence<? extends Byte>> dtor_plaintextDataKey() {
        return this._plaintextDataKey;
    }

    public Option<DafnySequence<? extends Byte>> dtor_verificationKey() {
        return this._verificationKey;
    }

    public Option<DafnySequence<? extends Byte>> dtor_symmetricSigningKey() {
        return this._symmetricSigningKey;
    }
}

