/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.services.kms.internaldafny.types;

import dafny.TypeDescriptor;
import java.util.ArrayList;
import software.amazon.cryptography.services.kms.internaldafny.types.KeySpec_ECC__NIST__P256;
import software.amazon.cryptography.services.kms.internaldafny.types.KeySpec_ECC__NIST__P384;
import software.amazon.cryptography.services.kms.internaldafny.types.KeySpec_ECC__NIST__P521;
import software.amazon.cryptography.services.kms.internaldafny.types.KeySpec_ECC__SECG__P256K1;
import software.amazon.cryptography.services.kms.internaldafny.types.KeySpec_RSA__2048;
import software.amazon.cryptography.services.kms.internaldafny.types.KeySpec_RSA__3072;
import software.amazon.cryptography.services.kms.internaldafny.types.KeySpec_RSA__4096;
import software.amazon.cryptography.services.kms.internaldafny.types.KeySpec_SYMMETRIC__DEFAULT;

public abstract class KeySpec {
    private static final KeySpec theDefault = KeySpec.create_RSA__2048();
    private static final TypeDescriptor<KeySpec> _TYPE = TypeDescriptor.referenceWithInitializer(KeySpec.class, () -> KeySpec.Default());

    public static KeySpec Default() {
        return theDefault;
    }

    public static TypeDescriptor<KeySpec> _typeDescriptor() {
        return _TYPE;
    }

    public static KeySpec create_RSA__2048() {
        return new KeySpec_RSA__2048();
    }

    public static KeySpec create_RSA__3072() {
        return new KeySpec_RSA__3072();
    }

    public static KeySpec create_RSA__4096() {
        return new KeySpec_RSA__4096();
    }

    public static KeySpec create_ECC__NIST__P256() {
        return new KeySpec_ECC__NIST__P256();
    }

    public static KeySpec create_ECC__NIST__P384() {
        return new KeySpec_ECC__NIST__P384();
    }

    public static KeySpec create_ECC__NIST__P521() {
        return new KeySpec_ECC__NIST__P521();
    }

    public static KeySpec create_ECC__SECG__P256K1() {
        return new KeySpec_ECC__SECG__P256K1();
    }

    public static KeySpec create_SYMMETRIC__DEFAULT() {
        return new KeySpec_SYMMETRIC__DEFAULT();
    }

    public boolean is_RSA__2048() {
        return this instanceof KeySpec_RSA__2048;
    }

    public boolean is_RSA__3072() {
        return this instanceof KeySpec_RSA__3072;
    }

    public boolean is_RSA__4096() {
        return this instanceof KeySpec_RSA__4096;
    }

    public boolean is_ECC__NIST__P256() {
        return this instanceof KeySpec_ECC__NIST__P256;
    }

    public boolean is_ECC__NIST__P384() {
        return this instanceof KeySpec_ECC__NIST__P384;
    }

    public boolean is_ECC__NIST__P521() {
        return this instanceof KeySpec_ECC__NIST__P521;
    }

    public boolean is_ECC__SECG__P256K1() {
        return this instanceof KeySpec_ECC__SECG__P256K1;
    }

    public boolean is_SYMMETRIC__DEFAULT() {
        return this instanceof KeySpec_SYMMETRIC__DEFAULT;
    }

    public static ArrayList<KeySpec> AllSingletonConstructors() {
        ArrayList<KeySpec> singleton_iterator = new ArrayList<KeySpec>();
        singleton_iterator.add(new KeySpec_RSA__2048());
        singleton_iterator.add(new KeySpec_RSA__3072());
        singleton_iterator.add(new KeySpec_RSA__4096());
        singleton_iterator.add(new KeySpec_ECC__NIST__P256());
        singleton_iterator.add(new KeySpec_ECC__NIST__P384());
        singleton_iterator.add(new KeySpec_ECC__NIST__P521());
        singleton_iterator.add(new KeySpec_ECC__SECG__P256K1());
        singleton_iterator.add(new KeySpec_SYMMETRIC__DEFAULT());
        return singleton_iterator;
    }
}

