/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsRsaKeyring_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsKmsRsaKeyring_Compile.DecryptSingleAWSRSAEncryptedDataKey;
import AwsKmsRsaKeyring_Compile.KmsRsaGenerateAndWrapKeyMaterial;
import AwsKmsRsaKeyring_Compile.KmsRsaWrapInfo;
import AwsKmsRsaKeyring_Compile.KmsRsaWrapKeyMaterial;
import AwsKmsRsaKeyring_Compile.__default;
import AwsKmsUtils_Compile.OnDecryptMrkAwareEncryptedDataKeyFilter;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptionAlgorithmSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsRsaKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public Option<IKMSClient> _client = Option.Default();
    public EncryptionAlgorithmSpec _paddingScheme = EncryptionAlgorithmSpec.Default();
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public Option<DafnySequence<? extends Byte>> _publicKey = Option.Default();
    public AwsKmsIdentifier _awsKmsArn = null;
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<AwsKmsRsaKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsRsaKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out136 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out136;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out137 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out137;
    }

    public void __ctor(Option<DafnySequence<? extends Byte>> publicKey, DafnySequence<? extends Character> awsKmsKey, EncryptionAlgorithmSpec paddingScheme, Option<IKMSClient> client, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _797_parsedAwsKmsId = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(awsKmsKey);
        this._publicKey = publicKey;
        this._awsKmsKey = awsKmsKey;
        this._awsKmsArn = _797_parsedAwsKmsId.dtor_value();
        this._paddingScheme = paddingScheme;
        this._client = client;
        this._cryptoPrimitives = cryptoPrimitives;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        Outcome<Object> _798_valueOrError0 = Outcome.Default();
        _798_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.publicKey().is_Some() && BigInteger.valueOf(this.publicKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())).length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A AwsKmsRsaKeyring without a public key cannot provide OnEncrypt")));
        if (_798_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _798_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Object> _799_valueOrError1 = Outcome.Default();
        _799_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_algorithmSuite().dtor_signature().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"AwsKmsRsaKeyring cannot be used with an Algorithm Suite with asymmetric signing."), (DafnySequence)DafnySequence.asString((String)" Please specify an algorithm suite without asymmetric signing."))));
        if (_799_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _799_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        KmsRsaWrapKeyMaterial _nw38 = new KmsRsaWrapKeyMaterial();
        _nw38.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        KmsRsaWrapKeyMaterial _800_wrap = _nw38;
        KmsRsaGenerateAndWrapKeyMaterial _nw39 = new KmsRsaGenerateAndWrapKeyMaterial();
        _nw39.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        KmsRsaGenerateAndWrapKeyMaterial _801_generateAndWrap = _nw39;
        Result<WrapEdkMaterialOutput<KmsRsaWrapInfo>, Object> _803_valueOrError2 = Result.Default(WrapEdkMaterialOutput.Default(KmsRsaWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<KmsRsaWrapInfo>, Error> _out138 = EdkWrapping_Compile.__default.WrapEdkMaterial(KmsRsaWrapInfo._typeDescriptor(), input.dtor_materials(), _800_wrap, _801_generateAndWrap);
        _803_valueOrError2 = _out138;
        if (_803_valueOrError2.IsFailure(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _803_valueOrError2.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<KmsRsaWrapInfo> _802_wrapOutput = _803_valueOrError2.Extract(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _804_symmetricSigningKeyList = _802_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_802_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _805_edk = EncryptedDataKey.create(Constants_Compile.__default.RSA__PROVIDER__ID(), UTF8.__default.Encode(this.awsKmsKey()).dtor_value(), _802_wrapOutput.dtor_wrappedMaterial());
        EncryptionMaterials _806_returnMaterials = null;
        if (_802_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _807_valueOrError3 = null;
            _807_valueOrError3 = Materials_Compile.__default.EncryptionMaterialAddDataKey(input.dtor_materials(), _802_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_805_edk}), _804_symmetricSigningKeyList);
            if (_807_valueOrError3.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _807_valueOrError3.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _806_returnMaterials = _807_valueOrError3.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        } else if (_802_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _808_valueOrError4 = null;
            _808_valueOrError4 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(input.dtor_materials(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_805_edk}), _804_symmetricSigningKeyList);
            if (_808_valueOrError4.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _808_valueOrError4.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _806_returnMaterials = _808_valueOrError4.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        }
        res = Result.create_Success(OnEncryptOutput.create(_806_returnMaterials));
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out141;
        Result<OnDecryptOutput, Error> res = null;
        Outcome<Object> _809_valueOrError0 = Outcome.Default();
        _809_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.client().is_Some(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"An AwsKmsRsaKeyring without an AWS KMS client cannot provide OnDecrypt")));
        if (_809_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _809_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _810_materials = input.dtor_materials();
        Outcome<Object> _811_valueOrError1 = Outcome.Default();
        _811_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_810_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_811_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _811_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Object> _812_valueOrError2 = Outcome.Default();
        _812_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_algorithmSuite().dtor_signature().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"AwsKmsRsaKeyring cannot be used with an Algorithm Suite with asymmetric signing."), (DafnySequence)DafnySequence.asString((String)" Please specify an algorithm suite without asymmetric signing."))));
        if (_812_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _812_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        OnDecryptMrkAwareEncryptedDataKeyFilter _nw40 = new OnDecryptMrkAwareEncryptedDataKeyFilter();
        _nw40.__ctor(this.awsKmsArn(), Constants_Compile.__default.RSA__PROVIDER__ID());
        OnDecryptMrkAwareEncryptedDataKeyFilter _813_filter = _nw40;
        Result<Object, Object> _815_valueOrError3 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out139 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _813_filter, input.dtor_encryptedDataKeys());
        _815_valueOrError3 = _out139;
        if (_815_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _815_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _814_edksToAttempt = (DafnySequence)_815_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        Outcome<Object> _816_valueOrError4 = Outcome.Default();
        _816_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_814_edksToAttempt.length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to decrypt data key: No Encrypted Data Keys found to match.")));
        if (_816_valueOrError4.IsFailure(Error._typeDescriptor())) {
            res = _816_valueOrError4.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Result<Object, Object> _818_valueOrError5 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out140 = __default.EncryptionContextDigest(this.cryptoPrimitives(), _810_materials.dtor_encryptionContext());
        _818_valueOrError5 = _out140;
        if (_818_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _818_valueOrError5.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _817_encryptionContextDigest = (DafnySequence)_818_valueOrError5.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        DecryptSingleAWSRSAEncryptedDataKey _nw41 = new DecryptSingleAWSRSAEncryptedDataKey();
        _nw41.__ctor(_810_materials, this.client().dtor_value(), this.awsKmsKey(), this.paddingScheme(), (DafnySequence<? extends Byte>)_817_encryptionContextDigest, this.grantTokens());
        DecryptSingleAWSRSAEncryptedDataKey _819_decryptClosure = _nw41;
        Result<DecryptionMaterials, DafnySequence<Error>> _820_outcome = _out141 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _819_decryptClosure, _814_edksToAttempt);
        Result<DecryptionMaterials, Error> _822_valueOrError6 = null;
        _822_valueOrError6 = _820_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _823_errors_boxed0 -> {
            DafnySequence _823_errors = _823_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_823_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_822_valueOrError6.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _822_valueOrError6.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _821_SealedDecryptionMaterials = _822_valueOrError6.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_821_SealedDecryptionMaterials));
        return res;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public Option<IKMSClient> client() {
        return this._client;
    }

    public EncryptionAlgorithmSpec paddingScheme() {
        return this._paddingScheme;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public Option<DafnySequence<? extends Byte>> publicKey() {
        return this._publicKey;
    }

    public AwsKmsIdentifier awsKmsArn() {
        return this._awsKmsArn;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<AwsKmsRsaKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsRsaKeyring_Compile.AwsKmsRsaKeyring";
    }
}

