/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.internaldafny.types;

import Wrappers_Compile.Option;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.internaldafny.types.CommitmentPolicy;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;

public class DecryptMaterialsInput {
    public AlgorithmSuiteId _algorithmSuiteId;
    public CommitmentPolicy _commitmentPolicy;
    public DafnySequence<? extends EncryptedDataKey> _encryptedDataKeys;
    public DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> _encryptionContext;
    public Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> _reproducedEncryptionContext;
    private static final DecryptMaterialsInput theDefault = DecryptMaterialsInput.create(AlgorithmSuiteId.Default(), CommitmentPolicy.Default(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.empty(EncryptedDataKey._typeDescriptor()), (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)DafnyMap.empty(), Option.Default());
    private static final TypeDescriptor<DecryptMaterialsInput> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptMaterialsInput.class, () -> DecryptMaterialsInput.Default());

    public DecryptMaterialsInput(AlgorithmSuiteId algorithmSuiteId, CommitmentPolicy commitmentPolicy, DafnySequence<? extends EncryptedDataKey> encryptedDataKeys, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext, Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> reproducedEncryptionContext) {
        this._algorithmSuiteId = algorithmSuiteId;
        this._commitmentPolicy = commitmentPolicy;
        this._encryptedDataKeys = encryptedDataKeys;
        this._encryptionContext = encryptionContext;
        this._reproducedEncryptionContext = reproducedEncryptionContext;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        DecryptMaterialsInput o = (DecryptMaterialsInput)other;
        return Objects.equals(this._algorithmSuiteId, o._algorithmSuiteId) && Objects.equals(this._commitmentPolicy, o._commitmentPolicy) && Objects.equals(this._encryptedDataKeys, o._encryptedDataKeys) && Objects.equals(this._encryptionContext, o._encryptionContext) && Objects.equals(this._reproducedEncryptionContext, o._reproducedEncryptionContext);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._algorithmSuiteId);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._commitmentPolicy);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._encryptedDataKeys);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._encryptionContext);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._reproducedEncryptionContext);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("software.amazon.cryptography.materialproviders.internaldafny.types_Compile.DecryptMaterialsInput.DecryptMaterialsInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._algorithmSuiteId));
        s.append(", ");
        s.append(Helpers.toString((Object)this._commitmentPolicy));
        s.append(", ");
        s.append(Helpers.toString(this._encryptedDataKeys));
        s.append(", ");
        s.append(Helpers.toString(this._encryptionContext));
        s.append(", ");
        s.append(Helpers.toString(this._reproducedEncryptionContext));
        s.append(")");
        return s.toString();
    }

    public static DecryptMaterialsInput Default() {
        return theDefault;
    }

    public static TypeDescriptor<DecryptMaterialsInput> _typeDescriptor() {
        return _TYPE;
    }

    public static DecryptMaterialsInput create(AlgorithmSuiteId algorithmSuiteId, CommitmentPolicy commitmentPolicy, DafnySequence<? extends EncryptedDataKey> encryptedDataKeys, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext, Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> reproducedEncryptionContext) {
        return new DecryptMaterialsInput(algorithmSuiteId, commitmentPolicy, encryptedDataKeys, encryptionContext, reproducedEncryptionContext);
    }

    public static DecryptMaterialsInput create_DecryptMaterialsInput(AlgorithmSuiteId algorithmSuiteId, CommitmentPolicy commitmentPolicy, DafnySequence<? extends EncryptedDataKey> encryptedDataKeys, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext, Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> reproducedEncryptionContext) {
        return DecryptMaterialsInput.create(algorithmSuiteId, commitmentPolicy, encryptedDataKeys, encryptionContext, reproducedEncryptionContext);
    }

    public boolean is_DecryptMaterialsInput() {
        return true;
    }

    public AlgorithmSuiteId dtor_algorithmSuiteId() {
        return this._algorithmSuiteId;
    }

    public CommitmentPolicy dtor_commitmentPolicy() {
        return this._commitmentPolicy;
    }

    public DafnySequence<? extends EncryptedDataKey> dtor_encryptedDataKeys() {
        return this._encryptedDataKeys;
    }

    public DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> dtor_encryptionContext() {
        return this._encryptionContext;
    }

    public Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> dtor_reproducedEncryptionContext() {
        return this._reproducedEncryptionContext;
    }
}

