/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.internaldafny;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsCryptographyKeyStoreOperations_Compile.Config;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.keystore.internaldafny.KeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.__default;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient;
import software.amazon.cryptography.services.dynamodb.internaldafny.types._Companion_IDynamoDBClient;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types._Companion_IKMSClient;

public abstract class _ExternBase___default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static KeyStoreConfig DefaultKeyStoreConfig() {
        return KeyStoreConfig.create((DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), KMSConfiguration.create((DafnySequence<? extends Character>)DafnySequence.asString((String)"1234abcd-12ab-34cd-56ef-1234567890ab")), (DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), Option.create_None(), Option.create_None(), Option.create_None(), Option.create_None());
    }

    public static Result<KeyStoreClient, Error> KeyStore(KeyStoreConfig config) {
        Result<KeyStoreClient, Error> res = null;
        Outcome<Object> _1328_valueOrError0 = Outcome.Default();
        _1328_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__KeyIdType(config.dtor_kmsConfiguration().dtor_kmsKeyArn()) && AwsArnParsing_Compile.__default.ParseAwsKmsArn(config.dtor_kmsConfiguration().dtor_kmsKeyArn()).is_Success(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid AWS KMS Key Arn")));
        if (_1328_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1328_valueOrError0.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        Result<DafnySequence<? extends DafnySequence<? extends Character>>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1329_grantTokens = AwsKmsUtils_Compile.__default.GetValidGrantTokens(config.dtor_grantTokens());
        Outcome<Object> _1330_valueOrError1 = Outcome.Default();
        _1330_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _1329_grantTokens.is_Success(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"CreateKey received invalid grant tokens")));
        if (_1330_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _1330_valueOrError1.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        DafnySequence _1331_keyStoreId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
        if (config.dtor_id().is_Some()) {
            _1331_keyStoreId = config.dtor_id().dtor_value();
        } else {
            DafnySequence _1333_uuid;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _out246;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _1332_maybeUuid = _out246 = UUID.__default.GenerateUUID();
            Result<Object, Object> _1334_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _1334_valueOrError2 = _1332_maybeUuid.MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _1335_e_boxed0 -> {
                DafnySequence _1335_e = _1335_e_boxed0;
                return Error.create_KeyStoreException((DafnySequence<? extends Character>)_1335_e);
            });
            if (_1334_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _1334_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _1331_keyStoreId = _1333_uuid = (DafnySequence)_1334_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        }
        IKMSClient _1336_kmsClient = null;
        IDynamoDBClient _1337_ddbClient = null;
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _1338_keyArn = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(config.dtor_kmsConfiguration().dtor_kmsKeyArn());
        Option<DafnySequence<? extends Character>> _1339_kmsRegion = AwsArnParsing_Compile.__default.GetRegion(_1338_keyArn.dtor_value());
        if (config.dtor_kmsClient().is_None()) {
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out247;
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _1340_maybeKmsClient = _out247 = software.amazon.cryptography.services.kms.internaldafny.__default.KMSClientForRegion(_1339_kmsRegion.dtor_value());
            Result<IKMSClient, Error> _1341_valueOrError3 = null;
            _1341_valueOrError3 = _1340_maybeKmsClient.MapFailure(_Companion_IKMSClient._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _1342_e_boxed0 -> {
                software.amazon.cryptography.services.kms.internaldafny.types.Error _1342_e = _1342_e_boxed0;
                return Error.create_ComAmazonawsKms(_1342_e);
            });
            if (_1341_valueOrError3.IsFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _1341_valueOrError3.PropagateFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _1336_kmsClient = _1341_valueOrError3.Extract(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            _1336_kmsClient = config.dtor_kmsClient().dtor_value();
        }
        if (config.dtor_ddbClient().is_None()) {
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _out248;
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _1343_maybeDdbClient = _out248 = software.amazon.cryptography.services.dynamodb.internaldafny.__default.DDBClientForRegion(_1339_kmsRegion.dtor_value());
            Result<IDynamoDBClient, Error> _1344_valueOrError4 = null;
            _1344_valueOrError4 = _1343_maybeDdbClient.MapFailure(_Companion_IDynamoDBClient._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _1345_e_boxed0 -> {
                software.amazon.cryptography.services.dynamodb.internaldafny.types.Error _1345_e = _1345_e_boxed0;
                return Error.create_ComAmazonawsDynamodb(_1345_e);
            });
            if (_1344_valueOrError4.IsFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _1344_valueOrError4.PropagateFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _1337_ddbClient = _1344_valueOrError4.Extract(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            _1337_ddbClient = config.dtor_ddbClient().dtor_value();
        }
        Outcome<Object> _1346_valueOrError5 = Outcome.Default();
        _1346_valueOrError5 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__TableName(config.dtor_ddbTableName()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Amazon DynamoDB Table Name")));
        if (_1346_valueOrError5.IsFailure(Error._typeDescriptor())) {
            res = _1346_valueOrError5.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        KeyStoreClient _nw72 = new KeyStoreClient();
        _nw72.__ctor(Config.create((DafnySequence<? extends Character>)_1331_keyStoreId, config.dtor_ddbTableName(), config.dtor_logicalKeyStoreName(), config.dtor_kmsConfiguration(), _1329_grantTokens.dtor_value(), _1336_kmsClient, _1337_ddbClient));
        KeyStoreClient _1347_client = _nw72;
        res = Result.create_Success(_1347_client);
        return res;
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "software.amazon.cryptography.keystore.internaldafny_Compile._default";
    }
}

