/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.internaldafny.StormTrackingCMC;

import StormTracker_Compile.CacheState;
import StormTracker_Compile.StormTracker;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Tuple0;
import software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.UpdateUsageMetadataInput;

public class StormTrackingCMC
implements ICryptographicMaterialsCache {
    private StormTracker wrapped;

    public StormTrackingCMC(StormTracker wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public synchronized Result<Tuple0, Error> PutCacheEntry(PutCacheEntryInput input) {
        return this.wrapped.PutCacheEntry(input);
    }

    @Override
    public synchronized Result<Tuple0, Error> UpdateUsageMetadata(UpdateUsageMetadataInput input) {
        return this.wrapped.UpdateUsageMetadata(input);
    }

    @Override
    public Result<GetCacheEntryOutput, Error> GetCacheEntry(GetCacheEntryInput input) {
        return this.GetCacheEntry_k(input);
    }

    @Override
    public synchronized Result<Tuple0, Error> DeleteCacheEntry(DeleteCacheEntryInput input) {
        return this.wrapped.DeleteCacheEntry(input);
    }

    @Override
    public synchronized Result<Tuple0, Error> PutCacheEntry_k(PutCacheEntryInput input) {
        return this.wrapped.PutCacheEntry(input);
    }

    @Override
    public synchronized Result<Tuple0, Error> UpdateUsageMetadata_k(UpdateUsageMetadataInput input) {
        return this.wrapped.UpdateUsageMetadata(input);
    }

    public synchronized Result<CacheState, Error> GetFromCacheInner(GetCacheEntryInput input) {
        return this.wrapped.GetFromCache(input);
    }

    @Override
    public Result<GetCacheEntryOutput, Error> GetCacheEntry_k(GetCacheEntryInput input) {
        Result<CacheState, Error> result;
        while (!(result = this.GetFromCacheInner(input)).is_Failure()) {
            if (result.dtor_value().is_Full()) {
                return Result.create_Success(result.dtor_value().dtor_data());
            }
            if (result.dtor_value().is_EmptyFetch()) {
                return Result.create_Failure(Error.create_EntryDoesNotExist((DafnySequence<? extends Character>)DafnySequence.asString((String)"Entry does not exist")));
            }
            try {
                Thread.sleep(this.wrapped.sleepMilli);
            }
            catch (Exception exception) {
            }
        }
        return Result.create_Failure(result.dtor_error());
    }

    @Override
    public synchronized Result<Tuple0, Error> DeleteCacheEntry_k(DeleteCacheEntryInput input) {
        return this.wrapped.DeleteCacheEntry(input);
    }

    public String toString() {
        return "StormTracker_Compile.StormTrackerCMC";
    }
}

