/*
 * Decompiled with CFR 0.152.
 */
package StandardLibrary_mUInt_Compile;

import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;

public class __default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static boolean UInt8Less(byte a, byte b) {
        return Integer.compareUnsigned(a, b) < 0;
    }

    public static <__T> boolean HasUint16Len(TypeDescriptor<__T> _td___T, DafnySequence<? extends __T> s) {
        return BigInteger.valueOf(s.length()).compareTo(__default.UINT16__LIMIT()) < 0;
    }

    public static <__T> boolean HasUint32Len(TypeDescriptor<__T> _td___T, DafnySequence<? extends __T> s) {
        return BigInteger.valueOf(s.length()).compareTo(__default.UINT32__LIMIT()) < 0;
    }

    public static <__T> boolean HasUint64Len(TypeDescriptor<__T> _td___T, DafnySequence<? extends __T> s) {
        return BigInteger.valueOf(s.length()).compareTo(__default.UINT64__LIMIT()) < 0;
    }

    public static DafnySequence<? extends Byte> UInt16ToSeq(short x) {
        byte _74_b0 = (byte)Helpers.divideUnsignedShort((short)x, (short)256);
        byte _75_b1 = (byte)Helpers.remainderUnsignedShort((short)x, (short)256);
        return DafnySequence.of((byte[])new byte[]{_74_b0, _75_b1});
    }

    public static short SeqToUInt16(DafnySequence<? extends Byte> s) {
        short _76_x0 = (short)((short)Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))) * 256);
        return (short)(_76_x0 + (short)Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ONE))));
    }

    public static DafnySequence<? extends Byte> UInt32ToSeq(int x) {
        byte _77_b0 = (byte)Integer.divideUnsigned(x, 0x1000000);
        int _78_x0 = x - Byte.toUnsignedInt(_77_b0) * 0x1000000;
        byte _79_b1 = (byte)Integer.divideUnsigned(_78_x0, 65536);
        int _80_x1 = _78_x0 - Byte.toUnsignedInt(_79_b1) * 65536;
        byte _81_b2 = (byte)Integer.divideUnsigned(_80_x1, 256);
        byte _82_b3 = (byte)Integer.remainderUnsigned(_80_x1, 256);
        return DafnySequence.of((byte[])new byte[]{_77_b0, _79_b1, _81_b2, _82_b3});
    }

    public static int SeqToUInt32(DafnySequence<? extends Byte> s) {
        int _83_x0 = Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))) * 0x1000000;
        int _84_x1 = _83_x0 + Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ONE))) * 65536;
        int _85_x2 = _84_x1 + Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))) * 256;
        return _85_x2 + Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L))));
    }

    public static DafnySequence<? extends Byte> UInt64ToSeq(long x) {
        byte _86_b0 = (byte)Long.divideUnsigned(x, 0x100000000000000L);
        long _87_x0 = x - Byte.toUnsignedLong(_86_b0) * 0x100000000000000L;
        byte _88_b1 = (byte)Long.divideUnsigned(_87_x0, 0x1000000000000L);
        long _89_x1 = _87_x0 - Byte.toUnsignedLong(_88_b1) * 0x1000000000000L;
        byte _90_b2 = (byte)Long.divideUnsigned(_89_x1, 0x10000000000L);
        long _91_x2 = _89_x1 - Byte.toUnsignedLong(_90_b2) * 0x10000000000L;
        byte _92_b3 = (byte)Long.divideUnsigned(_91_x2, 0x100000000L);
        long _93_x3 = _91_x2 - Byte.toUnsignedLong(_92_b3) * 0x100000000L;
        byte _94_b4 = (byte)Long.divideUnsigned(_93_x3, 0x1000000L);
        long _95_x4 = _93_x3 - Byte.toUnsignedLong(_94_b4) * 0x1000000L;
        byte _96_b5 = (byte)Long.divideUnsigned(_95_x4, 65536L);
        long _97_x5 = _95_x4 - Byte.toUnsignedLong(_96_b5) * 65536L;
        byte _98_b6 = (byte)Long.divideUnsigned(_97_x5, 256L);
        byte _99_b7 = (byte)Long.remainderUnsigned(_97_x5, 256L);
        return DafnySequence.of((byte[])new byte[]{_86_b0, _88_b1, _90_b2, _92_b3, _94_b4, _96_b5, _98_b6, _99_b7});
    }

    public static long SeqToUInt64(DafnySequence<? extends Byte> s) {
        long _100_x0 = Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))) * 0x100000000000000L;
        long _101_x1 = _100_x0 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ONE))) * 0x1000000000000L;
        long _102_x2 = _101_x1 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))) * 0x10000000000L;
        long _103_x3 = _102_x2 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L)))) * 0x100000000L;
        long _104_x4 = _103_x3 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(4L)))) * 0x1000000L;
        long _105_x5 = _104_x4 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(5L)))) * 65536L;
        long _106_x6 = _105_x5 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(6L)))) * 256L;
        long _107_x = _106_x6 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(7L))));
        return _107_x;
    }

    public static BigInteger UINT16__LIMIT() {
        return BigInteger.valueOf(Short.toUnsignedLong(BoundedInts_Compile.__default.UINT16__MAX())).add(BigInteger.ONE);
    }

    public static BigInteger UINT32__LIMIT() {
        return BigInteger.valueOf(Integer.toUnsignedLong(BoundedInts_Compile.__default.UINT32__MAX())).add(BigInteger.ONE);
    }

    public static BigInteger UINT64__LIMIT() {
        return Helpers.unsignedLongToBigInteger((long)BoundedInts_Compile.__default.UINT64__MAX()).add(BigInteger.ONE);
    }

    public static BigInteger INT32__MAX__LIMIT() {
        return BigInteger.valueOf(BoundedInts_Compile.__default.INT32__MAX());
    }

    public static BigInteger INT64__MAX__LIMIT() {
        return BigInteger.valueOf(BoundedInts_Compile.__default.INT64__MAX());
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "StandardLibrary.StandardLibrary_mUInt_Compile._default";
    }
}

