/*
 * Decompiled with CFR 0.152.
 */
package RSAEncryption;

import Random_Compile.ExternRandom;
import Wrappers_Compile.Result;
import dafny.Array;
import dafny.DafnySequence;
import dafny.Tuple2;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import software.amazon.cryptography.primitives.ToDafny;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode;
import software.amazon.cryptography.primitives.model.OpaqueError;
import software.amazon.smithy.dafny.conversion.ToDafny;

public class RSA {
    private static int RSA_KEY_LEN_MAX = 4096;
    private static int RSA_PUBLIC_EXPONENT = 65537;
    private static int RSA_CERTAINTY = 256;
    private static String RSA_ERROR_MSG = String.format("AWS Crypto will not generate an RSA Key with length greater than %s", RSA_KEY_LEN_MAX);

    public static Tuple2<DafnySequence<? extends Byte>, DafnySequence<? extends Byte>> GenerateKeyPairExtern(int lengthBits) {
        try {
            if (lengthBits > RSA_KEY_LEN_MAX) {
                throw new RuntimeException(RSA_ERROR_MSG);
            }
            RSAKeyPairGenerator keygen = new RSAKeyPairGenerator();
            SecureRandom secureRandom = ExternRandom.getSecureRandom();
            RSAKeyGenerationParameters keyGenerationParameters = new RSAKeyGenerationParameters(BigInteger.valueOf(RSA_PUBLIC_EXPONENT), secureRandom, lengthBits, RSA_CERTAINTY);
            keygen.init((KeyGenerationParameters)keyGenerationParameters);
            AsymmetricCipherKeyPair keyPair = keygen.generateKeyPair();
            return Tuple2.create(RSA.GetPemBytes(keyPair.getPublic()), RSA.GetPemBytes(keyPair.getPrivate()));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create RSA Key Pair");
        }
    }

    public static Result<Integer, Error> GetRSAKeyModulusLengthExtern(DafnySequence<? extends Byte> dtor_publicKey) {
        try {
            byte[] pemBytes = (byte[])Array.unwrap((Array)dtor_publicKey.toArray());
            RSAKeyParameters keyParams = RSA.ParsePublicRsaPemBytes(pemBytes);
            return Result.create_Success(keyParams.getModulus().bitLength());
        }
        catch (Exception e) {
            return Result.create_Failure(ToDafny.Error(OpaqueError.builder().obj(e).message(e.getMessage()).cause(e).build()));
        }
    }

    private static DafnySequence<? extends Byte> GetPemBytes(AsymmetricKeyParameter keyParameter) throws IOException {
        if (keyParameter.isPrivate()) {
            PrivateKeyInfo privateKey = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)keyParameter);
            StringWriter stringWriter = new StringWriter();
            PemWriter pemWriter = new PemWriter((Writer)stringWriter);
            pemWriter.writeObject((PemObjectGenerator)new PemObject("PRIVATE KEY", privateKey.getEncoded()));
            pemWriter.close();
            ByteBuffer outBuffer = StandardCharsets.UTF_8.encode(stringWriter.toString());
            return ToDafny.Simple.ByteSequence((ByteBuffer)outBuffer, (int)0, (int)outBuffer.limit());
        }
        SubjectPublicKeyInfo publicKey = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)keyParameter);
        StringWriter stringWriter = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)stringWriter);
        pemWriter.writeObject((PemObjectGenerator)new PemObject("PUBLIC KEY", publicKey.getEncoded()));
        pemWriter.close();
        ByteBuffer outBuffer = StandardCharsets.UTF_8.encode(stringWriter.toString());
        return ToDafny.Simple.ByteSequence((ByteBuffer)outBuffer, (int)0, (int)outBuffer.limit());
    }

    private static RSAKeyParameters ParsePublicRsaPemBytes(byte[] pem) throws IOException {
        PemReader pemReader = new PemReader((Reader)new InputStreamReader(new ByteArrayInputStream(pem)));
        PemObject pemObject = pemReader.readPemObject();
        byte[] content = pemObject.getContent();
        RSAKeyParameters publicKeyParams = (RSAKeyParameters)PublicKeyFactory.createKey((byte[])content);
        return publicKeyParams;
    }

    private static RSAKeyParameters ParsePrivateRsaPemBytes(byte[] pem) throws IOException {
        PemReader pemReader = new PemReader((Reader)new InputStreamReader(new ByteArrayInputStream(pem)));
        PemObject pemObject = pemReader.readPemObject();
        byte[] content = pemObject.getContent();
        RSAKeyParameters privateKeyParams = (RSAKeyParameters)PrivateKeyFactory.createKey((byte[])content);
        return privateKeyParams;
    }

    private static AsymmetricBlockCipher GetEngineForPadding(RSAPaddingMode paddingMode) {
        if (paddingMode.is_OAEP__SHA1()) {
            return new OAEPEncoding((AsymmetricBlockCipher)new RSABlindedEngine(), (Digest)new SHA1Digest());
        }
        if (paddingMode.is_OAEP__SHA256()) {
            return new OAEPEncoding((AsymmetricBlockCipher)new RSABlindedEngine(), (Digest)new SHA256Digest());
        }
        if (paddingMode.is_OAEP__SHA384()) {
            return new OAEPEncoding((AsymmetricBlockCipher)new RSABlindedEngine(), (Digest)new SHA384Digest());
        }
        if (paddingMode.is_OAEP__SHA512()) {
            return new OAEPEncoding((AsymmetricBlockCipher)new RSABlindedEngine(), (Digest)new SHA512Digest());
        }
        if (paddingMode.is_PKCS1()) {
            return new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
        }
        throw new RuntimeException(String.format("Invalid RSA Padding Scheme %s", paddingMode));
    }

    public static Result<DafnySequence<? extends Byte>, Error> DecryptExtern(RSAPaddingMode dtor_padding, DafnySequence<? extends Byte> dtor_privateKey, DafnySequence<? extends Byte> dtor_cipherText) {
        try {
            byte[] privateKey = (byte[])Array.unwrap((Array)dtor_privateKey.toArray());
            RSAKeyParameters keyParameter = RSA.ParsePrivateRsaPemBytes(privateKey);
            byte[] ciphertext = (byte[])Array.unwrap((Array)dtor_cipherText.toArray());
            AsymmetricBlockCipher engine = RSA.GetEngineForPadding(dtor_padding);
            engine.init(false, (CipherParameters)keyParameter);
            return Result.create_Success(DafnySequence.fromBytes((byte[])engine.processBlock(ciphertext, 0, ciphertext.length)));
        }
        catch (Exception e) {
            return Result.create_Failure(ToDafny.Error(OpaqueError.builder().obj(e).message(e.getMessage()).cause(e).build()));
        }
    }

    public static Result<DafnySequence<? extends Byte>, Error> EncryptExtern(RSAPaddingMode dtor_padding, DafnySequence<? extends Byte> dtor_publicKey, DafnySequence<? extends Byte> dtor_plaintext) {
        try {
            byte[] publicKey = (byte[])Array.unwrap((Array)dtor_publicKey.toArray());
            RSAKeyParameters publicKeyParam = RSA.ParsePublicRsaPemBytes(publicKey);
            AsymmetricBlockCipher engine = RSA.GetEngineForPadding(dtor_padding);
            engine.init(true, (CipherParameters)publicKeyParam);
            return Result.create_Success(DafnySequence.fromBytes((byte[])engine.processBlock((byte[])Array.unwrap((Array)dtor_plaintext.toArray()), 0, dtor_plaintext.toArray().length())));
        }
        catch (Exception e) {
            return Result.create_Failure(ToDafny.Error(OpaqueError.builder().obj(e).message(e.getMessage()).cause(e).build()));
        }
    }
}

