/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsHierarchicalKeyring_Compile;

import AwsKmsHierarchicalKeyring_Compile.DecryptSingleEncryptedDataKey;
import AwsKmsHierarchicalKeyring_Compile.HierarchyWrapInfo;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyGenerateAndWrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyWrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.OnDecryptHierarchyEncryptedDataKeyFilter;
import AwsKmsHierarchicalKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials;
import software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetBranchKeyIdInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetBranchKeyIdOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.IBranchKeyIdSupplier;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;

public class AwsKmsHierarchicalKeyring
implements VerifiableInterface,
IKeyring {
    public IKeyStoreClient _keyStore = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public Option<IBranchKeyIdSupplier> _branchKeyIdSupplier = Option.Default();
    public Option<DafnySequence<? extends Character>> _branchKeyId = Option.Default();
    public long _ttlSeconds = 0L;
    public ICryptographicMaterialsCache _cache = null;
    private static final TypeDescriptor<AwsKmsHierarchicalKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsHierarchicalKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out101 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out101;
    }

    @Override
    public Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out102 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out102;
    }

    public void __ctor(IKeyStoreClient keyStore, Option<DafnySequence<? extends Character>> branchKeyId, Option<IBranchKeyIdSupplier> branchKeyIdSupplier, long ttlSeconds, ICryptographicMaterialsCache cmc, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyStore = keyStore;
        this._branchKeyId = branchKeyId;
        this._branchKeyIdSupplier = branchKeyIdSupplier;
        this._ttlSeconds = ttlSeconds;
        this._cryptoPrimitives = cryptoPrimitives;
        this._cache = cmc;
    }

    public Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetBranchKeyId(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> context) {
        Result<Object, software.amazon.cryptography.materialproviders.internaldafny.types.Error> ret = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        if (this.branchKeyId().is_Some()) {
            ret = Result.create_Success(this.branchKeyId().dtor_value());
            return ret;
        }
        Result<GetBranchKeyIdOutput, Object> _615_valueOrError0 = Result.Default(GetBranchKeyIdOutput.Default());
        Result<GetBranchKeyIdOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out103 = this.branchKeyIdSupplier().dtor_value().GetBranchKeyId(GetBranchKeyIdInput.create(context));
        _615_valueOrError0 = _out103;
        if (_615_valueOrError0.IsFailure(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            ret = _615_valueOrError0.PropagateFailure(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            return ret;
        }
        GetBranchKeyIdOutput _614_GetBranchKeyIdOut = _615_valueOrError0.Extract(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        ret = Result.create_Success(_614_GetBranchKeyIdOut.dtor_branchKeyId());
        return ret;
    }

    @Override
    public Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        EncryptionMaterials _616_materials = input.dtor_materials();
        AlgorithmSuiteInfo _617_suite = _616_materials.dtor_algorithmSuite();
        Result<Object, Object> _619_valueOrError0 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out104 = this.GetBranchKeyId(_616_materials.dtor_encryptionContext());
        _619_valueOrError0 = _out104;
        if (_619_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _619_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _618_branchKeyIdForEncrypt = (DafnySequence)_619_valueOrError0.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence<? extends Byte>, Object> _621_valueOrError1 = Result.Default(ValidUTF8Bytes.defaultValue());
        _621_valueOrError1 = UTF8.__default.Encode((DafnySequence<? extends Character>)_618_branchKeyIdForEncrypt).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_621_valueOrError1.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _621_valueOrError1.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Byte> _620_branchKeyIdUtf8 = _621_valueOrError1.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _623_valueOrError2 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out105 = this.GetActiveCacheId((DafnySequence<? extends Character>)_618_branchKeyIdForEncrypt, _620_branchKeyIdUtf8, this.cryptoPrimitives());
        _623_valueOrError2 = _out105;
        if (_623_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _623_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _622_cacheId = (DafnySequence)_623_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<BranchKeyMaterials, Object> _625_valueOrError3 = Result.Default(BranchKeyMaterials.Default());
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out106 = this.GetActiveHierarchicalMaterials((DafnySequence<? extends Character>)_618_branchKeyIdForEncrypt, (DafnySequence<? extends Byte>)_622_cacheId, this.keyStore());
        _625_valueOrError3 = _out106;
        if (_625_valueOrError3.IsFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _625_valueOrError3.PropagateFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        BranchKeyMaterials _624_hierarchicalMaterials = _625_valueOrError3.Extract(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence<? extends Byte> _626_branchKey = _624_hierarchicalMaterials.dtor_branchKey();
        DafnySequence<? extends Byte> _627_branchKeyVersion = _624_hierarchicalMaterials.dtor_branchKeyVersion();
        Result<Object, Object> _629_valueOrError4 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _629_valueOrError4 = UTF8.__default.Decode(_627_branchKeyVersion).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_629_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _629_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _628_branchKeyVersionAsString = (DafnySequence)_629_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _631_valueOrError5 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _631_valueOrError5 = UUID.__default.ToByteArray((DafnySequence<? extends Character>)_628_branchKeyVersionAsString).MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_631_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _631_valueOrError5.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _630_branchKeyVersionAsBytes = (DafnySequence)_631_valueOrError5.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        KmsHierarchyGenerateAndWrapKeyMaterial _nw32 = new KmsHierarchyGenerateAndWrapKeyMaterial();
        _nw32.__ctor(_624_hierarchicalMaterials.dtor_branchKey(), _620_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_630_branchKeyVersionAsBytes, this.cryptoPrimitives());
        KmsHierarchyGenerateAndWrapKeyMaterial _632_kmsHierarchyGenerateAndWrap = _nw32;
        KmsHierarchyWrapKeyMaterial _nw33 = new KmsHierarchyWrapKeyMaterial();
        _nw33.__ctor(_624_hierarchicalMaterials.dtor_branchKey(), _620_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_630_branchKeyVersionAsBytes, this.cryptoPrimitives());
        KmsHierarchyWrapKeyMaterial _633_kmsHierarchyWrap = _nw33;
        Result<WrapEdkMaterialOutput<HierarchyWrapInfo>, Object> _635_valueOrError6 = Result.Default(WrapEdkMaterialOutput.Default(HierarchyWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<HierarchyWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out107 = EdkWrapping_Compile.__default.WrapEdkMaterial(HierarchyWrapInfo._typeDescriptor(), _616_materials, _633_kmsHierarchyWrap, _632_kmsHierarchyGenerateAndWrap);
        _635_valueOrError6 = _out107;
        if (_635_valueOrError6.IsFailure(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _635_valueOrError6.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<HierarchyWrapInfo> _634_wrapOutput = _635_valueOrError6.Extract(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _636_symmetricSigningKeyList = _634_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_634_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _637_edk = EncryptedDataKey.create(Constants_Compile.__default.PROVIDER__ID__HIERARCHY(), _620_branchKeyIdUtf8, _634_wrapOutput.dtor_wrappedMaterial());
        if (_634_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _639_valueOrError7 = null;
            _639_valueOrError7 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_616_materials, _634_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_637_edk}), _636_symmetricSigningKeyList);
            if (_639_valueOrError7.IsFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                res = _639_valueOrError7.PropagateFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _638_result = _639_valueOrError7.Extract(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_638_result));
            return res;
        }
        if (_634_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _641_valueOrError8 = null;
            _641_valueOrError8 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_616_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_637_edk}), _636_symmetricSigningKeyList);
            if (_641_valueOrError8.IsFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                res = _641_valueOrError8.PropagateFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _640_result = _641_valueOrError8.Extract(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_640_result));
            return res;
        }
        return res;
    }

    @Override
    public Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>> _out110;
        Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        DecryptionMaterials _642_materials = input.dtor_materials();
        AlgorithmSuiteInfo _643_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _644_valueOrError0 = Outcome.Default();
        _644_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_642_materials), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_644_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _644_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Result<Object, Object> _646_valueOrError1 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out108 = this.GetBranchKeyId(_642_materials.dtor_encryptionContext());
        _646_valueOrError1 = _out108;
        if (_646_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _646_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _645_branchKeyIdForDecrypt = (DafnySequence)_646_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        OnDecryptHierarchyEncryptedDataKeyFilter _nw34 = new OnDecryptHierarchyEncryptedDataKeyFilter();
        _nw34.__ctor((DafnySequence<? extends Character>)_645_branchKeyIdForDecrypt);
        OnDecryptHierarchyEncryptedDataKeyFilter _647_filter = _nw34;
        Result<Object, Object> _649_valueOrError2 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out109 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _647_filter, input.dtor_encryptedDataKeys());
        _649_valueOrError2 = _out109;
        if (_649_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _649_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _648_edksToAttempt = (DafnySequence)_649_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _650_valueOrError3 = Outcome.Default();
        _650_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_648_edksToAttempt.length()).signum() == 1, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to decrypt data key: No Encrypted Data Keys found to match.")));
        if (_650_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _650_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptSingleEncryptedDataKey _nw35 = new DecryptSingleEncryptedDataKey();
        _nw35.__ctor(_642_materials, this.keyStore(), this.cryptoPrimitives(), (DafnySequence<? extends Character>)_645_branchKeyIdForDecrypt, this.ttlSeconds(), this.cache());
        DecryptSingleEncryptedDataKey _651_decryptClosure = _nw35;
        Result<DecryptionMaterials, DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>> _652_outcome = _out110 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _651_decryptClosure, _648_edksToAttempt);
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _654_valueOrError4 = null;
        _654_valueOrError4 = _652_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>>)DafnySequence._typeDescriptor(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _655_errors_boxed0 -> {
            DafnySequence _655_errors = _655_errors_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_CollectionOfErrors((DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.Error>)_655_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_654_valueOrError4.IsFailure(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _654_valueOrError4.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _653_SealedDecryptionMaterials = _654_valueOrError4.Extract(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_653_SealedDecryptionMaterials));
        return res;
    }

    public Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetActiveCacheId(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> branchKeyIdUtf8, AtomicPrimitivesClient cryptoPrimitives) {
        Result<DafnySequence<? extends Byte>, Error> _out112;
        Result<DafnySequence<? extends Byte>, Error> _out111;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> cacheId = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Object> _656_valueOrError0 = Outcome.Default();
        _656_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).is_Success() && (Boolean)Helpers.Let(UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).dtor_value(), boxed36 -> {
            DafnySequence _pat_let18_0 = boxed36;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let18_0, boxed37 -> {
                DafnySequence _657_branchKeyId = boxed37;
                return BigInteger.valueOf(_657_branchKeyId.length()).signum() != -1 && BigInteger.valueOf(_657_branchKeyId.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT32__LIMIT()) < 0;
            }));
        }) != false, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Branch Key ID Length")));
        if (_656_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _656_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Character> _658_branchKeyId = UTF8.__default.Decode(branchKeyIdUtf8).dtor_value();
        DafnySequence<? extends Byte> _659_lenBranchKey = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(_658_branchKeyId.cardinalityInt());
        DigestAlgorithm _660_hashAlgorithm = DigestAlgorithm.create_SHA__512();
        Result<DafnySequence<? extends Byte>, Error> _661_maybeBranchKeyDigest = _out111 = cryptoPrimitives.Digest(DigestInput.create(_660_hashAlgorithm, branchKeyIdUtf8));
        Result<Object, Object> _663_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _663_valueOrError1 = _661_maybeBranchKeyDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _664_e_boxed0 -> {
            Error _664_e = _664_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_664_e);
        });
        if (_663_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _663_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _662_branchKeyDigest = (DafnySequence)_663_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence<? extends Byte>, Object> _666_valueOrError2 = Result.Default(ValidUTF8Bytes.defaultValue());
        _666_valueOrError2 = UTF8.__default.Encode(__default.EXPRESSION__ATTRIBUTE__VALUE__STATUS__VALUE()).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_666_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _666_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Byte> _665_activeUtf8 = _666_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence _667_identifier = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(_659_lenBranchKey, (DafnySequence)_662_branchKeyDigest), (DafnySequence)DafnySequence.of((byte[])new byte[]{0})), _665_activeUtf8);
        Result<DafnySequence<? extends Byte>, Error> _668_maybeCacheIdDigest = _out112 = cryptoPrimitives.Digest(DigestInput.create(_660_hashAlgorithm, (DafnySequence<? extends Byte>)_667_identifier));
        Result<Object, Object> _670_valueOrError3 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _670_valueOrError3 = _668_maybeCacheIdDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _671_e_boxed0 -> {
            Error _671_e = _671_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_671_e);
        });
        if (_670_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _670_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _669_cacheDigest = (DafnySequence)_670_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _672_valueOrError4 = Outcome.Default();
        _672_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(_669_cacheDigest.length()), Digest_Compile.__default.Length(_660_hashAlgorithm)), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Digest generated a message not equal to the expected length.")));
        if (_672_valueOrError4.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _672_valueOrError4.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        cacheId = Result.create_Success(_669_cacheDigest.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(32L))));
        return cacheId;
    }

    public Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetActiveHierarchicalMaterials(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> cacheId, IKeyStoreClient keyStore) {
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> material = Result.Default(BranchKeyMaterials.Default());
        GetCacheEntryInput _673_getCacheInput = GetCacheEntryInput.create(cacheId, Option.create_None());
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out113 = __default.getEntry(this.cache(), _673_getCacheInput);
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _674_getCacheOutput = _out113;
        if (_674_getCacheOutput.is_Failure()) {
            long _out115;
            Result<GetActiveBranchKeyOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _out114;
            Result<GetActiveBranchKeyOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _675_maybeGetActiveBranchKeyOutput = _out114 = keyStore.GetActiveBranchKey(GetActiveBranchKeyInput.create(branchKeyId));
            Result<GetActiveBranchKeyOutput, Object> _677_valueOrError0 = Result.Default(GetActiveBranchKeyOutput.Default());
            _677_valueOrError0 = _675_maybeGetActiveBranchKeyOutput.MapFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _678_e_boxed0 -> {
                software.amazon.cryptography.keystore.internaldafny.types.Error _678_e = _678_e_boxed0;
                return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyKeyStore(_678_e);
            });
            if (_677_valueOrError0.IsFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _677_valueOrError0.PropagateFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            GetActiveBranchKeyOutput _676_getActiveBranchKeyOutput = _677_valueOrError0.Extract(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            BranchKeyMaterials _679_branchKeyMaterials = _676_getActiveBranchKeyOutput.dtor_branchKeyMaterials();
            long _680_now = _out115 = Time.__default.CurrentRelativeTime().longValue();
            Outcome<Object> _681_valueOrError1 = Outcome.Default();
            _681_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_680_now).add(BigInteger.valueOf(this.ttlSeconds())).compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) < 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"INT64 Overflow when putting cache entry.")));
            if (_681_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _681_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            PutCacheEntryInput _682_putCacheEntryInput = PutCacheEntryInput.create(cacheId, Materials.create_BranchKey(_679_branchKeyMaterials), _680_now, this.ttlSeconds() + _680_now, Option.create_None(), Option.create_None());
            Result<Tuple0, Object> _684_valueOrError2 = Result.Default(Tuple0.Default());
            Result<Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out116 = __default.putEntry(this.cache(), _682_putCacheEntryInput);
            _684_valueOrError2 = _out116;
            if (_684_valueOrError2.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _684_valueOrError2.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            Tuple0 _683___v0 = _684_valueOrError2.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            material = Result.create_Success(_679_branchKeyMaterials);
            return material;
        }
        Outcome<Object> _685_valueOrError3 = Outcome.Default();
        _685_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _674_getCacheOutput.dtor_value().dtor_materials().is_BranchKey() && Objects.equals(_674_getCacheOutput.dtor_value().dtor_materials(), Materials.create_BranchKey(_674_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey())), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Material Type.")));
        if (_685_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            material = _685_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
            return material;
        }
        material = Result.create_Success(_674_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey());
        return material;
    }

    public IKeyStoreClient keyStore() {
        return this._keyStore;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public Option<IBranchKeyIdSupplier> branchKeyIdSupplier() {
        return this._branchKeyIdSupplier;
    }

    public Option<DafnySequence<? extends Character>> branchKeyId() {
        return this._branchKeyId;
    }

    public long ttlSeconds() {
        return this._ttlSeconds;
    }

    public ICryptographicMaterialsCache cache() {
        return this._cache;
    }

    public static TypeDescriptor<AwsKmsHierarchicalKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsHierarchicalKeyring_Compile.AwsKmsHierarchicalKeyring";
    }
}

