/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.internaldafny.types;

import BoundedInts_Compile.uint8;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm;
import software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm;
import software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm;
import software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm;

public class AlgorithmSuiteInfo {
    public AlgorithmSuiteId _id;
    public DafnySequence<? extends Byte> _binaryId;
    public int _messageVersion;
    public Encrypt _encrypt;
    public DerivationAlgorithm _kdf;
    public DerivationAlgorithm _commitment;
    public SignatureAlgorithm _signature;
    public SymmetricSignatureAlgorithm _symmetricSignature;
    public EdkWrappingAlgorithm _edkWrapping;
    private static final AlgorithmSuiteInfo theDefault = AlgorithmSuiteInfo.create(AlgorithmSuiteId.Default(), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()), 0, Encrypt.Default(), DerivationAlgorithm.Default(), DerivationAlgorithm.Default(), SignatureAlgorithm.Default(), SymmetricSignatureAlgorithm.Default(), EdkWrappingAlgorithm.Default());
    private static final TypeDescriptor<AlgorithmSuiteInfo> _TYPE = TypeDescriptor.referenceWithInitializer(AlgorithmSuiteInfo.class, () -> AlgorithmSuiteInfo.Default());

    public AlgorithmSuiteInfo(AlgorithmSuiteId id, DafnySequence<? extends Byte> binaryId, int messageVersion, Encrypt encrypt, DerivationAlgorithm kdf, DerivationAlgorithm commitment, SignatureAlgorithm signature, SymmetricSignatureAlgorithm symmetricSignature, EdkWrappingAlgorithm edkWrapping) {
        this._id = id;
        this._binaryId = binaryId;
        this._messageVersion = messageVersion;
        this._encrypt = encrypt;
        this._kdf = kdf;
        this._commitment = commitment;
        this._signature = signature;
        this._symmetricSignature = symmetricSignature;
        this._edkWrapping = edkWrapping;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        AlgorithmSuiteInfo o = (AlgorithmSuiteInfo)other;
        return Objects.equals(this._id, o._id) && Objects.equals(this._binaryId, o._binaryId) && this._messageVersion == o._messageVersion && Objects.equals(this._encrypt, o._encrypt) && Objects.equals(this._kdf, o._kdf) && Objects.equals(this._commitment, o._commitment) && Objects.equals(this._signature, o._signature) && Objects.equals(this._symmetricSignature, o._symmetricSignature) && Objects.equals(this._edkWrapping, o._edkWrapping);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._id);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._binaryId);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._messageVersion);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._encrypt);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._kdf);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._commitment);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._signature);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._symmetricSignature);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._edkWrapping);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("software.amazon.cryptography.materialproviders.internaldafny.types_Compile.AlgorithmSuiteInfo.AlgorithmSuiteInfo");
        s.append("(");
        s.append(Helpers.toString((Object)this._id));
        s.append(", ");
        s.append(Helpers.toString(this._binaryId));
        s.append(", ");
        s.append(this._messageVersion);
        s.append(", ");
        s.append(Helpers.toString((Object)this._encrypt));
        s.append(", ");
        s.append(Helpers.toString((Object)this._kdf));
        s.append(", ");
        s.append(Helpers.toString((Object)this._commitment));
        s.append(", ");
        s.append(Helpers.toString((Object)this._signature));
        s.append(", ");
        s.append(Helpers.toString((Object)this._symmetricSignature));
        s.append(", ");
        s.append(Helpers.toString((Object)this._edkWrapping));
        s.append(")");
        return s.toString();
    }

    public static AlgorithmSuiteInfo Default() {
        return theDefault;
    }

    public static TypeDescriptor<AlgorithmSuiteInfo> _typeDescriptor() {
        return _TYPE;
    }

    public static AlgorithmSuiteInfo create(AlgorithmSuiteId id, DafnySequence<? extends Byte> binaryId, int messageVersion, Encrypt encrypt, DerivationAlgorithm kdf, DerivationAlgorithm commitment, SignatureAlgorithm signature, SymmetricSignatureAlgorithm symmetricSignature, EdkWrappingAlgorithm edkWrapping) {
        return new AlgorithmSuiteInfo(id, binaryId, messageVersion, encrypt, kdf, commitment, signature, symmetricSignature, edkWrapping);
    }

    public static AlgorithmSuiteInfo create_AlgorithmSuiteInfo(AlgorithmSuiteId id, DafnySequence<? extends Byte> binaryId, int messageVersion, Encrypt encrypt, DerivationAlgorithm kdf, DerivationAlgorithm commitment, SignatureAlgorithm signature, SymmetricSignatureAlgorithm symmetricSignature, EdkWrappingAlgorithm edkWrapping) {
        return AlgorithmSuiteInfo.create(id, binaryId, messageVersion, encrypt, kdf, commitment, signature, symmetricSignature, edkWrapping);
    }

    public boolean is_AlgorithmSuiteInfo() {
        return true;
    }

    public AlgorithmSuiteId dtor_id() {
        return this._id;
    }

    public DafnySequence<? extends Byte> dtor_binaryId() {
        return this._binaryId;
    }

    public int dtor_messageVersion() {
        return this._messageVersion;
    }

    public Encrypt dtor_encrypt() {
        return this._encrypt;
    }

    public DerivationAlgorithm dtor_kdf() {
        return this._kdf;
    }

    public DerivationAlgorithm dtor_commitment() {
        return this._commitment;
    }

    public SignatureAlgorithm dtor_signature() {
        return this._signature;
    }

    public SymmetricSignatureAlgorithm dtor_symmetricSignature() {
        return this._symmetricSignature;
    }

    public EdkWrappingAlgorithm dtor_edkWrapping() {
        return this._edkWrapping;
    }
}

