/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class GetActiveBranchKeyOutput {
    private final String branchKeyVersion;
    private final ByteBuffer branchKey;

    protected GetActiveBranchKeyOutput(BuilderImpl builder) {
        this.branchKeyVersion = builder.branchKeyVersion();
        this.branchKey = builder.branchKey();
    }

    public String branchKeyVersion() {
        return this.branchKeyVersion;
    }

    public ByteBuffer branchKey() {
        return this.branchKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String branchKeyVersion;
        protected ByteBuffer branchKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GetActiveBranchKeyOutput model) {
            this.branchKeyVersion = model.branchKeyVersion();
            this.branchKey = model.branchKey();
        }

        @Override
        public Builder branchKeyVersion(String branchKeyVersion) {
            this.branchKeyVersion = branchKeyVersion;
            return this;
        }

        @Override
        public String branchKeyVersion() {
            return this.branchKeyVersion;
        }

        @Override
        public Builder branchKey(ByteBuffer branchKey) {
            this.branchKey = branchKey;
            return this;
        }

        @Override
        public ByteBuffer branchKey() {
            return this.branchKey;
        }

        @Override
        public GetActiveBranchKeyOutput build() {
            if (Objects.isNull(this.branchKeyVersion())) {
                throw new IllegalArgumentException("Missing value for required field `branchKeyVersion`");
            }
            if (Objects.isNull(this.branchKey())) {
                throw new IllegalArgumentException("Missing value for required field `branchKey`");
            }
            return new GetActiveBranchKeyOutput(this);
        }
    }

    public static interface Builder {
        public Builder branchKeyVersion(String var1);

        public String branchKeyVersion();

        public Builder branchKey(ByteBuffer var1);

        public ByteBuffer branchKey();

        public GetActiveBranchKeyOutput build();
    }
}

