/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.internaldafny;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsCryptographyKeyStoreOperations_Compile.Config;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.keystore.internaldafny.KeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.__default;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient;
import software.amazon.cryptography.services.dynamodb.internaldafny.types._Companion_IDynamoDBClient;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types._Companion_IKMSClient;

public abstract class _ExternBase___default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static KeyStoreConfig DefaultKeyStoreConfig() {
        return KeyStoreConfig.create((DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), KMSConfiguration.create((DafnySequence<? extends Character>)DafnySequence.asString((String)"")), (DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), Option.create_None(), Option.create_None(), Option.create_None(), Option.create_None());
    }

    public static Result<KeyStoreClient, Error> KeyStore(KeyStoreConfig config) {
        Result<KeyStoreClient, Error> res = null;
        Outcome<Object> _1331_valueOrError0 = Outcome.Default();
        _1331_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__KeyIdType(config.dtor_kmsConfiguration().dtor_kmsKeyArn()) && AwsArnParsing_Compile.__default.ParseAwsKmsArn(config.dtor_kmsConfiguration().dtor_kmsKeyArn()).is_Success(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid AWS KMS Key Arn")));
        if (_1331_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1331_valueOrError0.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        Result<DafnySequence<? extends DafnySequence<? extends Character>>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1332_grantTokens = AwsKmsUtils_Compile.__default.GetValidGrantTokens(config.dtor_grantTokens());
        Outcome<Object> _1333_valueOrError1 = Outcome.Default();
        _1333_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _1332_grantTokens.is_Success(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"CreateKey received invalid grant tokens")));
        if (_1333_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _1333_valueOrError1.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        DafnySequence _1334_keyStoreId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
        if (config.dtor_id().is_Some()) {
            _1334_keyStoreId = config.dtor_id().dtor_value();
        } else {
            DafnySequence _1336_uuid;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _out235;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _1335_maybeUuid = _out235 = UUID.__default.GenerateUUID();
            Result<Object, Object> _1337_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _1337_valueOrError2 = _1335_maybeUuid.MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _1338_e_boxed0 -> {
                DafnySequence _1338_e = _1338_e_boxed0;
                return Error.create_KeyStoreException((DafnySequence<? extends Character>)_1338_e);
            });
            if (_1337_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _1337_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _1334_keyStoreId = _1336_uuid = (DafnySequence)_1337_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        }
        IKMSClient _1339_kmsClient = null;
        IDynamoDBClient _1340_ddbClient = null;
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _1341_keyArn = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(config.dtor_kmsConfiguration().dtor_kmsKeyArn());
        Option<DafnySequence<? extends Character>> _1342_kmsRegion = AwsArnParsing_Compile.__default.GetRegion(_1341_keyArn.dtor_value());
        if (config.dtor_kmsClient().is_None()) {
            IKMSClient _1344_extractedClient;
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out236;
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _1343_maybeKmsClient = _out236 = software.amazon.cryptography.services.kms.internaldafny.__default.KMSClientForRegion(_1342_kmsRegion.dtor_value());
            Result<IKMSClient, Error> _1345_valueOrError3 = null;
            _1345_valueOrError3 = _1343_maybeKmsClient.MapFailure(_Companion_IKMSClient._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _1346_e_boxed0 -> {
                software.amazon.cryptography.services.kms.internaldafny.types.Error _1346_e = _1346_e_boxed0;
                return Error.create_ComAmazonawsKms(_1346_e);
            });
            if (_1345_valueOrError3.IsFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _1345_valueOrError3.PropagateFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _1339_kmsClient = _1344_extractedClient = _1345_valueOrError3.Extract(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            _1339_kmsClient = config.dtor_kmsClient().dtor_value();
        }
        if (config.dtor_ddbClient().is_None()) {
            IDynamoDBClient _1348_extractedClient;
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _out237;
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _1347_maybeDdbClient = _out237 = software.amazon.cryptography.services.dynamodb.internaldafny.__default.DDBClientForRegion(_1342_kmsRegion.dtor_value());
            Result<IDynamoDBClient, Error> _1349_valueOrError4 = null;
            _1349_valueOrError4 = _1347_maybeDdbClient.MapFailure(_Companion_IDynamoDBClient._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _1350_e_boxed0 -> {
                software.amazon.cryptography.services.dynamodb.internaldafny.types.Error _1350_e = _1350_e_boxed0;
                return Error.create_ComAmazonawsDynamodb(_1350_e);
            });
            if (_1349_valueOrError4.IsFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _1349_valueOrError4.PropagateFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _1340_ddbClient = _1348_extractedClient = _1349_valueOrError4.Extract(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            _1340_ddbClient = config.dtor_ddbClient().dtor_value();
        }
        Outcome<Object> _1351_valueOrError5 = Outcome.Default();
        _1351_valueOrError5 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__TableName(config.dtor_ddbTableName()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Amazon DynamoDB Table Name")));
        if (_1351_valueOrError5.IsFailure(Error._typeDescriptor())) {
            res = _1351_valueOrError5.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        KeyStoreClient _nw66 = new KeyStoreClient();
        _nw66.__ctor(Config.create((DafnySequence<? extends Character>)_1334_keyStoreId, config.dtor_ddbTableName(), config.dtor_logicalKeyStoreName(), config.dtor_kmsConfiguration(), _1332_grantTokens.dtor_value(), _1339_kmsClient, _1340_ddbClient));
        KeyStoreClient _1352_client = _nw66;
        res = Result.create_Success(_1352_client);
        return res;
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "software.amazon.cryptography.keystore.internaldafny_Compile._default";
    }
}

