/*
 * Decompiled with CFR 0.152.
 */
package Random_Compile;

import Wrappers_Compile.Result;
import dafny.DafnySequence;
import java.security.SecureRandom;
import software.amazon.cryptography.primitives.ToDafny;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.model.OpaqueError;

public class ExternRandom {
    private static final ThreadLocal<SecureRandom> LOCAL_RANDOM = ThreadLocal.withInitial(() -> {
        SecureRandom rnd = new SecureRandom();
        rnd.nextBoolean();
        return rnd;
    });

    public static SecureRandom getSecureRandom() {
        return LOCAL_RANDOM.get();
    }

    public static class __default {
        public static Result<DafnySequence<? extends Byte>, Error> GenerateBytes(int len) {
            try {
                byte[] result = new byte[len];
                SecureRandom secureRandom = ExternRandom.getSecureRandom();
                secureRandom.nextBytes(result);
                return Result.create_Success(DafnySequence.fromBytes((byte[])result));
            }
            catch (Exception e) {
                return Result.create_Failure(ToDafny.Error(OpaqueError.builder().obj(e).cause(e).message(e.getMessage()).build()));
            }
        }
    }
}

