/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsUtils_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Function0;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.Tuple2;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.cryptography.materialproviders.internaldafny.types.DiscoveryFilter;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;

public class __default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>>, Error> StringifyEncryptionContext(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> utf8EncCtx) {
        if (BigInteger.valueOf(utf8EncCtx.size()).signum() == 0) {
            return Result.create_Success(DafnyMap.fromElements((Tuple2[])new Tuple2[0]));
        }
        DafnyMap _176_stringifyResults = ((Function<DafnyMap, DafnyMap>)_177_utf8EncCtx -> ((Function0<DafnyMap>)() -> {
            HashMap<DafnySequence, Result<Tuple2<DafnySequence<? extends Character>, DafnySequence<? extends Character>>, Error>> _coll1 = new HashMap<DafnySequence, Result<Tuple2<DafnySequence<? extends Character>, DafnySequence<? extends Character>>, Error>>();
            Iterator iterator = _177_utf8EncCtx.keySet().Elements().iterator();
            while (iterator.hasNext()) {
                DafnySequence _compr_1_boxed0;
                DafnySequence _compr_1;
                DafnySequence _178_utf8Key = _compr_1 = (_compr_1_boxed0 = (DafnySequence)iterator.next());
                if (!_177_utf8EncCtx.keySet().contains((Object)_178_utf8Key)) continue;
                _coll1.put(_178_utf8Key, __default.StringifyEncryptionContextPair((DafnySequence<? extends Byte>)_178_utf8Key, (DafnySequence<? extends Byte>)((DafnySequence)_177_utf8EncCtx.get((Object)_178_utf8Key))));
            }
            return new DafnyMap(_coll1);
        }).apply()).apply(utf8EncCtx);
        if (((Function<DafnyMap, Boolean>)_179_stringifyResults -> Helpers.Quantifier((Iterable)_179_stringifyResults.valueSet().Elements(), (boolean)false, _exists_var_0_boxed0 -> {
            Result _exists_var_0;
            Result _180_r = _exists_var_0 = _exists_var_0_boxed0;
            return _179_stringifyResults.valueSet().contains((Object)_180_r) && _180_r.is_Failure();
        })).apply(_176_stringifyResults).booleanValue()) {
            return Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption context contains invalid UTF8")));
        }
        boolean _181_stringKeysUnique = ((Function<DafnyMap, Boolean>)_182_stringifyResults -> Helpers.Quantifier((Iterable)_182_stringifyResults.keySet().Elements(), (boolean)true, _forall_var_4_boxed0 -> {
            DafnySequence _forall_var_4;
            DafnySequence _183_k = _forall_var_4 = _forall_var_4_boxed0;
            return Helpers.Quantifier((Iterable)_182_stringifyResults.keySet().Elements(), (boolean)true, _forall_var_5_boxed0 -> {
                DafnySequence _forall_var_5;
                DafnySequence _184_k_k = _forall_var_5 = _forall_var_5_boxed0;
                return !_182_stringifyResults.contains((Object)_183_k) || !_182_stringifyResults.contains((Object)_184_k_k) || _183_k.equals((Object)_184_k_k) || !((DafnySequence)((Tuple2)((Result)_182_stringifyResults.get((Object)_183_k)).dtor_value()).dtor__0()).equals(((Tuple2)((Result)_182_stringifyResults.get((Object)_184_k_k)).dtor_value()).dtor__0());
            });
        })).apply(_176_stringifyResults);
        if (!_181_stringKeysUnique) {
            return Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption context keys are not unique")));
        }
        return Result.create_Success(((Function<DafnyMap, DafnyMap>)_185_stringifyResults -> ((Function0<DafnyMap>)() -> {
            HashMap<Object, Object> _coll2 = new HashMap<Object, Object>();
            Iterator iterator = _185_stringifyResults.valueSet().Elements().iterator();
            while (iterator.hasNext()) {
                Result _compr_2_boxed0;
                Result _compr_2;
                Result _186_r = _compr_2 = (_compr_2_boxed0 = (Result)iterator.next());
                if (!_185_stringifyResults.valueSet().contains((Object)_186_r)) continue;
                _coll2.put(((Tuple2)_186_r.dtor_value()).dtor__0(), ((Tuple2)_186_r.dtor_value()).dtor__1());
            }
            return new DafnyMap(_coll2);
        }).apply()).apply(_176_stringifyResults));
    }

    public static Result<Tuple2<DafnySequence<? extends Character>, DafnySequence<? extends Character>>, Error> StringifyEncryptionContextPair(DafnySequence<? extends Byte> utf8Key, DafnySequence<? extends Byte> utf8Value) {
        Result<DafnySequence<? extends Character>, Error> _187_valueOrError0 = UTF8.__default.Decode(utf8Key).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::WrapStringToError);
        if (_187_valueOrError0.IsFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
            return _187_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        }
        DafnySequence<? extends Character> _188_key = _187_valueOrError0.Extract((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        Result<DafnySequence<? extends Character>, Error> _189_valueOrError1 = UTF8.__default.Decode(utf8Value).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::WrapStringToError);
        if (_189_valueOrError1.IsFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
            return _189_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        }
        DafnySequence<? extends Character> _190_value = _189_valueOrError1.Extract((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        return Result.create_Success(Tuple2.create(_188_key, _190_value));
    }

    public static Error WrapStringToError(DafnySequence<? extends Character> e) {
        return Error.create_AwsCryptographicMaterialProvidersException(e);
    }

    public static Result<Tuple0, Error> ValidateKmsKeyId(DafnySequence<? extends Character> keyId) {
        Result<AwsKmsIdentifier, Error> _191_valueOrError0 = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(keyId).MapFailure(AwsKmsIdentifier._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::WrapStringToError);
        if (_191_valueOrError0.IsFailure(AwsKmsIdentifier._typeDescriptor(), Error._typeDescriptor())) {
            return _191_valueOrError0.PropagateFailure(AwsKmsIdentifier._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        AwsKmsIdentifier _192___v0 = _191_valueOrError0.Extract(AwsKmsIdentifier._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _193_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), UTF8.__default.IsASCIIString(keyId), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key identifier is not ASCII")));
        if (_193_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _193_valueOrError1.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        Outcome<Error> _194_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(keyId.length()).signum() == 1 && BigInteger.valueOf(keyId.length()).compareTo(AwsArnParsing_Compile.__default.MAX__AWS__KMS__IDENTIFIER__LENGTH()) <= 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key identifier is too long")));
        if (_194_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _194_valueOrError2.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        return Result.create_Success(Tuple0.create());
    }

    public static Result<DafnySequence<? extends DafnySequence<? extends Character>>, Error> GetValidGrantTokens(Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens) {
        DafnySequence<? extends DafnySequence<? extends Character>> _195_tokens = grantTokens.UnwrapOr((TypeDescriptor<DafnySequence<? extends DafnySequence<? extends Character>>>)DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), (DafnySequence<? extends DafnySequence<? extends Character>>)DafnySequence.empty((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        Outcome<Error> _196_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_195_tokens.length()).signum() != -1 && BigInteger.valueOf(_195_tokens.length()).compareTo(BigInteger.valueOf(10L)) <= 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Grant token list can have no more than 10 tokens")));
        if (_196_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _196_valueOrError0.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        }
        Outcome<Error> _197_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), ((Function<DafnySequence, Boolean>)_198_tokens -> Helpers.Quantifier((Iterable)_198_tokens.UniqueElements(), (boolean)true, _forall_var_6_boxed0 -> {
            DafnySequence _forall_var_6 = _forall_var_6_boxed0;
            DafnySequence _199_token = _forall_var_6;
            return !_198_tokens.contains((Object)_199_token) || BigInteger.ONE.compareTo(BigInteger.valueOf(_199_token.length())) <= 0 && BigInteger.valueOf(_199_token.length()).compareTo(BigInteger.valueOf(8192L)) <= 0;
        })).apply(_195_tokens), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Grant token list contains a grant token with invalid length")));
        if (_197_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _197_valueOrError1.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        }
        return Result.create_Success(_195_tokens);
    }

    public static Result<Tuple2<DafnySequence<? extends Byte>, DafnySequence<? extends Byte>>, Error> ParseKeyNamespaceAndName(DafnySequence<? extends Character> keyNamespace, DafnySequence<? extends Character> keyName) {
        Result<DafnySequence<? extends Byte>, Error> _200_valueOrError0 = UTF8.__default.Encode(keyNamespace).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _201_e_boxed0 -> {
            DafnySequence _201_e = _201_e_boxed0;
            return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Key namespace could not be UTF8-encoded"), (DafnySequence)_201_e));
        });
        if (_200_valueOrError0.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            return _200_valueOrError0.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), Tuple2._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()));
        }
        DafnySequence<? extends Byte> _202_namespace = _200_valueOrError0.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _203_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_202_namespace.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key namespace too long")));
        if (_203_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _203_valueOrError1.PropagateFailure(Error._typeDescriptor(), Tuple2._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()));
        }
        Result<DafnySequence<? extends Byte>, Error> _204_valueOrError2 = UTF8.__default.Encode(keyName).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _205_e_boxed0 -> {
            DafnySequence _205_e = _205_e_boxed0;
            return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Key name could not be UTF8-encoded"), (DafnySequence)_205_e));
        });
        if (_204_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            return _204_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), Tuple2._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()));
        }
        DafnySequence<? extends Byte> _206_name = _204_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _207_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_206_name.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key name too long")));
        if (_207_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _207_valueOrError3.PropagateFailure(Error._typeDescriptor(), Tuple2._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()));
        }
        return Result.create_Success(Tuple2.create(_202_namespace, _206_name));
    }

    public static Result<Tuple0, Error> ValidateDiscoveryFilter(DiscoveryFilter filter) {
        Outcome<Error> _208_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(filter.dtor_accountIds().length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Discovery filter must have at least one account ID")));
        if (_208_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _208_valueOrError0.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        Outcome<Error> _209_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), ((Function<DiscoveryFilter, Boolean>)_210_filter -> Helpers.Quantifier((Iterable)_210_filter.dtor_accountIds().UniqueElements(), (boolean)true, _forall_var_7_boxed0 -> {
            DafnySequence _forall_var_7;
            DafnySequence _211_accountId = _forall_var_7 = _forall_var_7_boxed0;
            return !_210_filter.dtor_accountIds().contains((Object)_211_accountId) || BigInteger.valueOf(_211_accountId.length()).signum() == 1;
        })).apply(filter), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Discovery filter account IDs cannot be blank")));
        if (_209_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _209_valueOrError1.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        Outcome<Error> _212_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(filter.dtor_partition().length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Discovery filter partition cannot be blank")));
        if (_212_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _212_valueOrError2.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        return Result.create_Success(Tuple0.create());
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsUtils_Compile._default";
    }
}

