/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.model.DigestAlgorithm;

public class HkdfExtractInput {
    private final DigestAlgorithm digestAlgorithm;
    private final ByteBuffer salt;
    private final ByteBuffer ikm;

    protected HkdfExtractInput(BuilderImpl builder) {
        this.digestAlgorithm = builder.digestAlgorithm();
        this.salt = builder.salt();
        this.ikm = builder.ikm();
    }

    public DigestAlgorithm digestAlgorithm() {
        return this.digestAlgorithm;
    }

    public ByteBuffer salt() {
        return this.salt;
    }

    public ByteBuffer ikm() {
        return this.ikm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected DigestAlgorithm digestAlgorithm;
        protected ByteBuffer salt;
        protected ByteBuffer ikm;

        protected BuilderImpl() {
        }

        protected BuilderImpl(HkdfExtractInput model) {
            this.digestAlgorithm = model.digestAlgorithm();
            this.salt = model.salt();
            this.ikm = model.ikm();
        }

        @Override
        public Builder digestAlgorithm(DigestAlgorithm digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
            return this;
        }

        @Override
        public DigestAlgorithm digestAlgorithm() {
            return this.digestAlgorithm;
        }

        @Override
        public Builder salt(ByteBuffer salt) {
            this.salt = salt;
            return this;
        }

        @Override
        public ByteBuffer salt() {
            return this.salt;
        }

        @Override
        public Builder ikm(ByteBuffer ikm) {
            this.ikm = ikm;
            return this;
        }

        @Override
        public ByteBuffer ikm() {
            return this.ikm;
        }

        @Override
        public HkdfExtractInput build() {
            if (Objects.isNull((Object)this.digestAlgorithm())) {
                throw new IllegalArgumentException("Missing value for required field `digestAlgorithm`");
            }
            if (Objects.isNull(this.ikm())) {
                throw new IllegalArgumentException("Missing value for required field `ikm`");
            }
            return new HkdfExtractInput(this);
        }
    }

    public static interface Builder {
        public Builder digestAlgorithm(DigestAlgorithm var1);

        public DigestAlgorithm digestAlgorithm();

        public Builder salt(ByteBuffer var1);

        public ByteBuffer salt();

        public Builder ikm(ByteBuffer var1);

        public ByteBuffer ikm();

        public HkdfExtractInput build();
    }
}

