/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.BeaconKeyMaterials;
import software.amazon.cryptography.materialproviders.model.BranchKeyMaterials;
import software.amazon.cryptography.materialproviders.model.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.model.EncryptionMaterials;

public class Materials {
    private final EncryptionMaterials Encryption;
    private final DecryptionMaterials Decryption;
    private final BranchKeyMaterials BranchKey;
    private final BeaconKeyMaterials BeaconKey;

    protected Materials(BuilderImpl builder) {
        this.Encryption = builder.Encryption();
        this.Decryption = builder.Decryption();
        this.BranchKey = builder.BranchKey();
        this.BeaconKey = builder.BeaconKey();
    }

    public EncryptionMaterials Encryption() {
        return this.Encryption;
    }

    public DecryptionMaterials Decryption() {
        return this.Decryption;
    }

    public BranchKeyMaterials BranchKey() {
        return this.BranchKey;
    }

    public BeaconKeyMaterials BeaconKey() {
        return this.BeaconKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected EncryptionMaterials Encryption;
        protected DecryptionMaterials Decryption;
        protected BranchKeyMaterials BranchKey;
        protected BeaconKeyMaterials BeaconKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(Materials model) {
            this.Encryption = model.Encryption();
            this.Decryption = model.Decryption();
            this.BranchKey = model.BranchKey();
            this.BeaconKey = model.BeaconKey();
        }

        @Override
        public Builder Encryption(EncryptionMaterials Encryption) {
            this.Encryption = Encryption;
            return this;
        }

        @Override
        public EncryptionMaterials Encryption() {
            return this.Encryption;
        }

        @Override
        public Builder Decryption(DecryptionMaterials Decryption) {
            this.Decryption = Decryption;
            return this;
        }

        @Override
        public DecryptionMaterials Decryption() {
            return this.Decryption;
        }

        @Override
        public Builder BranchKey(BranchKeyMaterials BranchKey) {
            this.BranchKey = BranchKey;
            return this;
        }

        @Override
        public BranchKeyMaterials BranchKey() {
            return this.BranchKey;
        }

        @Override
        public Builder BeaconKey(BeaconKeyMaterials BeaconKey) {
            this.BeaconKey = BeaconKey;
            return this;
        }

        @Override
        public BeaconKeyMaterials BeaconKey() {
            return this.BeaconKey;
        }

        @Override
        public Materials build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`Materials` is a Union. A Union MUST have one and only one value set.");
            }
            return new Materials(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.Encryption, this.Decryption, this.BranchKey, this.BeaconKey};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder Encryption(EncryptionMaterials var1);

        public EncryptionMaterials Encryption();

        public Builder Decryption(DecryptionMaterials var1);

        public DecryptionMaterials Decryption();

        public Builder BranchKey(BranchKeyMaterials var1);

        public BranchKeyMaterials BranchKey();

        public Builder BeaconKey(BeaconKeyMaterials var1);

        public BeaconKeyMaterials BeaconKey();

        public Materials build();
    }
}

