/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class GetBeaconKeyOutput {
    private final String beaconKeyIdentifier;
    private final ByteBuffer beaconKey;

    protected GetBeaconKeyOutput(BuilderImpl builder) {
        this.beaconKeyIdentifier = builder.beaconKeyIdentifier();
        this.beaconKey = builder.beaconKey();
    }

    public String beaconKeyIdentifier() {
        return this.beaconKeyIdentifier;
    }

    public ByteBuffer beaconKey() {
        return this.beaconKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String beaconKeyIdentifier;
        protected ByteBuffer beaconKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GetBeaconKeyOutput model) {
            this.beaconKeyIdentifier = model.beaconKeyIdentifier();
            this.beaconKey = model.beaconKey();
        }

        @Override
        public Builder beaconKeyIdentifier(String beaconKeyIdentifier) {
            this.beaconKeyIdentifier = beaconKeyIdentifier;
            return this;
        }

        @Override
        public String beaconKeyIdentifier() {
            return this.beaconKeyIdentifier;
        }

        @Override
        public Builder beaconKey(ByteBuffer beaconKey) {
            this.beaconKey = beaconKey;
            return this;
        }

        @Override
        public ByteBuffer beaconKey() {
            return this.beaconKey;
        }

        @Override
        public GetBeaconKeyOutput build() {
            if (Objects.isNull(this.beaconKeyIdentifier())) {
                throw new IllegalArgumentException("Missing value for required field `beaconKeyIdentifier`");
            }
            if (Objects.isNull(this.beaconKey())) {
                throw new IllegalArgumentException("Missing value for required field `beaconKey`");
            }
            return new GetBeaconKeyOutput(this);
        }
    }

    public static interface Builder {
        public Builder beaconKeyIdentifier(String var1);

        public String beaconKeyIdentifier();

        public Builder beaconKey(ByteBuffer var1);

        public ByteBuffer beaconKey();

        public GetBeaconKeyOutput build();
    }
}

