/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsRsaKeyring_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsKmsRsaKeyring_Compile.DecryptSingleAWSRSAEncryptedDataKey;
import AwsKmsRsaKeyring_Compile.KmsRsaGenerateAndWrapKeyMaterial;
import AwsKmsRsaKeyring_Compile.KmsRsaWrapInfo;
import AwsKmsRsaKeyring_Compile.KmsRsaWrapKeyMaterial;
import AwsKmsRsaKeyring_Compile.__default;
import AwsKmsUtils_Compile.OnDecryptMrkAwareEncryptedDataKeyFilter;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptionAlgorithmSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsRsaKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public Option<IKMSClient> _client = Option.Default();
    public EncryptionAlgorithmSpec _paddingScheme = EncryptionAlgorithmSpec.Default();
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public Option<DafnySequence<? extends Byte>> _publicKey = Option.Default();
    public AwsKmsIdentifier _awsKmsArn = null;
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<AwsKmsRsaKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsRsaKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out119 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out119;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out120 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out120;
    }

    public void __ctor(Option<DafnySequence<? extends Byte>> publicKey, DafnySequence<? extends Character> awsKmsKey, EncryptionAlgorithmSpec paddingScheme, Option<IKMSClient> client, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _785_parsedAwsKmsId = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(awsKmsKey);
        this._publicKey = publicKey;
        this._awsKmsKey = awsKmsKey;
        this._awsKmsArn = _785_parsedAwsKmsId.dtor_value();
        this._paddingScheme = paddingScheme;
        this._client = client;
        this._cryptoPrimitives = cryptoPrimitives;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        Outcome<Object> _786_valueOrError0 = Outcome.Default();
        _786_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.publicKey().is_Some() && BigInteger.valueOf(this.publicKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())).length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A AwsKmsRsaKeyring without a public key cannot provide OnEncrypt")));
        if (_786_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _786_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Object> _787_valueOrError1 = Outcome.Default();
        _787_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_algorithmSuite().dtor_signature().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"AwsKmsRsaKeyring cannot be used with an Algorithm Suite with asymmetric signing."), (DafnySequence)DafnySequence.asString((String)" Please specify an algorithm suite without asymmetric signing."))));
        if (_787_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _787_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        KmsRsaWrapKeyMaterial _nw38 = new KmsRsaWrapKeyMaterial();
        _nw38.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        KmsRsaWrapKeyMaterial _788_wrap = _nw38;
        KmsRsaGenerateAndWrapKeyMaterial _nw39 = new KmsRsaGenerateAndWrapKeyMaterial();
        _nw39.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        KmsRsaGenerateAndWrapKeyMaterial _789_generateAndWrap = _nw39;
        Result<WrapEdkMaterialOutput<KmsRsaWrapInfo>, Object> _791_valueOrError2 = Result.Default(WrapEdkMaterialOutput.Default(KmsRsaWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<KmsRsaWrapInfo>, Error> _out121 = EdkWrapping_Compile.__default.WrapEdkMaterial(KmsRsaWrapInfo._typeDescriptor(), input.dtor_materials(), _788_wrap, _789_generateAndWrap);
        _791_valueOrError2 = _out121;
        if (_791_valueOrError2.IsFailure(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _791_valueOrError2.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<KmsRsaWrapInfo> _790_wrapOutput = _791_valueOrError2.Extract(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _792_symmetricSigningKeyList = _790_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_790_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _793_edk = EncryptedDataKey.create(Constants_Compile.__default.RSA__PROVIDER__ID(), UTF8.__default.Encode(this.awsKmsKey()).dtor_value(), _790_wrapOutput.dtor_wrappedMaterial());
        EncryptionMaterials _794_returnMaterials = null;
        if (_790_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _795_valueOrError3 = null;
            _795_valueOrError3 = Materials_Compile.__default.EncryptionMaterialAddDataKey(input.dtor_materials(), _790_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_793_edk}), _792_symmetricSigningKeyList);
            if (_795_valueOrError3.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _795_valueOrError3.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _794_returnMaterials = _795_valueOrError3.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        } else if (_790_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _796_valueOrError4 = null;
            _796_valueOrError4 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(input.dtor_materials(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_793_edk}), _792_symmetricSigningKeyList);
            if (_796_valueOrError4.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _796_valueOrError4.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _794_returnMaterials = _796_valueOrError4.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        }
        res = Result.create_Success(OnEncryptOutput.create(_794_returnMaterials));
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out124;
        Result<OnDecryptOutput, Error> res = null;
        Outcome<Object> _797_valueOrError0 = Outcome.Default();
        _797_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.client().is_Some(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"An AwsKmsRsaKeyring without an AWS KMS client cannot provide OnDecrypt")));
        if (_797_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _797_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _798_materials = input.dtor_materials();
        Outcome<Object> _799_valueOrError1 = Outcome.Default();
        _799_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_798_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_799_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _799_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Object> _800_valueOrError2 = Outcome.Default();
        _800_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_algorithmSuite().dtor_signature().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"AwsKmsRsaKeyring cannot be used with an Algorithm Suite with asymmetric signing."), (DafnySequence)DafnySequence.asString((String)" Please specify an algorithm suite without asymmetric signing."))));
        if (_800_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _800_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        OnDecryptMrkAwareEncryptedDataKeyFilter _nw40 = new OnDecryptMrkAwareEncryptedDataKeyFilter();
        _nw40.__ctor(this.awsKmsArn(), Constants_Compile.__default.RSA__PROVIDER__ID());
        OnDecryptMrkAwareEncryptedDataKeyFilter _801_filter = _nw40;
        Result<Object, Object> _803_valueOrError3 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out122 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _801_filter, input.dtor_encryptedDataKeys());
        _803_valueOrError3 = _out122;
        if (_803_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _803_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _802_edksToAttempt = (DafnySequence)_803_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        Outcome<Object> _804_valueOrError4 = Outcome.Default();
        _804_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_802_edksToAttempt.length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to decrypt data key: No Encrypted Data Keys found to match.")));
        if (_804_valueOrError4.IsFailure(Error._typeDescriptor())) {
            res = _804_valueOrError4.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Result<Object, Object> _806_valueOrError5 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out123 = __default.EncryptionContextDigest(this.cryptoPrimitives(), _798_materials.dtor_encryptionContext());
        _806_valueOrError5 = _out123;
        if (_806_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _806_valueOrError5.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _805_encryptionContextDigest = (DafnySequence)_806_valueOrError5.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        DecryptSingleAWSRSAEncryptedDataKey _nw41 = new DecryptSingleAWSRSAEncryptedDataKey();
        _nw41.__ctor(_798_materials, this.client().dtor_value(), this.awsKmsKey(), this.paddingScheme(), (DafnySequence<? extends Byte>)_805_encryptionContextDigest, this.grantTokens());
        DecryptSingleAWSRSAEncryptedDataKey _807_decryptClosure = _nw41;
        Result<DecryptionMaterials, DafnySequence<Error>> _808_outcome = _out124 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _807_decryptClosure, _802_edksToAttempt);
        Result<DecryptionMaterials, Error> _810_valueOrError6 = null;
        _810_valueOrError6 = _808_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _811_errors_boxed0 -> {
            DafnySequence _811_errors = _811_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_811_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_810_valueOrError6.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _810_valueOrError6.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _809_SealedDecryptionMaterials = _810_valueOrError6.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_809_SealedDecryptionMaterials));
        return res;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public Option<IKMSClient> client() {
        return this._client;
    }

    public EncryptionAlgorithmSpec paddingScheme() {
        return this._paddingScheme;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public Option<DafnySequence<? extends Byte>> publicKey() {
        return this._publicKey;
    }

    public AwsKmsIdentifier awsKmsArn() {
        return this._awsKmsArn;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<AwsKmsRsaKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsRsaKeyring_Compile.AwsKmsRsaKeyring";
    }
}

