/*
 * Decompiled with CFR 0.152.
 */
package AESEncryption;

import AESEncryption.__default;
import Random_Compile.ExternRandom;
import Wrappers_Compile.Result;
import dafny.Array;
import dafny.DafnySequence;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.cryptography.primitives.ToDafny;
import software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput;
import software.amazon.cryptography.primitives.internaldafny.types.AES__GCM;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.model.OpaqueError;

public class AES_GCM {
    public static Result<AESEncryptOutput, Error> AESEncryptExtern(AES__GCM encAlg, DafnySequence<? extends Byte> iv, DafnySequence<? extends Byte> key, DafnySequence<? extends Byte> msg, DafnySequence<? extends Byte> aad) {
        byte[] keyBytes = (byte[])Array.unwrap((Array)key.toArray());
        byte[] nonceBytes = (byte[])Array.unwrap((Array)iv.toArray());
        byte[] plaintextBytes = (byte[])Array.unwrap((Array)msg.toArray());
        GCMParameterSpec spec = new GCMParameterSpec(encAlg._tagLength * 8, nonceBytes, 0, nonceBytes.length);
        try {
            Cipher cipher_ = Cipher.getInstance("AES/GCM/NoPadding");
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "AES");
            cipher_.init(1, (Key)secretKey, spec, ExternRandom.getSecureRandom());
            if (aad != null) {
                byte[] aadBytes = (byte[])Array.unwrap((Array)aad.toArray());
                cipher_.updateAAD(aadBytes);
            }
            byte[] cipherOutput = cipher_.doFinal(plaintextBytes);
            AESEncryptOutput aesEncryptOutput = __default.EncryptionOutputFromByteSeq((DafnySequence<? extends Byte>)DafnySequence.fromBytes((byte[])cipherOutput), encAlg);
            return Result.create_Success(aesEncryptOutput);
        }
        catch (GeneralSecurityException e) {
            return Result.create_Failure(ToDafny.Error(OpaqueError.builder().obj(e).build()));
        }
    }

    public static Result<DafnySequence<? extends Byte>, Error> AESDecryptExtern(AES__GCM encAlg, DafnySequence<? extends Byte> key, DafnySequence<? extends Byte> cipherTxt, DafnySequence<? extends Byte> authTag, DafnySequence<? extends Byte> iv, DafnySequence<? extends Byte> aad) {
        byte[] keyBytes = (byte[])Array.unwrap((Array)key.toArray());
        byte[] nonceBytes = (byte[])Array.unwrap((Array)iv.toArray());
        byte[] ciphertextBytes = (byte[])Array.unwrap((Array)cipherTxt.toArray());
        byte[] tagBytes = (byte[])Array.unwrap((Array)authTag.toArray());
        byte[] ciphertextAndTag = new byte[ciphertextBytes.length + tagBytes.length];
        System.arraycopy(ciphertextBytes, 0, ciphertextAndTag, 0, ciphertextBytes.length);
        System.arraycopy(tagBytes, 0, ciphertextAndTag, ciphertextBytes.length, tagBytes.length);
        GCMParameterSpec spec = new GCMParameterSpec(encAlg._tagLength * 8, nonceBytes, 0, nonceBytes.length);
        try {
            Cipher cipher_ = Cipher.getInstance("AES/GCM/NoPadding");
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "AES");
            cipher_.init(2, (Key)secretKey, spec, ExternRandom.getSecureRandom());
            if (aad != null) {
                byte[] aadBytes = (byte[])Array.unwrap((Array)aad.toArray());
                cipher_.updateAAD(aadBytes);
            }
            byte[] cipherOutput = cipher_.doFinal(ciphertextAndTag);
            return Result.create_Success(DafnySequence.fromBytes((byte[])cipherOutput));
        }
        catch (GeneralSecurityException e) {
            return Result.create_Failure(ToDafny.Error(OpaqueError.builder().obj(e).build()));
        }
    }
}

