/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.flightrecorder;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jfr.consumer.RecordedClass;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedMethod;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.consumer.RecordedStackTrace;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.EventProcessor;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.EventProcessorHelper;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.FlightRecorderEventType;
import software.amazon.codeguruprofilerjavaagent.profile.CallGraphBuilder;
import software.amazon.codeguruprofilerjavaagent.profile.MemoryCounter;
import software.amazon.codeguruprofilerjavaagent.profile.MemoryProfileSamplingMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.ProfileBuilder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\nH\u0014J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\nH\u0002J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\u001e\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\nH\u0002J\u001e\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\nH\u0002J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u0018H\u0002J6\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001a0\n2\u0006\u0010.\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006/"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/AllocationEventProcessor;", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/EventProcessor;", "maxEventsPerSecond", "", "(I)V", "logger", "Ljava/util/logging/Logger;", "getMaxEventsPerSecond", "()I", "supportedEvents", "", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/FlightRecorderEventType;", "getSupportedEvents", "()Ljava/util/List;", "allocationInNewTlabScalingFactor", "", "allocationSizeBytes", "", "tlabSizeBytes", "doProcess", "", "profileBuilder", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileBuilder;", "recordedEvents", "Ljdk/jfr/consumer/RecordedEvent;", "getFrames", "Ljava/lang/StackTraceElement;", "recordedStackTrace", "Ljdk/jfr/consumer/RecordedStackTrace;", "limitEventRate", "events", "log", "level", "Ljava/util/logging/Level;", "msg", "", "processSingleEventType", "recordSamplingMetadata", "samplingMetadata", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/MemoryProfileSamplingMetadata;", "scalingFactor", "event", "updateCallGraph", "callGraphBuilder", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/CallGraphBuilder;", "stackTrace", "objectType", "SkySailJavaAgent"})
@SourceDebugExtension(value={"SMAP\nAllocationEventProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllocationEventProcessor.kt\nsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/AllocationEventProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,209:1\n766#2:210\n857#2,2:211\n766#2:213\n857#2,2:214\n1855#2:216\n1856#2:218\n2310#2,14:219\n1940#2,14:233\n1549#2:249\n1620#2,3:250\n1#3:217\n37#4,2:247\n*S KotlinDebug\n*F\n+ 1 AllocationEventProcessor.kt\nsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/AllocationEventProcessor\n*L\n39#1:210\n39#1:211,2\n40#1:213\n40#1:214,2\n61#1:216\n61#1:218\n78#1:219,14\n79#1:233,14\n130#1:249\n130#1:250,3\n108#1:247,2\n*E\n"})
public final class AllocationEventProcessor
extends EventProcessor {
    private final int maxEventsPerSecond;
    @NotNull
    private final List<FlightRecorderEventType> supportedEvents;
    @NotNull
    private final Logger logger;

    public AllocationEventProcessor(int maxEventsPerSecond) {
        this.maxEventsPerSecond = maxEventsPerSecond;
        FlightRecorderEventType[] flightRecorderEventTypeArray = new FlightRecorderEventType[]{FlightRecorderEventType.AllocationInNewTlab, FlightRecorderEventType.AllocationOutsideTlab};
        this.supportedEvents = CollectionsKt.listOf((Object[])flightRecorderEventTypeArray);
        Logger logger = Logger.getLogger("javaClass");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(AllocationEven\u2026rocessor::javaClass.name)");
        this.logger = logger;
    }

    public /* synthetic */ AllocationEventProcessor(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        this(n);
    }

    public final int getMaxEventsPerSecond() {
        return this.maxEventsPerSecond;
    }

    @Override
    @NotNull
    public List<FlightRecorderEventType> getSupportedEvents() {
        return this.supportedEvents;
    }

    @Override
    protected void log(@NotNull Level level, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.logger.log(level, "[AllocationProfiler] " + msg + '.');
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doProcess(@NotNull ProfileBuilder profileBuilder, @NotNull List<RecordedEvent> recordedEvents) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)profileBuilder, (String)"profileBuilder");
        Intrinsics.checkNotNullParameter(recordedEvents, (String)"recordedEvents");
        if (recordedEvents.isEmpty()) {
            return;
        }
        Iterable $this$filter$iv = recordedEvents;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            RecordedEvent it = (RecordedEvent)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getEventType().getName(), (Object)FlightRecorderEventType.AllocationInNewTlab.getEventName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allocationsInsideNewTlab = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = recordedEvents;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RecordedEvent it = (RecordedEvent)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getEventType().getName(), (Object)FlightRecorderEventType.AllocationOutsideTlab.getEventName())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List allocationsOutsideTlab = (List)destination$iv$iv2;
        this.processSingleEventType(profileBuilder, allocationsInsideNewTlab);
        this.processSingleEventType(profileBuilder, allocationsOutsideTlab);
    }

    private final void processSingleEventType(ProfileBuilder profileBuilder, List<RecordedEvent> events) {
        List<RecordedEvent> selectedEvents = this.limitEventRate(events);
        this.recordSamplingMetadata(profileBuilder.getMemoryProfileSamplingMetadata(), selectedEvents);
        double rateLimitingScalingFactor = (double)events.size() / (double)selectedEvents.size();
        Iterable $this$forEach$iv = selectedEvents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            long allocationSizeBytes;
            String objectType;
            RecordedEvent event;
            block4: {
                block3: {
                    event = (RecordedEvent)element$iv;
                    boolean bl = false;
                    String string = event.getClass("objectClass").getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.getClass(\"objectClass\").name");
                    objectType = EventProcessorHelper.INSTANCE.translate(string);
                    allocationSizeBytes = event.getLong("allocationSize");
                    RecordedStackTrace recordedStackTrace = event.getStackTrace();
                    object = recordedStackTrace;
                    if (object == null) break block3;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stackTrace");
                    RecordedStackTrace it = recordedStackTrace;
                    boolean bl2 = false;
                    List<StackTraceElement> list = this.getFrames(it);
                    object = list;
                    if (list != null) break block4;
                }
                object = CollectionsKt.emptyList();
            }
            List<StackTraceElement> stackTrace = object;
            this.updateCallGraph(profileBuilder.getCallGraphBuilder(), stackTrace, objectType, allocationSizeBytes, this.scalingFactor(event) * rateLimitingScalingFactor);
        }
    }

    private final List<RecordedEvent> limitEventRate(List<RecordedEvent> events) {
        Object t;
        Object t2;
        if (events.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$minBy$iv = events;
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t2 = minElem$iv;
        } else {
            RecordedEvent it = (RecordedEvent)minElem$iv;
            boolean bl = false;
            Comparable minValue$iv = it.getStartTime();
            do {
                Object e$iv = iterator$iv.next();
                RecordedEvent it2 = (RecordedEvent)e$iv;
                $i$a$-minByOrThrow-AllocationEventProcessor$limitEventRate$firstEventStartTime$1 = false;
                Comparable v$iv = it2.getStartTime();
                if (minValue$iv.compareTo(v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t2 = minElem$iv;
        }
        RecordedEvent recordedEvent = (RecordedEvent)t2;
        Instant firstEventStartTime = recordedEvent != null ? recordedEvent.getStartTime() : null;
        Iterable $this$maxBy$iv = events;
        boolean $i$f$maxByOrThrow = false;
        Iterator iterator$iv2 = $this$maxBy$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = iterator$iv2.next();
        if (!iterator$iv2.hasNext()) {
            t = maxElem$iv;
        } else {
            RecordedEvent it = (RecordedEvent)maxElem$iv;
            boolean bl = false;
            Comparable maxValue$iv = it.getEndTime();
            do {
                Object e$iv = iterator$iv2.next();
                RecordedEvent it3 = (RecordedEvent)e$iv;
                $i$a$-maxByOrThrow-AllocationEventProcessor$limitEventRate$lastEventEndTime$1 = false;
                Comparable v$iv = it3.getEndTime();
                if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv2.hasNext());
            t = maxElem$iv;
        }
        RecordedEvent recordedEvent2 = (RecordedEvent)t;
        Instant lastEventEndTime = recordedEvent2 != null ? recordedEvent2.getEndTime() : null;
        Duration captureDuration = Duration.between(firstEventStartTime, lastEventEndTime);
        long maxNumEvents = Math.max(1L, captureDuration.getSeconds()) * (long)this.maxEventsPerSecond;
        return CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)events), (int)((int)maxNumEvents));
    }

    private final void updateCallGraph(CallGraphBuilder callGraphBuilder, List<StackTraceElement> stackTrace, String objectType, long allocationSizeBytes, double scalingFactor) {
        if (stackTrace.isEmpty()) {
            return;
        }
        String noMethodNameAvailable = "";
        String noFileNameAvailable = "";
        int noLineNumAvailable = -1;
        StackTraceElement objectTypeFrame = new StackTraceElement(objectType, noMethodNameAvailable, noFileNameAvailable, noLineNumAvailable);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)objectTypeFrame);
        Collection $this$toTypedArray$iv = stackTrace;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new StackTraceElement[0]));
        StackTraceElement[] newStack = (StackTraceElement[])spreadBuilder.toArray((Object[])new StackTraceElement[spreadBuilder.size()]);
        callGraphBuilder.capture(MemoryCounter.ALLOCATED_BYTES, MathKt.roundToInt((double)((double)allocationSizeBytes * scalingFactor)), Arrays.copyOf(newStack, newStack.length));
        callGraphBuilder.capture(MemoryCounter.ALLOCATION_COUNT, MathKt.roundToInt((double)(1.0 * scalingFactor)), Arrays.copyOf(newStack, newStack.length));
    }

    /*
     * WARNING - void declaration
     */
    private final List<StackTraceElement> getFrames(RecordedStackTrace recordedStackTrace) {
        void $this$mapTo$iv$iv;
        String noFileNameAvailable = "";
        int noLineNumAvailable = -1;
        List<RecordedFrame> list = recordedStackTrace.getFrames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"recordedStackTrace.frames");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2;
            String string3;
            void it;
            RecordedFrame recordedFrame = (RecordedFrame)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RecordedObject recordedObject = it.getMethod();
            String string4 = string3 = recordedObject != null && (recordedObject = ((RecordedMethod)recordedObject).getType()) != null ? ((RecordedClass)recordedObject).getName() : null;
            if (string4 == null) {
                string2 = "Unknown";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.method?.type?.name ?: \"Unknown\"");
                string2 = string3;
            }
            RecordedMethod recordedMethod = it.getMethod();
            String string5 = string3 = recordedMethod != null ? recordedMethod.getName() : null;
            if (string5 == null) {
                string = "Unknown";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.method?.name ?: \"Unknown\"");
                string = string3;
            }
            collection.add(new StackTraceElement(string2, string, noFileNameAvailable, noLineNumAvailable));
        }
        return (List)destination$iv$iv;
    }

    private final double scalingFactor(RecordedEvent event) {
        double d;
        String string = event.getEventType().getName();
        if (Intrinsics.areEqual((Object)string, (Object)FlightRecorderEventType.AllocationInNewTlab.getEventName())) {
            d = this.allocationInNewTlabScalingFactor(event.getLong("allocationSize"), event.getLong("tlabSize"));
        } else if (Intrinsics.areEqual((Object)string, (Object)FlightRecorderEventType.AllocationOutsideTlab.getEventName())) {
            d = 1.0;
        } else {
            throw new UnsupportedOperationException("Unsupported event type: " + event.getEventType().getName() + '.');
        }
        return d;
    }

    private final double allocationInNewTlabScalingFactor(long allocationSizeBytes, long tlabSizeBytes) {
        return (double)tlabSizeBytes / (double)allocationSizeBytes;
    }

    private final void recordSamplingMetadata(MemoryProfileSamplingMetadata samplingMetadata, List<RecordedEvent> recordedEvents) {
        int numUnscaledSamples = recordedEvents.size();
        samplingMetadata.getUnscaledSamples().compute(MemoryCounter.ALLOCATED_BYTES.serializedName, (arg_0, arg_1) -> AllocationEventProcessor.recordSamplingMetadata$lambda$7((Function2)new Function2<String, Integer, Integer>(numUnscaledSamples){
            final /* synthetic */ int $numUnscaledSamples;
            {
                this.$numUnscaledSamples = $numUnscaledSamples;
                super(2);
            }

            @Nullable
            public final Integer invoke(@NotNull String string, @Nullable Integer currentValue) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Integer n = currentValue;
                if (n == null) {
                    n = 0;
                }
                return n + this.$numUnscaledSamples;
            }
        }, arg_0, arg_1));
        samplingMetadata.getUnscaledSamples().compute(MemoryCounter.ALLOCATION_COUNT.serializedName, (arg_0, arg_1) -> AllocationEventProcessor.recordSamplingMetadata$lambda$8((Function2)new Function2<String, Integer, Integer>(numUnscaledSamples){
            final /* synthetic */ int $numUnscaledSamples;
            {
                this.$numUnscaledSamples = $numUnscaledSamples;
                super(2);
            }

            @Nullable
            public final Integer invoke(@NotNull String string, @Nullable Integer currentValue) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Integer n = currentValue;
                if (n == null) {
                    n = 0;
                }
                return n + this.$numUnscaledSamples;
            }
        }, arg_0, arg_1));
    }

    private static final Integer recordSamplingMetadata$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final Integer recordSamplingMetadata$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    public AllocationEventProcessor() {
        this(0, 1, null);
    }
}

