/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.configuration;

import com.amazonaws.services.lambda.runtime.Context;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import software.amazon.awssdk.services.codeguruprofiler.model.AgentConfiguration;
import software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField;
import software.amazon.codeguruprofilerjavaagent.ProfilerParameters;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;

public class ProfilerParametersMerger {
    public static final long DEFAULT_LAMBDA_MEMORY_USAGE_LIMIT_IN_BYTES = 0x1E00000L;
    private static final Logger LOG = Logger.getLogger(ProfilerParametersMerger.class.getName());
    private final ProfilerParameters defaultParameters;
    private final ErrorsMetadata errorsMetadata;

    public ProfilerParameters buildProfilerParameters(AgentConfiguration agentConfiguration) {
        ProfilerParameters.OverrideProfilerParameters remoteDynamicParameters = ProfilerParameters.OverrideProfilerParameters.builder().shouldProfile(Optional.ofNullable(agentConfiguration.shouldProfile())).reportingInterval(Optional.ofNullable(agentConfiguration.periodInSeconds()).map(Duration::ofSeconds)).build();
        ProfilerParameters.ProfilerParametersBuilder builder = this.defaultParameters.toBuilder();
        remoteDynamicParameters.overlay(builder);
        return builder.build();
    }

    public ProfilerParameters buildLambdaProfilerParameters(AgentConfiguration agentConfiguration, Context context) {
        ProfilerParameters.OverrideProfilerParameters remoteDynamicParameters = ProfilerParameters.OverrideProfilerParameters.builder().shouldProfile(Optional.ofNullable(agentConfiguration.shouldProfile())).reportingInterval(this.getParameterValue(agentConfiguration, AgentParameterField.REPORTING_INTERVAL_IN_MILLISECONDS.toString()).map(Double::longValue).map(Duration::ofMillis)).samplingInterval(this.getParameterValue(agentConfiguration, AgentParameterField.SAMPLING_INTERVAL_IN_MILLISECONDS.toString()).map(Double::longValue).map(Duration::ofMillis)).minimumTimeForReporting(this.getParameterValue(agentConfiguration, AgentParameterField.MINIMUM_TIME_FOR_REPORTING_IN_MILLISECONDS.toString()).map(Double::longValue).map(Duration::ofMillis)).stackDepthLimit(this.getParameterValue(agentConfiguration, AgentParameterField.MAX_STACK_DEPTH.toString()).map(Double::intValue)).memoryUsageLimit(this.getParameterValue(agentConfiguration, AgentParameterField.MEMORY_USAGE_LIMIT_PERCENT.toString()).map(percent -> this.getLambdaProfilerMemoryUsageLimitInBytes(context, (double)percent))).build();
        ProfilerParameters.ProfilerParametersBuilder builder = this.defaultParameters.toBuilder();
        remoteDynamicParameters.overlay(builder);
        return builder.build();
    }

    private Optional<Double> getParameterValue(AgentConfiguration agentConfiguration, String parameterName) {
        try {
            String parameterValue;
            if (agentConfiguration != null && agentConfiguration.agentParametersAsStrings() != null && (parameterValue = (String)agentConfiguration.agentParametersAsStrings().get(parameterName)) != null) {
                return Optional.of(Double.valueOf(parameterValue));
            }
        }
        catch (Exception e) {
            this.errorsMetadata.record(LOG, Level.INFO, String.format("Exception thrown while parsing value of %s parameter", parameterName), e);
        }
        return Optional.empty();
    }

    private long getLambdaProfilerMemoryUsageLimitInBytes(Context context, double percent) {
        long lambdaProfilerMemoryUsageLimitInBytes = 0x1E00000L;
        try {
            if (context != null) {
                long lambdaMemoryLimitInBytes = context.getMemoryLimitInMB() << 20;
                lambdaProfilerMemoryUsageLimitInBytes = Math.max(0x1E00000L, (long)((double)lambdaMemoryLimitInBytes * percent / 100.0));
            }
        }
        catch (Exception e) {
            this.errorsMetadata.recordProfiling(LOG, Level.INFO, "Exception thrown while reading lambda context's memory limit", e);
        }
        return lambdaProfilerMemoryUsageLimitInBytes;
    }

    @Generated
    public ProfilerParametersMerger(ProfilerParameters defaultParameters, ErrorsMetadata errorsMetadata) {
        this.defaultParameters = defaultParameters;
        this.errorsMetadata = errorsMetadata;
    }
}

