/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import lombok.Generated;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform;
import software.amazon.codeguruprofilerjavaagent.CodeGuruProfilerSDKClient;
import software.amazon.codeguruprofilerjavaagent.CodeGuruProfilerSDKClientOverrideConfiguration;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInfo;

class CodeGuruProfilerSDKClientProvider {
    private final String profilingGroupName;
    private final String computePlatform;
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final Region awsRegion;
    private final ErrorsMetadata errorsMetadata;
    private final AgentMetadata agentMetadata;
    private CodeGuruProfilerSDKClient client;

    public CodeGuruProfilerSDKClient getClient() {
        if (this.client == null) {
            String fleetInstanceId = this.agentMetadata.getFleetInfo().map(FleetInfo::getFleetInstanceId).orElse("");
            String computePlatform = this.computePlatform == null ? ComputePlatform.DEFAULT.toString() : this.computePlatform;
            this.client = new CodeGuruProfilerSDKClient(this.profilingGroupName, fleetInstanceId, computePlatform, this.awsCredentialsProvider, this.awsRegion, CodeGuruProfilerSDKClientOverrideConfiguration.DEFAULT, this.errorsMetadata);
        }
        return this.client;
    }

    @Generated
    CodeGuruProfilerSDKClientProvider(String profilingGroupName, String computePlatform, AwsCredentialsProvider awsCredentialsProvider, Region awsRegion, ErrorsMetadata errorsMetadata, AgentMetadata agentMetadata, CodeGuruProfilerSDKClient client) {
        this.profilingGroupName = profilingGroupName;
        this.computePlatform = computePlatform;
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.awsRegion = awsRegion;
        this.errorsMetadata = errorsMetadata;
        this.agentMetadata = agentMetadata;
        this.client = client;
    }

    @Generated
    public static CodeGuruProfilerSDKClientProviderBuilder builder() {
        return new CodeGuruProfilerSDKClientProviderBuilder();
    }

    public static class CodeGuruProfilerSDKClientProviderBuilder {
        @Generated
        private String profilingGroupName;
        @Generated
        private String computePlatform;
        @Generated
        private AwsCredentialsProvider awsCredentialsProvider;
        @Generated
        private Region awsRegion;
        @Generated
        private ErrorsMetadata errorsMetadata;
        @Generated
        private AgentMetadata agentMetadata;
        @Generated
        private CodeGuruProfilerSDKClient client;

        public Region getAwsRegion() {
            return this.awsRegion;
        }

        public AwsCredentialsProvider getAwsCredentialsProvider() {
            return this.awsCredentialsProvider;
        }

        @Generated
        CodeGuruProfilerSDKClientProviderBuilder() {
        }

        @Generated
        public CodeGuruProfilerSDKClientProviderBuilder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        @Generated
        public CodeGuruProfilerSDKClientProviderBuilder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Generated
        public CodeGuruProfilerSDKClientProviderBuilder awsCredentialsProvider(AwsCredentialsProvider awsCredentialsProvider) {
            this.awsCredentialsProvider = awsCredentialsProvider;
            return this;
        }

        @Generated
        public CodeGuruProfilerSDKClientProviderBuilder awsRegion(Region awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        @Generated
        public CodeGuruProfilerSDKClientProviderBuilder errorsMetadata(ErrorsMetadata errorsMetadata) {
            this.errorsMetadata = errorsMetadata;
            return this;
        }

        @Generated
        public CodeGuruProfilerSDKClientProviderBuilder agentMetadata(AgentMetadata agentMetadata) {
            this.agentMetadata = agentMetadata;
            return this;
        }

        @Generated
        public CodeGuruProfilerSDKClientProviderBuilder client(CodeGuruProfilerSDKClient client) {
            this.client = client;
            return this;
        }

        @Generated
        public CodeGuruProfilerSDKClientProvider build() {
            return new CodeGuruProfilerSDKClientProvider(this.profilingGroupName, this.computePlatform, this.awsCredentialsProvider, this.awsRegion, this.errorsMetadata, this.agentMetadata, this.client);
        }

        @Generated
        public String toString() {
            return "CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder(profilingGroupName=" + this.profilingGroupName + ", computePlatform=" + this.computePlatform + ", awsCredentialsProvider=" + this.awsCredentialsProvider + ", awsRegion=" + this.awsRegion + ", errorsMetadata=" + this.errorsMetadata + ", agentMetadata=" + this.agentMetadata + ", client=" + this.client + ")";
        }
    }
}

