/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.flightrecorder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.FlightRecorderEventType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*Bg\u00128\b\u0002\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0003\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\fH\u0002J\b\u0010 \u001a\u00020\tH\u0002J\b\u0010!\u001a\u00020\u001eH\u0002J\u0006\u0010\"\u001a\u00020#J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0010J\u0006\u0010&\u001a\u00020\u001eJ\u0010\u0010'\u001a\u00020\u001e2\b\b\u0002\u0010(\u001a\u00020#J\b\u0010)\u001a\u00020\u001eH\u0002R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/RecordingHandler;", "", "temporaryFileFactory", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "prefix", "suffix", "Ljava/io/File;", "recordingFactory", "Lkotlin/Function0;", "Ljdk/jfr/Recording;", "maxStackDepth", "", "eventTypes", "", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/FlightRecorderEventType;", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;ILjava/util/List;)V", "<set-?>", "", "latestRecordingFileSizeBytes", "getLatestRecordingFileSizeBytes", "()Ljava/lang/Long;", "Ljava/lang/Long;", "logger", "Ljava/util/logging/Logger;", "recording", "recordingFile", "closeRecording", "", "createRecording", "createTempFile", "emptyRecordingFile", "isRecording", "", "processRecordedEvents", "Ljdk/jfr/consumer/RecordedEvent;", "startRecording", "stopRecording", "dropData", "trySetFlightRecorderMaxStackDepth", "Companion", "SkySailJavaAgent"})
public final class RecordingHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Function2<String, String, File> temporaryFileFactory;
    @NotNull
    private final Function0<Recording> recordingFactory;
    private final int maxStackDepth;
    @NotNull
    private final List<FlightRecorderEventType> eventTypes;
    @NotNull
    private final Logger logger;
    @NotNull
    private final File recordingFile;
    @NotNull
    private Recording recording;
    @Nullable
    private Long latestRecordingFileSizeBytes;
    @Deprecated
    public static final int DEFAULT_MAX_STACK_DEPTH = 1000;
    @Deprecated
    public static final long RECORDING_MAX_SIZE_BYTES = 50000000L;
    @Deprecated
    public static final boolean TO_DISK = true;

    public RecordingHandler(@NotNull Function2<? super String, ? super String, ? extends File> temporaryFileFactory, @NotNull Function0<Recording> recordingFactory, int maxStackDepth, @NotNull List<? extends FlightRecorderEventType> eventTypes) {
        Intrinsics.checkNotNullParameter(temporaryFileFactory, (String)"temporaryFileFactory");
        Intrinsics.checkNotNullParameter(recordingFactory, (String)"recordingFactory");
        Intrinsics.checkNotNullParameter(eventTypes, (String)"eventTypes");
        this.temporaryFileFactory = temporaryFileFactory;
        this.recordingFactory = recordingFactory;
        this.maxStackDepth = maxStackDepth;
        this.eventTypes = eventTypes;
        Logger logger = Logger.getLogger("javaClass");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(RecordingHandler::javaClass.name)");
        this.logger = logger;
        this.recordingFile = this.createTempFile();
        this.recording = this.createRecording();
        this.trySetFlightRecorderMaxStackDepth();
    }

    public /* synthetic */ RecordingHandler(Function2 function2, Function0 function0, int n, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            function2 = 1.INSTANCE;
        }
        if ((n2 & 2) != 0) {
            function0 = 2.INSTANCE;
        }
        if ((n2 & 4) != 0) {
            n = 1000;
        }
        this((Function2<? super String, ? super String, ? extends File>)function2, (Function0<Recording>)function0, n, list);
    }

    @Nullable
    public final Long getLatestRecordingFileSizeBytes() {
        return this.latestRecordingFileSizeBytes;
    }

    public final void startRecording() {
        RecordingState currentState = this.recording.getState();
        if (currentState == RecordingState.CLOSED || currentState == RecordingState.NEW) {
            this.recording = this.createRecording();
            this.recording.start();
            this.logger.log(Level.FINE, "Started the JFR Recording!");
        }
    }

    public final void stopRecording(boolean dropData) {
        if (!this.isRecording()) {
            return;
        }
        if (dropData) {
            this.closeRecording();
            return;
        }
        this.recording.stop();
        this.logger.log(Level.FINE, "Stopped the JFR Recording!");
    }

    public static /* synthetic */ void stopRecording$default(RecordingHandler recordingHandler2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        recordingHandler2.stopRecording(bl);
    }

    public final boolean isRecording() {
        return this.recording.getState() == RecordingState.RUNNING;
    }

    @NotNull
    public final List<RecordedEvent> processRecordedEvents() {
        List<RecordedEvent> recordedEvents = CollectionsKt.emptyList();
        if (this.recording.getState() != RecordingState.STOPPED) {
            return recordedEvents;
        }
        try {
            Path path = this.recordingFile.toPath();
            this.recording.dump(path);
            List<RecordedEvent> list = RecordingFile.readAllEvents(path);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllEvents(path)");
            recordedEvents = list;
            this.latestRecordingFileSizeBytes = Files.size(path);
            this.emptyRecordingFile();
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, "An IOException occurred while retrieving recorded events!", e);
        }
        this.closeRecording();
        return recordedEvents;
    }

    private final void closeRecording() {
        if (this.recording.getState() == RecordingState.CLOSED) {
            return;
        }
        this.recording.close();
        this.logger.log(Level.FINE, "Closed the JFR Recording!");
    }

    private final void trySetFlightRecorderMaxStackDepth() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            String[][] stringArrayArray = new String[1][];
            String[] stringArray = new String[]{"stackdepth=" + this.maxStackDepth};
            stringArrayArray[0] = stringArray;
            Object[] objectArray = (Object[])stringArrayArray;
            stringArrayArray = new String[]{String[].class.getName()};
            mBeanServer.invoke(new ObjectName("com.sun.management:type=DiagnosticCommand"), "jfrConfigure", objectArray, (String[])stringArrayArray);
        }
        catch (JMException e) {
            this.logger.log(Level.FINE, "Failed to update stack depth of JFR, will fall back to default.", e);
        }
    }

    private final File createTempFile() throws IOException {
        File newFile = (File)this.temporaryFileFactory.invoke((Object)"jfr-recording", (Object)".jfr");
        newFile.deleteOnExit();
        return newFile;
    }

    private final void emptyRecordingFile() throws IOException {
        new FileWriter(this.recordingFile, false).close();
    }

    private final Recording createRecording() {
        Recording newRecording = (Recording)this.recordingFactory.invoke();
        newRecording.setToDisk(true);
        newRecording.setMaxSize(50000000L);
        Iterable $this$forEach$iv = this.eventTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FlightRecorderEventType it = (FlightRecorderEventType)((Object)element$iv);
            boolean bl = false;
            newRecording.enable(it.getEventName());
        }
        this.logger.log(Level.FINE, "Created a new JFR Recording!");
        return newRecording;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/RecordingHandler$Companion;", "", "()V", "DEFAULT_MAX_STACK_DEPTH", "", "RECORDING_MAX_SIZE_BYTES", "", "TO_DISK", "", "SkySailJavaAgent"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

