/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.flightrecorder;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jfr.consumer.RecordedEvent;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.EventProcessor;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.EventProcessorHelper;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.FlightRecorderEventType;
import software.amazon.codeguruprofilerjavaagent.profile.ClassSummary;
import software.amazon.codeguruprofilerjavaagent.profile.ProfileBuilder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u0014J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/ObjectCountEventProcessor;", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/EventProcessor;", "runtimeMxBean", "Ljava/lang/management/RuntimeMXBean;", "(Ljava/lang/management/RuntimeMXBean;)V", "logger", "Ljava/util/logging/Logger;", "supportedEvents", "", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/FlightRecorderEventType;", "getSupportedEvents", "()Ljava/util/List;", "doProcess", "", "profileBuilder", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileBuilder;", "recordedEvents", "Ljdk/jfr/consumer/RecordedEvent;", "log", "level", "Ljava/util/logging/Level;", "msg", "", "ObjectCountEvent", "SkySailJavaAgent"})
public final class ObjectCountEventProcessor
extends EventProcessor {
    @NotNull
    private final RuntimeMXBean runtimeMxBean;
    @NotNull
    private final List<FlightRecorderEventType> supportedEvents;
    @NotNull
    private final Logger logger;

    public ObjectCountEventProcessor(@NotNull RuntimeMXBean runtimeMxBean) {
        Intrinsics.checkNotNullParameter((Object)runtimeMxBean, (String)"runtimeMxBean");
        this.runtimeMxBean = runtimeMxBean;
        FlightRecorderEventType[] flightRecorderEventTypeArray = new FlightRecorderEventType[]{FlightRecorderEventType.ObjectCountAfterGC, FlightRecorderEventType.GCHeapSummary};
        this.supportedEvents = CollectionsKt.listOf((Object[])flightRecorderEventTypeArray);
        Logger logger = Logger.getLogger("javaClass");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ObjectCountEve\u2026rocessor::javaClass.name)");
        this.logger = logger;
    }

    public /* synthetic */ ObjectCountEventProcessor(RuntimeMXBean runtimeMXBean, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            RuntimeMXBean runtimeMXBean2 = ManagementFactory.getRuntimeMXBean();
            Intrinsics.checkNotNullExpressionValue((Object)runtimeMXBean2, (String)"getRuntimeMXBean()");
            runtimeMXBean = runtimeMXBean2;
        }
        this(runtimeMXBean);
    }

    @Override
    @NotNull
    public List<FlightRecorderEventType> getSupportedEvents() {
        return this.supportedEvents;
    }

    @Override
    protected void log(@NotNull Level level, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.logger.log(level, "[HeapSummary] " + msg + '.');
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doProcess(@NotNull ProfileBuilder profileBuilder, @NotNull List<RecordedEvent> recordedEvents) {
        void $this$groupByTo$iv$iv;
        Object item$iv$iv3;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        RecordedEvent it;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)profileBuilder, (String)"profileBuilder");
        Intrinsics.checkNotNullParameter(recordedEvents, (String)"recordedEvents");
        if (recordedEvents.size() == 0) {
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            this.log(level, "There were no appropriate GC cycles during this period. Heap summary may not be available for this period from this agent.");
        }
        Iterable $this$filter$iv2 = recordedEvents;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (RecordedEvent)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getEventType().getName(), (Object)FlightRecorderEventType.ObjectCountAfterGC.getEventName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            it = (RecordedEvent)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ObjectCountEvent(it));
        }
        List objectCountEvents = (List)destination$iv$iv;
        Iterable $i$f$map22 = recordedEvents;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RecordedEvent it2 = (RecordedEvent)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it2.getEventType().getName(), (Object)FlightRecorderEventType.GCHeapSummary.getEventName()) && Intrinsics.areEqual((Object)it2.getString("when"), (Object)"After GC"))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            RecordedEvent it2 = (RecordedEvent)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it2.getInt("gcId"), (Object)it2.getLong("heapUsed")));
        }
        Map afterGCHeapUsed = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        long maxHeapAvailableBytes = Runtime.getRuntime().maxMemory();
        long uptimeMillis = this.runtimeMxBean.getUptime();
        Iterable $this$groupBy$iv = objectCountEvents;
        boolean $i$f$groupBy = false;
        item$iv$iv3 = $this$groupBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ObjectCountEvent it3 = (ObjectCountEvent)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it3.getGcId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        destination$iv$iv3.forEach((arg_0, arg_1) -> ObjectCountEventProcessor.doProcess$lambda$5((Function2)new Function2<Integer, List<? extends ObjectCountEvent>, Unit>((Map<Integer, Long>)afterGCHeapUsed, profileBuilder, uptimeMillis, maxHeapAvailableBytes){
            final /* synthetic */ Map<Integer, Long> $afterGCHeapUsed;
            final /* synthetic */ ProfileBuilder $profileBuilder;
            final /* synthetic */ long $uptimeMillis;
            final /* synthetic */ long $maxHeapAvailableBytes;
            {
                this.$afterGCHeapUsed = $afterGCHeapUsed;
                this.$profileBuilder = $profileBuilder;
                this.$uptimeMillis = $uptimeMillis;
                this.$maxHeapAvailableBytes = $maxHeapAvailableBytes;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Integer gcId, @NotNull List<ObjectCountEvent> events) {
                void $this$mapTo$iv$iv;
                ObjectCountEvent eventWithMinStartTime;
                Object minValue$iv;
                T t;
                Intrinsics.checkNotNullParameter((Object)gcId, (String)"gcId");
                Intrinsics.checkNotNullParameter(events, (String)"events");
                Long heapUsedBytes = this.$afterGCHeapUsed.get(gcId);
                Iterable $this$minBy$iv = events;
                boolean $i$f$minByOrThrow = false;
                Iterator<T> iterator$iv = $this$minBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                T minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    t = minElem$iv;
                } else {
                    ObjectCountEvent it = (ObjectCountEvent)minElem$iv;
                    boolean bl = false;
                    minValue$iv = it.getEventStartTime();
                    do {
                        T e$iv = iterator$iv.next();
                        ObjectCountEvent it2 = (ObjectCountEvent)e$iv;
                        $i$a$-minByOrThrow-ObjectCountEventProcessor$doProcess$2$eventWithMinStartTime$1 = false;
                        Comparable v$iv = it2.getEventStartTime();
                        if (minValue$iv.compareTo(v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    t = minElem$iv;
                }
                ObjectCountEvent objectCountEvent = eventWithMinStartTime = (ObjectCountEvent)t;
                Intrinsics.checkNotNull((Object)objectCountEvent);
                Instant captureTimestamp = objectCountEvent.getEventStartTime();
                Iterable $this$map$iv = events;
                boolean $i$f$map = false;
                minValue$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ObjectCountEvent objectCountEvent2 = (ObjectCountEvent)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new ClassSummary(it.getObjectType(), it.getObjectCount(), it.getTotalSizeBytes()));
                }
                List classSummaries = (List)destination$iv$iv;
                this.$profileBuilder.getHeapSummaryBuilder().capture(captureTimestamp, this.$uptimeMillis, this.$maxHeapAvailableBytes, heapUsedBytes, classSummaries);
            }
        }, arg_0, arg_1));
    }

    private static final void doProcess$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public ObjectCountEventProcessor() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\rH\u00c6\u0003J;\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\rH\u00d6\u0001J\t\u0010\"\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006#"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/ObjectCountEventProcessor$ObjectCountEvent;", "", "recordedEvent", "Ljdk/jfr/consumer/RecordedEvent;", "(Ljdk/jfr/consumer/RecordedEvent;)V", "eventStartTime", "Ljava/time/Instant;", "objectCount", "", "objectType", "", "totalSizeBytes", "gcId", "", "(Ljava/time/Instant;JLjava/lang/String;JI)V", "getEventStartTime", "()Ljava/time/Instant;", "getGcId", "()I", "getObjectCount", "()J", "getObjectType", "()Ljava/lang/String;", "getTotalSizeBytes", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "SkySailJavaAgent"})
    private static final class ObjectCountEvent {
        @NotNull
        private final Instant eventStartTime;
        private final long objectCount;
        @NotNull
        private final String objectType;
        private final long totalSizeBytes;
        private final int gcId;

        public ObjectCountEvent(@NotNull Instant eventStartTime, long objectCount, @NotNull String objectType, long totalSizeBytes, int gcId) {
            Intrinsics.checkNotNullParameter((Object)eventStartTime, (String)"eventStartTime");
            Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
            this.eventStartTime = eventStartTime;
            this.objectCount = objectCount;
            this.objectType = objectType;
            this.totalSizeBytes = totalSizeBytes;
            this.gcId = gcId;
        }

        @NotNull
        public final Instant getEventStartTime() {
            return this.eventStartTime;
        }

        public final long getObjectCount() {
            return this.objectCount;
        }

        @NotNull
        public final String getObjectType() {
            return this.objectType;
        }

        public final long getTotalSizeBytes() {
            return this.totalSizeBytes;
        }

        public final int getGcId() {
            return this.gcId;
        }

        public ObjectCountEvent(@NotNull RecordedEvent recordedEvent) {
            Intrinsics.checkNotNullParameter((Object)recordedEvent, (String)"recordedEvent");
            Instant instant = recordedEvent.getStartTime();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"recordedEvent.startTime");
            long l = recordedEvent.getLong("count");
            String string = recordedEvent.getClass("objectClass").getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"recordedEvent.getClass(\"objectClass\").name");
            this(instant, l, EventProcessorHelper.INSTANCE.translate(string), recordedEvent.getLong("totalSize"), recordedEvent.getInt("gcId"));
        }

        @NotNull
        public final Instant component1() {
            return this.eventStartTime;
        }

        public final long component2() {
            return this.objectCount;
        }

        @NotNull
        public final String component3() {
            return this.objectType;
        }

        public final long component4() {
            return this.totalSizeBytes;
        }

        public final int component5() {
            return this.gcId;
        }

        @NotNull
        public final ObjectCountEvent copy(@NotNull Instant eventStartTime, long objectCount, @NotNull String objectType, long totalSizeBytes, int gcId) {
            Intrinsics.checkNotNullParameter((Object)eventStartTime, (String)"eventStartTime");
            Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
            return new ObjectCountEvent(eventStartTime, objectCount, objectType, totalSizeBytes, gcId);
        }

        public static /* synthetic */ ObjectCountEvent copy$default(ObjectCountEvent objectCountEvent, Instant instant, long l, String string, long l2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                instant = objectCountEvent.eventStartTime;
            }
            if ((n2 & 2) != 0) {
                l = objectCountEvent.objectCount;
            }
            if ((n2 & 4) != 0) {
                string = objectCountEvent.objectType;
            }
            if ((n2 & 8) != 0) {
                l2 = objectCountEvent.totalSizeBytes;
            }
            if ((n2 & 0x10) != 0) {
                n = objectCountEvent.gcId;
            }
            return objectCountEvent.copy(instant, l, string, l2, n);
        }

        @NotNull
        public String toString() {
            return "ObjectCountEvent(eventStartTime=" + this.eventStartTime + ", objectCount=" + this.objectCount + ", objectType=" + this.objectType + ", totalSizeBytes=" + this.totalSizeBytes + ", gcId=" + this.gcId + ')';
        }

        public int hashCode() {
            int result = this.eventStartTime.hashCode();
            result = result * 31 + Long.hashCode(this.objectCount);
            result = result * 31 + this.objectType.hashCode();
            result = result * 31 + Long.hashCode(this.totalSizeBytes);
            result = result * 31 + Integer.hashCode(this.gcId);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ObjectCountEvent)) {
                return false;
            }
            ObjectCountEvent objectCountEvent = (ObjectCountEvent)other;
            if (!Intrinsics.areEqual((Object)this.eventStartTime, (Object)objectCountEvent.eventStartTime)) {
                return false;
            }
            if (this.objectCount != objectCountEvent.objectCount) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.objectType, (Object)objectCountEvent.objectType)) {
                return false;
            }
            if (this.totalSizeBytes != objectCountEvent.totalSizeBytes) {
                return false;
            }
            return this.gcId == objectCountEvent.gcId;
        }
    }
}

