/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import software.amazon.codeguruprofilerjavaagent.BasicThreadSupport;
import software.amazon.codeguruprofilerjavaagent.ThreadSupport;

public final class ProfilerParameters {
    @NonNull
    private final String profilingGroupName;
    @NonNull
    private final ThreadSupport threadSupport;
    @NonNull
    private final Set<String> excludedThreads;
    private final boolean shouldProfile;
    private final String integrationMode;
    private final long memoryUsageLimit;
    private final boolean heapSummaryEnabled;
    private final boolean allocationProfilingEnabled;
    private final int stackDepthLimit;
    @NonNull
    private final Duration samplingInterval;
    @NonNull
    private final Duration reportingInterval;
    private final boolean addProfilerOverheadAsSamples;
    @NonNull
    private final Duration minimumTimeForReporting;
    private final int dontReportIfSampledLessThanTimes;

    public String toString() {
        return "ProfilerParameters{profilingGroupName='" + this.profilingGroupName + '\'' + ", threadSupport=" + this.threadSupport + ", excludedThreads=" + this.excludedThreads + ", shouldProfile=" + this.shouldProfile + ", integrationMode='" + this.integrationMode + '\'' + ", memoryUsageLimit=" + this.memoryUsageLimit + ", heapSummaryEnabled=" + this.heapSummaryEnabled + ", stackDepthLimit=" + this.stackDepthLimit + ", samplingInterval=" + this.samplingInterval + ", reportingInterval=" + this.reportingInterval + ", addProfilerOverheadAsSamples=" + this.addProfilerOverheadAsSamples + ", minimumTimeForReporting=" + this.minimumTimeForReporting + ", dontReportIfSampledLessThanTimes=" + this.dontReportIfSampledLessThanTimes + '}';
    }

    private static ThreadSupport $default$threadSupport() {
        return new BasicThreadSupport();
    }

    private static Set<String> $default$excludedThreads() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Attach Listener", "Signal Dispatcher")));
    }

    private static boolean $default$shouldProfile() {
        return true;
    }

    private static String $default$integrationMode() {
        return "";
    }

    private static long $default$memoryUsageLimit() {
        return 0x6400000L;
    }

    private static boolean $default$heapSummaryEnabled() {
        return false;
    }

    private static boolean $default$allocationProfilingEnabled() {
        return false;
    }

    private static int $default$stackDepthLimit() {
        return 1000;
    }

    private static Duration $default$samplingInterval() {
        return Duration.ofSeconds(1L);
    }

    private static Duration $default$reportingInterval() {
        return Duration.ofMinutes(5L);
    }

    private static boolean $default$addProfilerOverheadAsSamples() {
        return true;
    }

    private static Duration $default$minimumTimeForReporting() {
        return Duration.ofMinutes(1L);
    }

    private static int $default$dontReportIfSampledLessThanTimes() {
        return 1;
    }

    @ConstructorProperties(value={"profilingGroupName", "threadSupport", "excludedThreads", "shouldProfile", "integrationMode", "memoryUsageLimit", "heapSummaryEnabled", "allocationProfilingEnabled", "stackDepthLimit", "samplingInterval", "reportingInterval", "addProfilerOverheadAsSamples", "minimumTimeForReporting", "dontReportIfSampledLessThanTimes"})
    ProfilerParameters(@NonNull String profilingGroupName, @NonNull ThreadSupport threadSupport, @NonNull Set<String> excludedThreads, boolean shouldProfile, String integrationMode, long memoryUsageLimit, boolean heapSummaryEnabled, boolean allocationProfilingEnabled, int stackDepthLimit, @NonNull Duration samplingInterval, @NonNull Duration reportingInterval, boolean addProfilerOverheadAsSamples, @NonNull Duration minimumTimeForReporting, int dontReportIfSampledLessThanTimes) {
        if (profilingGroupName == null) {
            throw new NullPointerException("profilingGroupName");
        }
        if (threadSupport == null) {
            throw new NullPointerException("threadSupport");
        }
        if (excludedThreads == null) {
            throw new NullPointerException("excludedThreads");
        }
        if (samplingInterval == null) {
            throw new NullPointerException("samplingInterval");
        }
        if (reportingInterval == null) {
            throw new NullPointerException("reportingInterval");
        }
        if (minimumTimeForReporting == null) {
            throw new NullPointerException("minimumTimeForReporting");
        }
        this.profilingGroupName = profilingGroupName;
        this.threadSupport = threadSupport;
        this.excludedThreads = excludedThreads;
        this.shouldProfile = shouldProfile;
        this.integrationMode = integrationMode;
        this.memoryUsageLimit = memoryUsageLimit;
        this.heapSummaryEnabled = heapSummaryEnabled;
        this.allocationProfilingEnabled = allocationProfilingEnabled;
        this.stackDepthLimit = stackDepthLimit;
        this.samplingInterval = samplingInterval;
        this.reportingInterval = reportingInterval;
        this.addProfilerOverheadAsSamples = addProfilerOverheadAsSamples;
        this.minimumTimeForReporting = minimumTimeForReporting;
        this.dontReportIfSampledLessThanTimes = dontReportIfSampledLessThanTimes;
    }

    public static ProfilerParametersBuilder builder() {
        return new ProfilerParametersBuilder();
    }

    public ProfilerParametersBuilder toBuilder() {
        return new ProfilerParametersBuilder().profilingGroupName(this.profilingGroupName).threadSupport(this.threadSupport).excludedThreads(this.excludedThreads).shouldProfile(this.shouldProfile).integrationMode(this.integrationMode).memoryUsageLimit(this.memoryUsageLimit).heapSummaryEnabled(this.heapSummaryEnabled).allocationProfilingEnabled(this.allocationProfilingEnabled).stackDepthLimit(this.stackDepthLimit).samplingInterval(this.samplingInterval).reportingInterval(this.reportingInterval).addProfilerOverheadAsSamples(this.addProfilerOverheadAsSamples).minimumTimeForReporting(this.minimumTimeForReporting).dontReportIfSampledLessThanTimes(this.dontReportIfSampledLessThanTimes);
    }

    @NonNull
    public String getProfilingGroupName() {
        return this.profilingGroupName;
    }

    @NonNull
    public ThreadSupport getThreadSupport() {
        return this.threadSupport;
    }

    @NonNull
    public Set<String> getExcludedThreads() {
        return this.excludedThreads;
    }

    public boolean isShouldProfile() {
        return this.shouldProfile;
    }

    public String getIntegrationMode() {
        return this.integrationMode;
    }

    public long getMemoryUsageLimit() {
        return this.memoryUsageLimit;
    }

    public boolean isHeapSummaryEnabled() {
        return this.heapSummaryEnabled;
    }

    public boolean isAllocationProfilingEnabled() {
        return this.allocationProfilingEnabled;
    }

    public int getStackDepthLimit() {
        return this.stackDepthLimit;
    }

    @NonNull
    public Duration getSamplingInterval() {
        return this.samplingInterval;
    }

    @NonNull
    public Duration getReportingInterval() {
        return this.reportingInterval;
    }

    public boolean isAddProfilerOverheadAsSamples() {
        return this.addProfilerOverheadAsSamples;
    }

    @NonNull
    public Duration getMinimumTimeForReporting() {
        return this.minimumTimeForReporting;
    }

    public int getDontReportIfSampledLessThanTimes() {
        return this.dontReportIfSampledLessThanTimes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfilerParameters)) {
            return false;
        }
        ProfilerParameters other = (ProfilerParameters)o;
        String this$profilingGroupName = this.getProfilingGroupName();
        String other$profilingGroupName = other.getProfilingGroupName();
        if (this$profilingGroupName == null ? other$profilingGroupName != null : !this$profilingGroupName.equals(other$profilingGroupName)) {
            return false;
        }
        ThreadSupport this$threadSupport = this.getThreadSupport();
        ThreadSupport other$threadSupport = other.getThreadSupport();
        if (this$threadSupport == null ? other$threadSupport != null : !this$threadSupport.equals(other$threadSupport)) {
            return false;
        }
        Set<String> this$excludedThreads = this.getExcludedThreads();
        Set<String> other$excludedThreads = other.getExcludedThreads();
        if (this$excludedThreads == null ? other$excludedThreads != null : !((Object)this$excludedThreads).equals(other$excludedThreads)) {
            return false;
        }
        if (this.isShouldProfile() != other.isShouldProfile()) {
            return false;
        }
        String this$integrationMode = this.getIntegrationMode();
        String other$integrationMode = other.getIntegrationMode();
        if (this$integrationMode == null ? other$integrationMode != null : !this$integrationMode.equals(other$integrationMode)) {
            return false;
        }
        if (this.getMemoryUsageLimit() != other.getMemoryUsageLimit()) {
            return false;
        }
        if (this.isHeapSummaryEnabled() != other.isHeapSummaryEnabled()) {
            return false;
        }
        if (this.isAllocationProfilingEnabled() != other.isAllocationProfilingEnabled()) {
            return false;
        }
        if (this.getStackDepthLimit() != other.getStackDepthLimit()) {
            return false;
        }
        Duration this$samplingInterval = this.getSamplingInterval();
        Duration other$samplingInterval = other.getSamplingInterval();
        if (this$samplingInterval == null ? other$samplingInterval != null : !((Object)this$samplingInterval).equals(other$samplingInterval)) {
            return false;
        }
        Duration this$reportingInterval = this.getReportingInterval();
        Duration other$reportingInterval = other.getReportingInterval();
        if (this$reportingInterval == null ? other$reportingInterval != null : !((Object)this$reportingInterval).equals(other$reportingInterval)) {
            return false;
        }
        if (this.isAddProfilerOverheadAsSamples() != other.isAddProfilerOverheadAsSamples()) {
            return false;
        }
        Duration this$minimumTimeForReporting = this.getMinimumTimeForReporting();
        Duration other$minimumTimeForReporting = other.getMinimumTimeForReporting();
        if (this$minimumTimeForReporting == null ? other$minimumTimeForReporting != null : !((Object)this$minimumTimeForReporting).equals(other$minimumTimeForReporting)) {
            return false;
        }
        return this.getDontReportIfSampledLessThanTimes() == other.getDontReportIfSampledLessThanTimes();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $profilingGroupName = this.getProfilingGroupName();
        result = result * 59 + ($profilingGroupName == null ? 43 : $profilingGroupName.hashCode());
        ThreadSupport $threadSupport = this.getThreadSupport();
        result = result * 59 + ($threadSupport == null ? 43 : $threadSupport.hashCode());
        Set<String> $excludedThreads = this.getExcludedThreads();
        result = result * 59 + ($excludedThreads == null ? 43 : ((Object)$excludedThreads).hashCode());
        result = result * 59 + (this.isShouldProfile() ? 79 : 97);
        String $integrationMode = this.getIntegrationMode();
        result = result * 59 + ($integrationMode == null ? 43 : $integrationMode.hashCode());
        long $memoryUsageLimit = this.getMemoryUsageLimit();
        result = result * 59 + (int)($memoryUsageLimit >>> 32 ^ $memoryUsageLimit);
        result = result * 59 + (this.isHeapSummaryEnabled() ? 79 : 97);
        result = result * 59 + (this.isAllocationProfilingEnabled() ? 79 : 97);
        result = result * 59 + this.getStackDepthLimit();
        Duration $samplingInterval = this.getSamplingInterval();
        result = result * 59 + ($samplingInterval == null ? 43 : ((Object)$samplingInterval).hashCode());
        Duration $reportingInterval = this.getReportingInterval();
        result = result * 59 + ($reportingInterval == null ? 43 : ((Object)$reportingInterval).hashCode());
        result = result * 59 + (this.isAddProfilerOverheadAsSamples() ? 79 : 97);
        Duration $minimumTimeForReporting = this.getMinimumTimeForReporting();
        result = result * 59 + ($minimumTimeForReporting == null ? 43 : ((Object)$minimumTimeForReporting).hashCode());
        result = result * 59 + this.getDontReportIfSampledLessThanTimes();
        return result;
    }

    public static class OverrideProfilerParameters {
        private final Optional<Boolean> shouldProfile;
        private final Optional<Long> memoryUsageLimit;
        private final Optional<Integer> stackDepthLimit;
        private final Optional<Duration> samplingInterval;
        private final Optional<Duration> reportingInterval;
        private final Optional<Duration> minimumTimeForReporting;
        private final Optional<Integer> dontReportIfSampledLessThanTimes;

        public void overlay(ProfilerParametersBuilder builder) {
            this.shouldProfile.ifPresent(x -> builder.shouldProfile((boolean)x));
            this.memoryUsageLimit.ifPresent(x -> builder.memoryUsageLimit((long)x));
            this.stackDepthLimit.ifPresent(x -> builder.stackDepthLimit((int)x));
            this.samplingInterval.ifPresent(x -> builder.samplingIntervalBounded((Duration)x));
            this.reportingInterval.ifPresent(x -> builder.reportingIntervalBounded((Duration)x));
            this.minimumTimeForReporting.ifPresent(x -> builder.minimumTimeForReporting((Duration)x));
            this.dontReportIfSampledLessThanTimes.ifPresent(x -> builder.dontReportIfSampledLessThanTimes((int)x));
        }

        private static Optional<Boolean> $default$shouldProfile() {
            return Optional.empty();
        }

        private static Optional<Long> $default$memoryUsageLimit() {
            return Optional.empty();
        }

        private static Optional<Integer> $default$stackDepthLimit() {
            return Optional.empty();
        }

        private static Optional<Duration> $default$samplingInterval() {
            return Optional.empty();
        }

        private static Optional<Duration> $default$reportingInterval() {
            return Optional.empty();
        }

        private static Optional<Duration> $default$minimumTimeForReporting() {
            return Optional.empty();
        }

        private static Optional<Integer> $default$dontReportIfSampledLessThanTimes() {
            return Optional.empty();
        }

        @ConstructorProperties(value={"shouldProfile", "memoryUsageLimit", "stackDepthLimit", "samplingInterval", "reportingInterval", "minimumTimeForReporting", "dontReportIfSampledLessThanTimes"})
        OverrideProfilerParameters(Optional<Boolean> shouldProfile, Optional<Long> memoryUsageLimit, Optional<Integer> stackDepthLimit, Optional<Duration> samplingInterval, Optional<Duration> reportingInterval, Optional<Duration> minimumTimeForReporting, Optional<Integer> dontReportIfSampledLessThanTimes) {
            this.shouldProfile = shouldProfile;
            this.memoryUsageLimit = memoryUsageLimit;
            this.stackDepthLimit = stackDepthLimit;
            this.samplingInterval = samplingInterval;
            this.reportingInterval = reportingInterval;
            this.minimumTimeForReporting = minimumTimeForReporting;
            this.dontReportIfSampledLessThanTimes = dontReportIfSampledLessThanTimes;
        }

        public static OverrideProfilerParametersBuilder builder() {
            return new OverrideProfilerParametersBuilder();
        }

        public Optional<Boolean> getShouldProfile() {
            return this.shouldProfile;
        }

        public Optional<Long> getMemoryUsageLimit() {
            return this.memoryUsageLimit;
        }

        public Optional<Integer> getStackDepthLimit() {
            return this.stackDepthLimit;
        }

        public Optional<Duration> getSamplingInterval() {
            return this.samplingInterval;
        }

        public Optional<Duration> getReportingInterval() {
            return this.reportingInterval;
        }

        public Optional<Duration> getMinimumTimeForReporting() {
            return this.minimumTimeForReporting;
        }

        public Optional<Integer> getDontReportIfSampledLessThanTimes() {
            return this.dontReportIfSampledLessThanTimes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OverrideProfilerParameters)) {
                return false;
            }
            OverrideProfilerParameters other = (OverrideProfilerParameters)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<Boolean> this$shouldProfile = this.getShouldProfile();
            Optional<Boolean> other$shouldProfile = other.getShouldProfile();
            if (this$shouldProfile == null ? other$shouldProfile != null : !((Object)this$shouldProfile).equals(other$shouldProfile)) {
                return false;
            }
            Optional<Long> this$memoryUsageLimit = this.getMemoryUsageLimit();
            Optional<Long> other$memoryUsageLimit = other.getMemoryUsageLimit();
            if (this$memoryUsageLimit == null ? other$memoryUsageLimit != null : !((Object)this$memoryUsageLimit).equals(other$memoryUsageLimit)) {
                return false;
            }
            Optional<Integer> this$stackDepthLimit = this.getStackDepthLimit();
            Optional<Integer> other$stackDepthLimit = other.getStackDepthLimit();
            if (this$stackDepthLimit == null ? other$stackDepthLimit != null : !((Object)this$stackDepthLimit).equals(other$stackDepthLimit)) {
                return false;
            }
            Optional<Duration> this$samplingInterval = this.getSamplingInterval();
            Optional<Duration> other$samplingInterval = other.getSamplingInterval();
            if (this$samplingInterval == null ? other$samplingInterval != null : !((Object)this$samplingInterval).equals(other$samplingInterval)) {
                return false;
            }
            Optional<Duration> this$reportingInterval = this.getReportingInterval();
            Optional<Duration> other$reportingInterval = other.getReportingInterval();
            if (this$reportingInterval == null ? other$reportingInterval != null : !((Object)this$reportingInterval).equals(other$reportingInterval)) {
                return false;
            }
            Optional<Duration> this$minimumTimeForReporting = this.getMinimumTimeForReporting();
            Optional<Duration> other$minimumTimeForReporting = other.getMinimumTimeForReporting();
            if (this$minimumTimeForReporting == null ? other$minimumTimeForReporting != null : !((Object)this$minimumTimeForReporting).equals(other$minimumTimeForReporting)) {
                return false;
            }
            Optional<Integer> this$dontReportIfSampledLessThanTimes = this.getDontReportIfSampledLessThanTimes();
            Optional<Integer> other$dontReportIfSampledLessThanTimes = other.getDontReportIfSampledLessThanTimes();
            return !(this$dontReportIfSampledLessThanTimes == null ? other$dontReportIfSampledLessThanTimes != null : !((Object)this$dontReportIfSampledLessThanTimes).equals(other$dontReportIfSampledLessThanTimes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OverrideProfilerParameters;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<Boolean> $shouldProfile = this.getShouldProfile();
            result = result * 59 + ($shouldProfile == null ? 43 : ((Object)$shouldProfile).hashCode());
            Optional<Long> $memoryUsageLimit = this.getMemoryUsageLimit();
            result = result * 59 + ($memoryUsageLimit == null ? 43 : ((Object)$memoryUsageLimit).hashCode());
            Optional<Integer> $stackDepthLimit = this.getStackDepthLimit();
            result = result * 59 + ($stackDepthLimit == null ? 43 : ((Object)$stackDepthLimit).hashCode());
            Optional<Duration> $samplingInterval = this.getSamplingInterval();
            result = result * 59 + ($samplingInterval == null ? 43 : ((Object)$samplingInterval).hashCode());
            Optional<Duration> $reportingInterval = this.getReportingInterval();
            result = result * 59 + ($reportingInterval == null ? 43 : ((Object)$reportingInterval).hashCode());
            Optional<Duration> $minimumTimeForReporting = this.getMinimumTimeForReporting();
            result = result * 59 + ($minimumTimeForReporting == null ? 43 : ((Object)$minimumTimeForReporting).hashCode());
            Optional<Integer> $dontReportIfSampledLessThanTimes = this.getDontReportIfSampledLessThanTimes();
            result = result * 59 + ($dontReportIfSampledLessThanTimes == null ? 43 : ((Object)$dontReportIfSampledLessThanTimes).hashCode());
            return result;
        }

        public String toString() {
            return "ProfilerParameters.OverrideProfilerParameters(shouldProfile=" + this.getShouldProfile() + ", memoryUsageLimit=" + this.getMemoryUsageLimit() + ", stackDepthLimit=" + this.getStackDepthLimit() + ", samplingInterval=" + this.getSamplingInterval() + ", reportingInterval=" + this.getReportingInterval() + ", minimumTimeForReporting=" + this.getMinimumTimeForReporting() + ", dontReportIfSampledLessThanTimes=" + this.getDontReportIfSampledLessThanTimes() + ")";
        }

        public static class OverrideProfilerParametersBuilder {
            private boolean shouldProfile$set;
            private Optional<Boolean> shouldProfile;
            private boolean memoryUsageLimit$set;
            private Optional<Long> memoryUsageLimit;
            private boolean stackDepthLimit$set;
            private Optional<Integer> stackDepthLimit;
            private boolean samplingInterval$set;
            private Optional<Duration> samplingInterval;
            private boolean reportingInterval$set;
            private Optional<Duration> reportingInterval;
            private boolean minimumTimeForReporting$set;
            private Optional<Duration> minimumTimeForReporting;
            private boolean dontReportIfSampledLessThanTimes$set;
            private Optional<Integer> dontReportIfSampledLessThanTimes;

            OverrideProfilerParametersBuilder() {
            }

            public OverrideProfilerParametersBuilder shouldProfile(Optional<Boolean> shouldProfile) {
                this.shouldProfile = shouldProfile;
                this.shouldProfile$set = true;
                return this;
            }

            public OverrideProfilerParametersBuilder memoryUsageLimit(Optional<Long> memoryUsageLimit) {
                this.memoryUsageLimit = memoryUsageLimit;
                this.memoryUsageLimit$set = true;
                return this;
            }

            public OverrideProfilerParametersBuilder stackDepthLimit(Optional<Integer> stackDepthLimit) {
                this.stackDepthLimit = stackDepthLimit;
                this.stackDepthLimit$set = true;
                return this;
            }

            public OverrideProfilerParametersBuilder samplingInterval(Optional<Duration> samplingInterval) {
                this.samplingInterval = samplingInterval;
                this.samplingInterval$set = true;
                return this;
            }

            public OverrideProfilerParametersBuilder reportingInterval(Optional<Duration> reportingInterval) {
                this.reportingInterval = reportingInterval;
                this.reportingInterval$set = true;
                return this;
            }

            public OverrideProfilerParametersBuilder minimumTimeForReporting(Optional<Duration> minimumTimeForReporting) {
                this.minimumTimeForReporting = minimumTimeForReporting;
                this.minimumTimeForReporting$set = true;
                return this;
            }

            public OverrideProfilerParametersBuilder dontReportIfSampledLessThanTimes(Optional<Integer> dontReportIfSampledLessThanTimes) {
                this.dontReportIfSampledLessThanTimes = dontReportIfSampledLessThanTimes;
                this.dontReportIfSampledLessThanTimes$set = true;
                return this;
            }

            public OverrideProfilerParameters build() {
                return new OverrideProfilerParameters(this.shouldProfile$set ? this.shouldProfile : OverrideProfilerParameters.$default$shouldProfile(), this.memoryUsageLimit$set ? this.memoryUsageLimit : OverrideProfilerParameters.$default$memoryUsageLimit(), this.stackDepthLimit$set ? this.stackDepthLimit : OverrideProfilerParameters.$default$stackDepthLimit(), this.samplingInterval$set ? this.samplingInterval : OverrideProfilerParameters.$default$samplingInterval(), this.reportingInterval$set ? this.reportingInterval : OverrideProfilerParameters.$default$reportingInterval(), this.minimumTimeForReporting$set ? this.minimumTimeForReporting : OverrideProfilerParameters.$default$minimumTimeForReporting(), this.dontReportIfSampledLessThanTimes$set ? this.dontReportIfSampledLessThanTimes : OverrideProfilerParameters.$default$dontReportIfSampledLessThanTimes());
            }

            public String toString() {
                return "ProfilerParameters.OverrideProfilerParameters.OverrideProfilerParametersBuilder(shouldProfile=" + this.shouldProfile + ", memoryUsageLimit=" + this.memoryUsageLimit + ", stackDepthLimit=" + this.stackDepthLimit + ", samplingInterval=" + this.samplingInterval + ", reportingInterval=" + this.reportingInterval + ", minimumTimeForReporting=" + this.minimumTimeForReporting + ", dontReportIfSampledLessThanTimes=" + this.dontReportIfSampledLessThanTimes + ")";
            }
        }
    }

    public static class ProfilerParametersBuilder {
        private String profilingGroupName;
        private boolean threadSupport$set;
        private ThreadSupport threadSupport;
        private boolean excludedThreads$set;
        private Set<String> excludedThreads;
        private boolean shouldProfile$set;
        private boolean shouldProfile;
        private boolean integrationMode$set;
        private String integrationMode;
        private boolean memoryUsageLimit$set;
        private long memoryUsageLimit;
        private boolean heapSummaryEnabled$set;
        private boolean heapSummaryEnabled;
        private boolean allocationProfilingEnabled$set;
        private boolean allocationProfilingEnabled;
        private boolean stackDepthLimit$set;
        private int stackDepthLimit;
        private boolean samplingInterval$set;
        private Duration samplingInterval;
        private boolean reportingInterval$set;
        private Duration reportingInterval;
        private boolean addProfilerOverheadAsSamples$set;
        private boolean addProfilerOverheadAsSamples;
        private boolean minimumTimeForReporting$set;
        private Duration minimumTimeForReporting;
        private boolean dontReportIfSampledLessThanTimes$set;
        private int dontReportIfSampledLessThanTimes;

        public ProfilerParametersBuilder samplingIntervalBounded(Duration samplingInterval) {
            return this.samplingInterval(ProfilerParametersBuilder.boundDuration(samplingInterval));
        }

        public ProfilerParametersBuilder reportingIntervalBounded(Duration reportingInterval) {
            return this.reportingInterval(ProfilerParametersBuilder.boundDuration(reportingInterval));
        }

        private static Duration boundDuration(Duration input) {
            return input.toMillis() < 100L ? Duration.ofMillis(100L) : input;
        }

        public String getProfilingGroupName() {
            return this.profilingGroupName;
        }

        ProfilerParametersBuilder() {
        }

        public ProfilerParametersBuilder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public ProfilerParametersBuilder threadSupport(ThreadSupport threadSupport) {
            this.threadSupport = threadSupport;
            this.threadSupport$set = true;
            return this;
        }

        public ProfilerParametersBuilder excludedThreads(Set<String> excludedThreads) {
            this.excludedThreads = excludedThreads;
            this.excludedThreads$set = true;
            return this;
        }

        public ProfilerParametersBuilder shouldProfile(boolean shouldProfile) {
            this.shouldProfile = shouldProfile;
            this.shouldProfile$set = true;
            return this;
        }

        public ProfilerParametersBuilder integrationMode(String integrationMode) {
            this.integrationMode = integrationMode;
            this.integrationMode$set = true;
            return this;
        }

        public ProfilerParametersBuilder memoryUsageLimit(long memoryUsageLimit) {
            this.memoryUsageLimit = memoryUsageLimit;
            this.memoryUsageLimit$set = true;
            return this;
        }

        public ProfilerParametersBuilder heapSummaryEnabled(boolean heapSummaryEnabled) {
            this.heapSummaryEnabled = heapSummaryEnabled;
            this.heapSummaryEnabled$set = true;
            return this;
        }

        public ProfilerParametersBuilder allocationProfilingEnabled(boolean allocationProfilingEnabled) {
            this.allocationProfilingEnabled = allocationProfilingEnabled;
            this.allocationProfilingEnabled$set = true;
            return this;
        }

        public ProfilerParametersBuilder stackDepthLimit(int stackDepthLimit) {
            this.stackDepthLimit = stackDepthLimit;
            this.stackDepthLimit$set = true;
            return this;
        }

        public ProfilerParametersBuilder samplingInterval(Duration samplingInterval) {
            this.samplingInterval = samplingInterval;
            this.samplingInterval$set = true;
            return this;
        }

        public ProfilerParametersBuilder reportingInterval(Duration reportingInterval) {
            this.reportingInterval = reportingInterval;
            this.reportingInterval$set = true;
            return this;
        }

        public ProfilerParametersBuilder addProfilerOverheadAsSamples(boolean addProfilerOverheadAsSamples) {
            this.addProfilerOverheadAsSamples = addProfilerOverheadAsSamples;
            this.addProfilerOverheadAsSamples$set = true;
            return this;
        }

        public ProfilerParametersBuilder minimumTimeForReporting(Duration minimumTimeForReporting) {
            this.minimumTimeForReporting = minimumTimeForReporting;
            this.minimumTimeForReporting$set = true;
            return this;
        }

        public ProfilerParametersBuilder dontReportIfSampledLessThanTimes(int dontReportIfSampledLessThanTimes) {
            this.dontReportIfSampledLessThanTimes = dontReportIfSampledLessThanTimes;
            this.dontReportIfSampledLessThanTimes$set = true;
            return this;
        }

        public ProfilerParameters build() {
            return new ProfilerParameters(this.profilingGroupName, this.threadSupport$set ? this.threadSupport : ProfilerParameters.$default$threadSupport(), this.excludedThreads$set ? this.excludedThreads : ProfilerParameters.$default$excludedThreads(), this.shouldProfile$set ? this.shouldProfile : ProfilerParameters.$default$shouldProfile(), this.integrationMode$set ? this.integrationMode : ProfilerParameters.$default$integrationMode(), this.memoryUsageLimit$set ? this.memoryUsageLimit : ProfilerParameters.$default$memoryUsageLimit(), this.heapSummaryEnabled$set ? this.heapSummaryEnabled : ProfilerParameters.$default$heapSummaryEnabled(), this.allocationProfilingEnabled$set ? this.allocationProfilingEnabled : ProfilerParameters.$default$allocationProfilingEnabled(), this.stackDepthLimit$set ? this.stackDepthLimit : ProfilerParameters.$default$stackDepthLimit(), this.samplingInterval$set ? this.samplingInterval : ProfilerParameters.$default$samplingInterval(), this.reportingInterval$set ? this.reportingInterval : ProfilerParameters.$default$reportingInterval(), this.addProfilerOverheadAsSamples$set ? this.addProfilerOverheadAsSamples : ProfilerParameters.$default$addProfilerOverheadAsSamples(), this.minimumTimeForReporting$set ? this.minimumTimeForReporting : ProfilerParameters.$default$minimumTimeForReporting(), this.dontReportIfSampledLessThanTimes$set ? this.dontReportIfSampledLessThanTimes : ProfilerParameters.$default$dontReportIfSampledLessThanTimes());
        }

        public String toString() {
            return "ProfilerParameters.ProfilerParametersBuilder(profilingGroupName=" + this.profilingGroupName + ", threadSupport=" + this.threadSupport + ", excludedThreads=" + this.excludedThreads + ", shouldProfile=" + this.shouldProfile + ", integrationMode=" + this.integrationMode + ", memoryUsageLimit=" + this.memoryUsageLimit + ", heapSummaryEnabled=" + this.heapSummaryEnabled + ", allocationProfilingEnabled=" + this.allocationProfilingEnabled + ", stackDepthLimit=" + this.stackDepthLimit + ", samplingInterval=" + this.samplingInterval + ", reportingInterval=" + this.reportingInterval + ", addProfilerOverheadAsSamples=" + this.addProfilerOverheadAsSamples + ", minimumTimeForReporting=" + this.minimumTimeForReporting + ", dontReportIfSampledLessThanTimes=" + this.dontReportIfSampledLessThanTimes + ")";
        }
    }
}

