/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.SymbolTable;
import com.amazon.ion.SymbolToken;
import com.amazon.ion.UnknownSymbolException;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import com.amazon.ion.system.IonSystemBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.codeguruprofilerjavaagent.profile.CallGraph;
import software.amazon.codeguruprofilerjavaagent.profile.ClassSummary;
import software.amazon.codeguruprofilerjavaagent.profile.FrameEncodings;
import software.amazon.codeguruprofilerjavaagent.profile.HeapSettings;
import software.amazon.codeguruprofilerjavaagent.profile.HeapSnapshot;
import software.amazon.codeguruprofilerjavaagent.profile.HeapSummary;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;
import software.amazon.codeguruprofilerjavaagent.profile.Profile;
import software.amazon.codeguruprofilerjavaagent.profile.StateEncodings;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadataIonWriter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 !2\u00020\u0001:\u0003 !\"B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0019H\u0002JQ\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002\u00a2\u0006\u0002\u0010\u001fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer;", "", "()V", "system", "Lcom/amazon/ion/IonSystem;", "kotlin.jvm.PlatformType", "encodeSymbols", "", "Lcom/amazon/ion/SymbolToken;", "encodings", "", "", "", "symbolTable", "Lcom/amazon/ion/SymbolTable;", "(Ljava/util/Map;Lcom/amazon/ion/SymbolTable;)[Lcom/amazon/ion/SymbolToken;", "serialize", "", "profile", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/Profile;", "out", "Ljava/io/OutputStream;", "writeHeapSummary", "heapSummary", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/HeapSummary;", "Lcom/amazon/ion/IonWriter;", "writeProfile", "countsSymbol", "childrensToken", "stateMapping", "frameMapping", "(Lsoftware/amazon/codeguruprofilerjavaagent/profile/Profile;Lcom/amazon/ion/IonWriter;Lcom/amazon/ion/SymbolToken;Lcom/amazon/ion/SymbolToken;[Lcom/amazon/ion/SymbolToken;Ljava/util/Map;)V", "CallGraphSerializer", "Companion", "SymbolTokenWithoutText", "SkySailJavaAgent"})
public class ProfileIonSerializer {
    private final IonSystem system = IonSystemBuilder.standard().build();
    @JvmField
    @NotNull
    public static final BigDecimal CURRENT_SCHEMA_VERSION;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(@NotNull Profile profile, @NotNull OutputStream out) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        SymbolTable symbolTable = this.system.newLocalSymbolTable(new SymbolTable[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)symbolTable, (String)"system.newLocalSymbolTable()");
        SymbolTable symbols = symbolTable;
        SymbolToken symbolToken = symbols.intern("counts");
        Intrinsics.checkExpressionValueIsNotNull((Object)symbolToken, (String)"symbols.intern(ProfileIonKeys.COUNTS)");
        SymbolToken countsSymbol = symbolToken;
        SymbolToken symbolToken2 = symbols.intern("children");
        Intrinsics.checkExpressionValueIsNotNull((Object)symbolToken2, (String)"symbols.intern(ProfileIonKeys.CHILDREN)");
        SymbolToken childrensToken = symbolToken2;
        Map<Integer, String> map = StateEncodings.getEncodings();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"StateEncodings.getEncodings()");
        SymbolToken[] stateMapping = this.encodeSymbols(map, symbols);
        IonWriter ionWriter = IonBinaryWriterBuilder.standard().withInitialSymbolTable(symbols).build(out);
        Intrinsics.checkExpressionValueIsNotNull((Object)ionWriter, (String)"IonBinaryWriterBuilder.s\u2026Table(symbols).build(out)");
        IonWriter writer = ionWriter;
        Closeable closeable = (Closeable)writer;
        boolean bl = false;
        Throwable throwable = null;
        try {
            IonWriter it = (IonWriter)closeable;
            boolean bl2 = false;
            FrameEncodings frameEncodings = profile.getFrameEncodings();
            Intrinsics.checkExpressionValueIsNotNull((Object)frameEncodings, (String)"profile.frameEncodings");
            Map<Integer, String> map2 = frameEncodings.getEncodings();
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"profile.frameEncodings.encodings");
            this.writeProfile(profile, it, countsSymbol, childrensToken, stateMapping, map2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SymbolToken[] encodeSymbols(Map<Integer, String> encodings, SymbolTable symbolTable) {
        SymbolToken[] remapping = new SymbolToken[encodings.size()];
        int n = 0;
        int n2 = encodings.size();
        while (n < n2) {
            void i;
            SymbolToken symbolToken = symbolTable.intern(encodings.get((int)i));
            Intrinsics.checkExpressionValueIsNotNull((Object)symbolToken, (String)"symbolTable.intern(encodings[i])");
            remapping[i] = new SymbolTokenWithoutText(symbolToken.getSid());
            ++i;
        }
        return remapping;
    }

    private final void writeProfile(Profile profile, IonWriter out, SymbolToken countsSymbol, SymbolToken childrensToken, SymbolToken[] stateMapping, Map<Integer, String> frameMapping) {
        IonUtils ionUtils = IonUtils.INSTANCE;
        boolean $i$f$writeStruct = false;
        out.stepIn(IonType.STRUCT);
        boolean bl = false;
        IonUtils.writeDecimal(out, "schemaVersion", CURRENT_SCHEMA_VERSION);
        IonUtils.writeTimestamp(out, "start", profile.getStart());
        IonUtils.writeTimestamp(out, "end", profile.getEnd());
        out.setFieldName("callgraph");
        CallGraph callGraph = profile.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)callGraph, (String)"profile.root");
        CallGraphSerializer.INSTANCE.write(out, callGraph, countsSymbol, childrensToken, stateMapping, frameMapping);
        out.setFieldName("heapSummary");
        HeapSummary heapSummary = profile.getHeapSummary();
        Intrinsics.checkExpressionValueIsNotNull((Object)heapSummary, (String)"profile.heapSummary");
        this.writeHeapSummary(heapSummary, out);
        out.setFieldName("agentMetadata");
        AgentMetadataIonWriter.write(out, profile.getAgentMetadata(), profile.getSamplingMetadata());
        profile.getAgentDebugInfo().write(out, "debugInfo");
        out.stepOut();
    }

    /*
     * WARNING - void declaration
     */
    private final void writeHeapSummary(HeapSummary heapSummary, IonWriter out) {
        void out$iv;
        HeapSnapshot latestSnapshot = heapSummary.getLatestSnapshot();
        IonUtils ionUtils = IonUtils.INSTANCE;
        boolean $i$f$writeStruct = false;
        out.stepIn(IonType.STRUCT);
        boolean bl = false;
        IonWriter ionWriter = out;
        String fieldName$iv = "snapshots";
        boolean $i$f$writeList = false;
        out$iv.setFieldName(fieldName$iv);
        boolean $i$f$writeList2 = false;
        out$iv.stepIn(IonType.LIST);
        boolean bl2 = false;
        if (latestSnapshot != null) {
            IonWriter out$iv2;
            IonUtils ionUtils2 = IonUtils.INSTANCE;
            IonWriter out$iv3 = out;
            boolean $i$f$writeStruct2 = false;
            out$iv3.stepIn(IonType.STRUCT);
            boolean bl3 = false;
            IonUtils.writeTimestamp(out, "captureTime", latestSnapshot.getCaptureTimestamp());
            IonUtils.writeInt(out, "uptimeMillis", latestSnapshot.getUptimeMillis());
            Long l = latestSnapshot.getHeapUsedBytes();
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"latestSnapshot.heapUsedBytes");
            IonUtils.writeInt(out, "heapUsedBytes", l);
            IonUtils ionUtils3 = IonUtils.INSTANCE;
            IonWriter ionWriter2 = out;
            String fieldName$iv2 = "settings";
            boolean $i$f$writeStruct3 = false;
            out$iv2.setFieldName(fieldName$iv2);
            IonUtils this_$iv$iv = ionUtils3;
            boolean $i$f$writeStruct4 = false;
            out$iv2.stepIn(IonType.STRUCT);
            boolean bl4 = false;
            HeapSettings heapSettings = latestSnapshot.getSettings();
            Intrinsics.checkExpressionValueIsNotNull((Object)heapSettings, (String)"latestSnapshot.settings");
            Long l2 = heapSettings.getMaxHeapSizeBytes();
            Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"latestSnapshot.settings.maxHeapSizeBytes");
            IonUtils.writeInt(out, "maxHeapSizeBytes", l2);
            out$iv2.stepOut();
            ionUtils3 = IonUtils.INSTANCE;
            out$iv2 = out;
            fieldName$iv2 = "classSummaries";
            $i$f$writeStruct3 = false;
            out$iv2.setFieldName(fieldName$iv2);
            this_$iv$iv = ionUtils3;
            $i$f$writeStruct4 = false;
            out$iv2.stepIn(IonType.STRUCT);
            boolean bl5 = false;
            for (ClassSummary classSummary : latestSnapshot.getClassSummaries()) {
                void out$iv4;
                IonUtils ionUtils4 = IonUtils.INSTANCE;
                IonWriter ionWriter3 = out;
                ClassSummary classSummary2 = classSummary;
                Intrinsics.checkExpressionValueIsNotNull((Object)classSummary2, (String)"classSummary");
                String fieldName$iv3 = classSummary2.getObjectType();
                boolean $i$f$writeStruct5 = false;
                out$iv4.setFieldName(fieldName$iv3);
                IonUtils this_$iv$iv2 = ionUtils4;
                boolean $i$f$writeStruct6 = false;
                out$iv4.stepIn(IonType.STRUCT);
                boolean bl6 = false;
                IonUtils.writeInt(out, "sizeBytes", classSummary.getObjectSizeBytes());
                IonUtils.writeInt(out, "count", classSummary.getObjectCount());
                out$iv4.stepOut();
            }
            out$iv2.stepOut();
            out$iv3.stepOut();
        }
        out$iv.stepOut();
        out.stepOut();
    }

    static {
        Companion = new Companion(null);
        BigDecimal bigDecimal = BigDecimal.valueOf(1.0);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"BigDecimal.valueOf(1.0)");
        CURRENT_SCHEMA_VERSION = bigDecimal;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$SymbolTokenWithoutText;", "Lcom/amazon/ion/SymbolToken;", "sid", "", "(I)V", "assumeText", "", "getSid", "getText", "SkySailJavaAgent"})
    private static final class SymbolTokenWithoutText
    implements SymbolToken {
        private final int sid;

        @Nullable
        public Void getText() {
            return null;
        }

        @NotNull
        public Void assumeText() {
            throw (Throwable)new UnknownSymbolException(this.sid);
        }

        public int getSid() {
            return this.sid;
        }

        public SymbolTokenWithoutText(int sid) {
            this.sid = sid;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JO\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0002\u0010\u0012J5\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\rH\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer;", "", "()V", "write", "", "out", "Lcom/amazon/ion/IonWriter;", "root", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/CallGraph;", "countsSymbol", "Lcom/amazon/ion/SymbolToken;", "childrensToken", "stateMapping", "", "frameMapping", "", "", "", "(Lcom/amazon/ion/IonWriter;Lsoftware/amazon/codeguruprofilerjavaagent/profile/CallGraph;Lcom/amazon/ion/SymbolToken;Lcom/amazon/ion/SymbolToken;[Lcom/amazon/ion/SymbolToken;Ljava/util/Map;)V", "writeCounts", "counts", "", "(Lcom/amazon/ion/IonWriter;[JLcom/amazon/ion/SymbolToken;[Lcom/amazon/ion/SymbolToken;)V", "Operation", "SkySailJavaAgent"})
    private static final class CallGraphSerializer {
        public static final CallGraphSerializer INSTANCE;

        /*
         * WARNING - void declaration
         */
        public final void write(@NotNull IonWriter out, @NotNull CallGraph root, @NotNull SymbolToken countsSymbol, @NotNull SymbolToken childrensToken, @NotNull SymbolToken[] stateMapping, @NotNull Map<Integer, String> frameMapping) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            Intrinsics.checkParameterIsNotNull((Object)countsSymbol, (String)"countsSymbol");
            Intrinsics.checkParameterIsNotNull((Object)childrensToken, (String)"childrensToken");
            Intrinsics.checkParameterIsNotNull((Object)stateMapping, (String)"stateMapping");
            Intrinsics.checkParameterIsNotNull(frameMapping, (String)"frameMapping");
            ArrayDeque<Operation> operations = new ArrayDeque<Operation>();
            operations.addFirst(new Operation.StartNode(root, true));
            operations.addLast(Operation.CloseNode.INSTANCE);
            while (true) {
                Collection collection = operations;
                boolean bl = false;
                if (!(!collection.isEmpty())) break;
                Operation current = (Operation)operations.removeFirst();
                if (current instanceof Operation.StartNode) {
                    CallGraph[] callGraphArray;
                    CallGraph node = ((Operation.StartNode)current).getNode();
                    if (!((Operation.StartNode)current).isRoot()) {
                        out.setFieldName(frameMapping.get(node.getFrame()));
                    }
                    out.stepIn(IonType.STRUCT);
                    long[] lArray = node.getCounts();
                    Intrinsics.checkExpressionValueIsNotNull((Object)lArray, (String)"node.counts");
                    this.writeCounts(out, lArray, countsSymbol, stateMapping);
                    Intrinsics.checkExpressionValueIsNotNull((Object)node.getChildren(), (String)"node.children");
                    boolean bl2 = false;
                    CallGraph[] callGraphArray2 = callGraphArray;
                    boolean bl3 = false;
                    if (!(!(callGraphArray2.length == 0))) continue;
                    operations.addFirst(Operation.CloseChildren.INSTANCE);
                    Object[] objectArray = node.getChildren();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"node.children");
                    int n = ArraysKt.getLastIndex((Object[])objectArray);
                    bl2 = false;
                    while (n >= 0) {
                        void i;
                        CallGraph child = node.getChildren()[i];
                        if (child.hasCounts()) {
                            operations.addFirst(Operation.CloseNode.INSTANCE);
                            CallGraph callGraph = child;
                            Intrinsics.checkExpressionValueIsNotNull((Object)callGraph, (String)"child");
                            operations.addFirst(new Operation.StartNode(callGraph, false, 2, null));
                        }
                        --i;
                    }
                    operations.addFirst(Operation.StartChildren.INSTANCE);
                    continue;
                }
                if (current instanceof Operation.StartChildren) {
                    out.setFieldNameSymbol(childrensToken);
                    out.stepIn(IonType.STRUCT);
                    continue;
                }
                if (current instanceof Operation.CloseChildren) {
                    out.stepOut();
                    continue;
                }
                if (!(current instanceof Operation.CloseNode)) continue;
                out.stepOut();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void writeCounts(IonWriter out, long[] counts, SymbolToken countsSymbol, SymbolToken[] stateMapping) {
            Object object = counts;
            boolean bl = false;
            if (((long[])object).length == 0) {
                return;
            }
            out.setFieldNameSymbol(countsSymbol);
            object = IonUtils.INSTANCE;
            boolean $i$f$writeStruct = false;
            out.stepIn(IonType.STRUCT);
            boolean bl2 = false;
            int n = 0;
            int n2 = counts.length;
            while (n < n2) {
                void i;
                if (counts[i] > 0L) {
                    out.setFieldNameSymbol(stateMapping[i]);
                    out.writeInt(counts[i]);
                }
                ++i;
            }
            out.stepOut();
        }

        private CallGraphSerializer() {
        }

        static {
            CallGraphSerializer callGraphSerializer;
            INSTANCE = callGraphSerializer = new CallGraphSerializer();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation;", "", "()V", "CloseChildren", "CloseNode", "StartChildren", "StartNode", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$StartNode;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$StartChildren;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$CloseChildren;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$CloseNode;", "SkySailJavaAgent"})
        public static abstract class Operation {
            private Operation() {
            }

            public /* synthetic */ Operation(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$StartNode;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation;", "node", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/CallGraph;", "isRoot", "", "(Lsoftware/amazon/codeguruprofilerjavaagent/profile/CallGraph;Z)V", "()Z", "getNode", "()Lsoftware/amazon/codeguruprofilerjavaagent/profile/CallGraph;", "SkySailJavaAgent"})
            public static final class StartNode
            extends Operation {
                @NotNull
                private final CallGraph node;
                private final boolean isRoot;

                @NotNull
                public final CallGraph getNode() {
                    return this.node;
                }

                public final boolean isRoot() {
                    return this.isRoot;
                }

                public StartNode(@NotNull CallGraph node, boolean isRoot) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    super(null);
                    this.node = node;
                    this.isRoot = isRoot;
                }

                public /* synthetic */ StartNode(CallGraph callGraph, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 2) != 0) {
                        bl = false;
                    }
                    this(callGraph, bl);
                }
            }

            @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$StartChildren;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation;", "()V", "SkySailJavaAgent"})
            public static final class StartChildren
            extends Operation {
                public static final StartChildren INSTANCE;

                private StartChildren() {
                    super(null);
                }

                static {
                    StartChildren startChildren;
                    INSTANCE = startChildren = new StartChildren();
                }
            }

            @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$CloseChildren;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation;", "()V", "SkySailJavaAgent"})
            public static final class CloseChildren
            extends Operation {
                public static final CloseChildren INSTANCE;

                private CloseChildren() {
                    super(null);
                }

                static {
                    CloseChildren closeChildren;
                    INSTANCE = closeChildren = new CloseChildren();
                }
            }

            @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation$CloseNode;", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$CallGraphSerializer$Operation;", "()V", "SkySailJavaAgent"})
            public static final class CloseNode
            extends Operation {
                public static final CloseNode INSTANCE;

                private CloseNode() {
                    super(null);
                }

                static {
                    CloseNode closeNode;
                    INSTANCE = closeNode = new CloseNode();
                }
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileIonSerializer$Companion;", "", "()V", "CURRENT_SCHEMA_VERSION", "Ljava/math/BigDecimal;", "SkySailJavaAgent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

