/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.services.codeguruprofiler.model.AgentConfiguration;
import software.amazon.awssdk.services.codeguruprofiler.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codeguruprofiler.model.ValidationException;
import software.amazon.codeguruprofilerjavaagent.Counter;
import software.amazon.codeguruprofilerjavaagent.CpuTimeMonitor;
import software.amazon.codeguruprofilerjavaagent.GarbageCollectorMonitor;
import software.amazon.codeguruprofilerjavaagent.MemoryProfilerParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilerFinalParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilerParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilingCommandExecutor;
import software.amazon.codeguruprofilerjavaagent.ProfilingCommandUtils;
import software.amazon.codeguruprofilerjavaagent.ThreadDump;
import software.amazon.codeguruprofilerjavaagent.ThreadDumpCollection;
import software.amazon.codeguruprofilerjavaagent.Timer;
import software.amazon.codeguruprofilerjavaagent.configuration.ProfilerParametersMerger;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.MemoryProfiler;
import software.amazon.codeguruprofilerjavaagent.profile.AgentDebugInfo;
import software.amazon.codeguruprofilerjavaagent.profile.Profile;
import software.amazon.codeguruprofilerjavaagent.profile.ProfileBuilder;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInfo;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInstanceType;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.SamplingMetadata;

class ProfilingCommand
extends ProfilingCommandExecutor {
    static final String PROFILING_OVERHEAD_CLASS_NAME = "software.amazon.codeguruprofilerjavaagent.ProfilingCommand";
    static final String PROFILING_OVERHEAD_METHOD_NAME = "run";
    private static final Logger LOG = Logger.getLogger(ProfilingCommand.class.getName());
    private static final Duration MINIMUM_TIME_FOR_MEMORY_REFRESH = Duration.ofMinutes(5L);
    private volatile boolean forceFlush;
    private Instant reportStartedAt;
    private Instant reportToEndAt;
    private Instant lastSampleTime;
    private Instant lastMemoryRefreshTime;
    private final GarbageCollectorMonitor gcMonitor;
    private final CpuTimeMonitor cpuTimeMonitor;
    private Counter numThreadsSeen;
    private Counter numThreadsSampled;
    private long processingNanos;
    private long numberOfTimesSampled;
    private boolean memoryUsageLimitExceeded;
    private final Instant agentStartTime;
    private final ProfileBuilder profileBuilder;
    private final ProfilerParametersMerger parametersMerger;
    private ProfilerParameters parameters;
    protected final ProfilerFinalParameters profilerFinalParameters;
    private final int sampleWeight;
    private boolean refreshingAgentConfiguration = false;
    private boolean reportingProfile = false;

    ProfilingCommand(ProfilerParametersMerger parametersMerger, ProfilerParameters parameters, ProfilerFinalParameters profilerFinalParameters) {
        super(new MemoryProfilerParameters(parameters.isHeapSummaryEnabled(), parameters.isAllocationProfilingEnabled()));
        Instant now = Instant.now();
        this.forceFlush = false;
        this.lastMemoryRefreshTime = now;
        this.gcMonitor = new GarbageCollectorMonitor(profilerFinalParameters.getErrorsMetadata());
        this.cpuTimeMonitor = new CpuTimeMonitor();
        this.numThreadsSeen = new Counter();
        this.numThreadsSampled = new Counter();
        this.parametersMerger = parametersMerger;
        this.parameters = parameters;
        this.profilerFinalParameters = profilerFinalParameters;
        this.sampleWeight = 1;
        this.agentStartTime = now;
        this.profileBuilder = new ProfileBuilder(parameters.getStackDepthLimit());
        if (parameters.isHeapSummaryEnabled()) {
            MemoryProfiler.Companion.checkIfGcIsSupported(this.gcMonitor.getAllKnownLabels());
        }
    }

    protected ErrorsMetadata getErrorsMetadata() {
        return this.profilerFinalParameters.getErrorsMetadata();
    }

    @Override
    public boolean isProfiling() {
        return this.reportStartedAt != null;
    }

    @Override
    public boolean isProfileReportingInProgress() {
        return this.reportingProfile;
    }

    @Override
    public boolean isAgentConfigurationRefreshInProgress() {
        return this.refreshingAgentConfiguration;
    }

    @Override
    public void startSampling() {
        try {
            if (this.killSwitch.isKillSwitchOn(this.numberOfTimesSampled == 0L) || this.numberOfTimesSampled == 0L && this.isFleetTypeIncorrect()) {
                this.asyncStopProfiling();
            }
            if (this.isTerminated) {
                return;
            }
            if (!this.isProfiling()) {
                this.refreshConfiguration();
                return;
            }
            this.overheadTimer.time(() -> this.flush(false), Timer.ProfilingTimes.flush);
            this.sample();
            if (this.memoryUsageLimitExceeded) {
                if (Instant.now().isAfter(this.lastMemoryRefreshTime.plus(MINIMUM_TIME_FOR_MEMORY_REFRESH))) {
                    LOG.info("Memory usage limit of " + this.parameters.getMemoryUsageLimit() + " B was exceeded. Attempting to flush and clear the memory before continuing to profile.");
                    this.memoryUsageLimitExceeded = false;
                    this.overheadTimer.time(() -> this.flush(true), Timer.ProfilingTimes.flush);
                } else {
                    LOG.info("Disabling profiler as it exceeded the configured memory usage limit of " + this.parameters.getMemoryUsageLimit() + " B within " + MINIMUM_TIME_FOR_MEMORY_REFRESH.toMinutes() + " mins. Please increase the memoryUsageLimit or contact profiler-dev@amazon.com if you think this is in error.");
                    this.stopProfiling();
                }
            }
        }
        catch (Throwable t) {
            LOG.log(Level.INFO, "An unexpected issue caused the profiling command to terminate", t);
            throw t;
        }
    }

    protected Optional<AgentConfiguration> callConfigureAgent() {
        Optional<AgentConfiguration> newAgentConfig = this.profilerFinalParameters.getAgentOrchestrator().configureAgent();
        if (newAgentConfig.isPresent()) {
            return newAgentConfig;
        }
        this.notifyFailedAgentConfig();
        return Optional.empty();
    }

    protected ProfilerParameters buildProfilerParameters(AgentConfiguration agentConfiguration) {
        return this.parametersMerger.buildProfilerParameters(agentConfiguration);
    }

    private void refreshConfiguration() {
        try {
            this.refreshingAgentConfiguration = true;
            Optional<AgentConfiguration> newAgentConfig = this.callConfigureAgent();
            if (newAgentConfig.isPresent()) {
                LOG.info(String.format("New agent configuration received : %s", newAgentConfig.get().toString()));
                this.parameters = this.buildProfilerParameters(newAgentConfig.get());
            }
        }
        catch (ValidationException e) {
            this.isTerminated = true;
            throw e;
        }
        finally {
            this.refreshingAgentConfiguration = false;
        }
        if (this.parameters.isShouldProfile()) {
            this.startNewProfile(this.parameters.getReportingInterval());
            this.scheduleTaskInExecutor(Duration.ZERO, this.parameters.getSamplingInterval());
        } else {
            this.scheduleTaskInExecutor(this.parameters.getReportingInterval(), this.parameters.getSamplingInterval());
        }
    }

    void notifyFailedAgentConfig() {
        LOG.log(Level.INFO, "Could not get new configuration. Using the previous one: ", this.parameters);
    }

    private void startNewProfile(Duration period) {
        Instant now;
        this.reportStartedAt = now = Instant.now();
        this.reportToEndAt = now.plus(period);
        this.memoryProfiler.startRecording();
        this.gcMonitor.pollAndReportDiff();
        this.cpuTimeMonitor.start();
        this.OnNewProfileStart(now);
    }

    protected void OnNewProfileStart(Instant now) {
    }

    private void sample() {
        this.lastSampleTime = Instant.now();
        ThreadDumpCollection threadDumpCollection = this.overheadTimer.time(() -> this.parameters.getThreadSupport().dumpAllStackTraces(this.parameters.getStackDepthLimit()), Timer.ProfilingTimes.dumpAllStackTraces);
        this.overheadTimer.time(() -> this.aggregateThreadDumps(threadDumpCollection), Timer.ProfilingTimes.aggregateThreadDumps);
        this.processingNanos += Duration.between(this.lastSampleTime, Instant.now()).toNanos();
        ++this.numberOfTimesSampled;
        int numThreadsSeenInThreadDump = threadDumpCollection.getNumThreadsSeen();
        int numThreadsSampledInThreadDump = threadDumpCollection.getNumThreadsSampled();
        this.numThreadsSeen.count(numThreadsSeenInThreadDump);
        this.numThreadsSampled.count(numThreadsSampledInThreadDump);
    }

    private void aggregateThreadDumps(ThreadDumpCollection threadDumpCollection) {
        long currentThreadId = Thread.currentThread().getId();
        for (ThreadDump threadDump : threadDumpCollection.getThreadDumps()) {
            if (this.parameters.getExcludedThreads().contains(threadDump.getThreadName()) || currentThreadId == threadDump.getThreadId()) continue;
            this.profileBuilder.getCallGraphBuilder().capture(threadDump.getState(), threadDump.isInNative(), threadDump.getStackTrace());
            if (this.profileBuilder.getCallGraphBuilder().getSizeInMemory() <= this.parameters.getMemoryUsageLimit()) continue;
            this.memoryUsageLimitExceeded = true;
            break;
        }
    }

    private void captureGarbageCollectionAsStackTrace(double threadWeight) {
        List<GarbageCollectorMonitor.GCTimeSpent> gcTimeSpentList = this.gcMonitor.pollAndReportDiff();
        for (GarbageCollectorMonitor.GCTimeSpent gcTimeSpent : gcTimeSpentList) {
            int samples = ProfilingCommandUtils.convertGCTimeToSamples(gcTimeSpent, this.numberOfTimesSampled, threadWeight);
            this.profileBuilder.getCallGraphBuilder().capture(Thread.State.RUNNABLE, samples, new StackTraceElement(gcTimeSpent.getLabel(), "gc", "", 0), new StackTraceElement("GarbageCollector", "gc", "", 0));
        }
    }

    private void captureProfilerProcessingAsStackTrace(double threadWeight) {
        int profilerSamples = ProfilingCommandUtils.convertProfilingTimeToSamples(this.processingNanos, this.sampleWeight, this.parameters.getSamplingInterval().toMillis(), threadWeight);
        this.profileBuilder.getCallGraphBuilder().capture(Thread.State.RUNNABLE, profilerSamples, new StackTraceElement(PROFILING_OVERHEAD_CLASS_NAME, PROFILING_OVERHEAD_METHOD_NAME, "", 0));
    }

    @Override
    void flush(boolean memoryRefresh) {
        boolean force;
        Instant now = Instant.now();
        Instant reportProfileEndTime = this.lastSampleTime != null ? this.lastSampleTime : now;
        boolean bl = force = this.forceFlush || memoryRefresh;
        if (this.isTimeToReport(now, force)) {
            if (this.haveSampledEnoughForReporting()) {
                this.reportProfile(memoryRefresh, reportProfileEndTime, force);
            } else {
                LOG.info("Dropping the profile as we did not sample enough: " + this.numberOfTimesSampled + ", minimum is " + this.parameters.getDontReportIfSampledLessThanTimes());
                this.clearProfilingData(now, memoryRefresh);
            }
        } else if (memoryRefresh) {
            LOG.info("Dropping the profile as it could not be reported");
            this.clearProfilingData(now, true);
        }
        if (this.forceFlush) {
            this.forceFlush = false;
        }
    }

    private boolean isTimeToReport(Instant now, boolean force) {
        if (!this.isProfiling()) {
            return false;
        }
        return force && Duration.between(this.reportStartedAt, now).compareTo(this.parameters.getMinimumTimeForReporting()) > 0 || this.reportToEndAt.isBefore(now);
    }

    private boolean haveSampledEnoughForReporting() {
        return this.numberOfTimesSampled >= (long)this.parameters.getDontReportIfSampledLessThanTimes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportProfile(boolean memoryRefresh, Instant now, boolean force) {
        try {
            this.reportingProfile = true;
            LOG.info("Attempting to report profile data: start=" + this.reportStartedAt + " end=" + now + " force=" + force + " memoryRefresh=" + memoryRefresh + " numberOfTimesSampled=" + this.numberOfTimesSampled);
            if (this.parameters.isAddProfilerOverheadAsSamples()) {
                this.addProfilerOverheadAsSamplesInReport();
            }
            this.overheadTimer.time(() -> this.memoryProfiler.flush(this.profileBuilder), Timer.ProfilingTimes.flushMemoryProfiler);
            this.overheadTimer.time(() -> this.submitProfilingData(now, memoryRefresh), Timer.ProfilingTimes.submitProfilingData);
        }
        finally {
            this.reportingProfile = false;
        }
    }

    private void addProfilerOverheadAsSamplesInReport() {
        double threadWeight = (double)this.numThreadsSeen.getSum() / (double)this.numThreadsSampled.getSum();
        this.overheadTimer.time(() -> this.captureProfilerProcessingAsStackTrace(threadWeight), Timer.ProfilingTimes.captureProfilerProcessing);
        this.overheadTimer.time(() -> this.captureGarbageCollectionAsStackTrace(threadWeight), Timer.ProfilingTimes.captureGarbageCollection);
    }

    private void submitProfilingData(Instant now, boolean memoryRefresh) {
        try {
            boolean success = this.profilerFinalParameters.getReporter().report(new Profile(this.reportStartedAt, now, this.profilerFinalParameters.getAgentMetadata(), this.buildSamplingMetadata(now, this.cpuTimeMonitor.end()), this.profileBuilder, this.buildAgentDebugInfo(this.profilerFinalParameters.getErrorsMetadata())));
            this.numberOfTimesSampled = 0L;
            this.processingNanos = 0L;
            this.clearProfilingData(now, memoryRefresh);
            if (!success) {
                LOG.info("The profile reporter failed to report, dropping profile.");
            } else {
                LOG.info("Successfully reported profile");
            }
        }
        catch (ResourceNotFoundException rnfe) {
            if (!this.shouldIgnoreResourceNotFoundException()) {
                throw rnfe;
            }
            LOG.log(Level.INFO, "The profile reporter failed to report because profiling group name used didn't exist. We tried creating profiling group with default name, if successful then submitting profile in next invocation will succeed.", rnfe);
        }
    }

    protected boolean shouldIgnoreResourceNotFoundException() {
        return false;
    }

    private void clearProfilingData(Instant now, boolean memoryRefresh) {
        if (memoryRefresh) {
            this.profileBuilder.clear(true);
            this.lastMemoryRefreshTime = now;
        } else {
            this.profileBuilder.clear(false);
        }
        this.numThreadsSeen = new Counter();
        this.numThreadsSampled = new Counter();
        this.reportToEndAt = null;
        this.reportStartedAt = null;
        this.memoryProfiler.stopRecording();
        this.overheadTimer.reset();
        this.numberOfTimesSampled = 0L;
        this.processingNanos = 0L;
        this.profilerFinalParameters.getErrorsMetadata().reset();
    }

    private SamplingMetadata buildSamplingMetadata(Instant now, Duration cpuTime) {
        double totalSampleWeight = this.getSampleWeightFromSamplingTimes(now) * this.getSampleWeightFromThreadSubSampling();
        Map<String, Integer> numUnscaledSamples = this.profileBuilder.getMemoryProfileSamplingMetadata().getUnscaledSamples();
        return new SamplingMetadata(BigDecimal.valueOf(totalSampleWeight), this.getActiveDurationSinceLastReport(now), new SamplingMetadata.AgentOverhead(Duration.ofNanos(this.processingNanos), this.profileBuilder.getCallGraphBuilder().getSizeInMemory() / 1024L / 1024L), cpuTime, this.numThreadsSeen.getMaxAndAverage().getAverage(), numUnscaledSamples, this.numberOfTimesSampled);
    }

    private double getSampleWeightFromSamplingTimes(Instant now) {
        return this.numberOfTimesSampled > 0L ? (double)Duration.between(this.reportStartedAt.minus(this.parameters.getSamplingInterval()), now).getSeconds() / (double)this.numberOfTimesSampled : 1.0;
    }

    private double getSampleWeightFromThreadSubSampling() {
        return this.numThreadsSampled.getSum() > 0L ? (double)this.numThreadsSeen.getSum() / (double)this.numThreadsSampled.getSum() : 1.0;
    }

    private AgentDebugInfo buildAgentDebugInfo(ErrorsMetadata errorsMetadata) {
        HashMap<String, Double> agentMetrics = new HashMap<String, Double>();
        for (Map.Entry<String, Counter> timing : this.overheadTimer.getProfilingTimes().entrySet()) {
            Counter.MaxAndAverage maxAndAverage = timing.getValue().getMaxAndAverage();
            agentMetrics.put(timing.getKey() + "_max", Double.valueOf(maxAndAverage.getMax()));
            agentMetrics.put(timing.getKey() + "_average", maxAndAverage.getAverage());
        }
        return new AgentDebugInfo(agentMetrics, this.agentStartTime, errorsMetadata);
    }

    protected Duration getActiveDurationSinceLastReport(Instant now) {
        return Duration.between(this.reportStartedAt, now);
    }

    protected Instant getLastSampleTime() {
        return this.lastSampleTime;
    }

    protected long getNumberOfTimesSampled() {
        return this.numberOfTimesSampled;
    }

    @Override
    public ProfilerParameters getParameters() {
        return this.parameters;
    }

    @Override
    public ProfilerFinalParameters getFinalParameters() {
        return this.profilerFinalParameters;
    }

    protected boolean isFleetTypeIncorrect() {
        FleetInstanceType fleetType = this.profilerFinalParameters.getAgentMetadata().getFleetInfo().map(FleetInfo::getFleetInstanceType).orElse(FleetInstanceType.Unknown);
        if (FleetInstanceType.AWSLambda.equals((Object)fleetType)) {
            LOG.info("CodeGuru Profiler agent was found to be running on a AWS Lambda function. Profiling will be terminated. Please refer to CodeGuru Profiler's documentation to learn more about how to profile applications running outside of AWS Lambda");
            return true;
        }
        return false;
    }
}

