/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile;

import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.Timestamp;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Date;

public class IonUtils {
    private IonUtils() {
    }

    public static void writeString(IonWriter out, String fieldName, String value) throws IOException {
        out.setFieldName(fieldName);
        out.writeString(value);
    }

    public static void writeDecimal(IonWriter out, String fieldName, BigDecimal value) throws IOException {
        out.setFieldName(fieldName);
        out.writeDecimal(value);
    }

    public static void writeInt(IonWriter out, String fieldName, long value) throws IOException {
        out.setFieldName(fieldName);
        out.writeInt(value);
    }

    public static void writeTimestamp(IonWriter out, String fieldName, Instant date) throws IOException {
        out.setFieldName(fieldName);
        out.writeTimestamp(Timestamp.forDateZ((Date)Date.from(date)));
    }

    public static void writeStruct(IonWriter out, String fieldName, IonWriting applyInside) throws IOException {
        out.setFieldName(fieldName);
        IonUtils.writeStruct(out, applyInside);
    }

    public static void writeStruct(IonWriter out, IonWriting applyInside) throws IOException {
        out.stepIn(IonType.STRUCT);
        applyInside.apply();
        out.stepOut();
    }

    public static interface IonWriting {
        public void apply() throws IOException;
    }
}

