/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.sdkclientcopy.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.CodeGuruProfilerClient;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ListProfileTimesRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ListProfileTimesResponse;

public class ListProfileTimesIterable
implements SdkIterable<ListProfileTimesResponse> {
    private final CodeGuruProfilerClient client;
    private final ListProfileTimesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProfileTimesIterable(CodeGuruProfilerClient client, ListProfileTimesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProfileTimesResponseFetcher();
    }

    public Iterator<ListProfileTimesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListProfileTimesResponseFetcher
    implements SyncPageFetcher<ListProfileTimesResponse> {
        private ListProfileTimesResponseFetcher() {
        }

        public boolean hasNextPage(ListProfileTimesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProfileTimesResponse nextPage(ListProfileTimesResponse previousPage) {
            if (previousPage == null) {
                return ListProfileTimesIterable.this.client.listProfileTimes(ListProfileTimesIterable.this.firstRequest);
            }
            return ListProfileTimesIterable.this.client.listProfileTimes((ListProfileTimesRequest)((Object)ListProfileTimesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

