/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile.metadata;

import com.amazon.ion.IonWriter;
import java.io.IOException;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.SamplingMetadata;

public class AgentMetadataIonWriter {
    private AgentMetadataIonWriter() {
    }

    public static void write(IonWriter out, AgentMetadata agentMetadata, SamplingMetadata samplingMetadata) throws IOException {
        IonUtils.writeStruct(out, () -> {
            IonUtils.writeDecimal(out, "sampleWeightInSeconds", samplingMetadata.getSampleWeight());
            IonUtils.writeInt(out, "durationInMs", samplingMetadata.getSamplingDuration().toMillis());
            if (agentMetadata.getFleetInfo().isPresent()) {
                out.setFieldName("fleetInfo");
                agentMetadata.getFleetInfo().get().write(out);
            }
            agentMetadata.getAgentInfo().write(out, "agentInfo");
            agentMetadata.getCodeInfo().write(out, "codeInfo");
            samplingMetadata.getAgentOverhead().write(out, "agentOverhead");
            IonUtils.writeString(out, "runtimeVersion", agentMetadata.getRuntimeVersion());
            agentMetadata.getErrorsMetadata().write(out, "errorsCount");
            IonUtils.writeString(out, "gcType", agentMetadata.getGcType());
        });
    }
}

