/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.logger;

import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.cloudwatchlogs.emf.environment.Environment;
import software.amazon.cloudwatchlogs.emf.environment.EnvironmentProvider;
import software.amazon.cloudwatchlogs.emf.exception.DimensionSetExceededException;
import software.amazon.cloudwatchlogs.emf.exception.InvalidDimensionException;
import software.amazon.cloudwatchlogs.emf.exception.InvalidMetricException;
import software.amazon.cloudwatchlogs.emf.exception.InvalidNamespaceException;
import software.amazon.cloudwatchlogs.emf.exception.InvalidTimestampException;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.MetricsContext;
import software.amazon.cloudwatchlogs.emf.model.Unit;
import software.amazon.cloudwatchlogs.emf.sinks.ISink;

public class MetricsLogger {
    private static final Logger log = LoggerFactory.getLogger(MetricsLogger.class);
    private MetricsContext context;
    private CompletableFuture<Environment> environmentFuture;
    private EnvironmentProvider environmentProvider;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private boolean flushPreserveDimensions = true;

    public MetricsLogger() {
        this(new EnvironmentProvider());
    }

    public MetricsLogger(Environment environment) {
        this.context = new MetricsContext();
        this.environmentFuture = CompletableFuture.completedFuture(environment);
        this.environmentProvider = null;
    }

    public MetricsLogger(EnvironmentProvider environmentProvider) {
        this(environmentProvider, new MetricsContext());
    }

    public MetricsLogger(EnvironmentProvider environmentProvider, MetricsContext metricsContext) {
        this.context = metricsContext;
        this.environmentFuture = environmentProvider.resolveEnvironment();
        this.environmentProvider = environmentProvider;
    }

    public void flush() {
        Environment environment;
        try {
            environment = this.environmentFuture.join();
        }
        catch (Exception ex) {
            log.info("Failed to resolve environment. Fallback to default environment: ", (Throwable)ex);
            environment = this.environmentProvider.getDefaultEnvironment();
        }
        this.rwl.writeLock().lock();
        try {
            ISink sink = environment.getSink();
            this.configureContextForEnvironment(this.context, environment);
            sink.accept(this.context);
            this.context = this.context.createCopyWithContext(this.flushPreserveDimensions);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public MetricsLogger putProperty(String key, Object value) {
        return this.applyReadLock(() -> {
            this.context.putProperty(key, value);
            return this;
        });
    }

    public MetricsLogger putDimensions(DimensionSet dimensions) {
        return this.applyReadLock(() -> {
            this.context.putDimension(dimensions);
            return this;
        });
    }

    public MetricsLogger setDimensions(DimensionSet ... dimensionSets) {
        return this.applyReadLock(() -> {
            this.context.setDimensions(dimensionSets);
            return this;
        });
    }

    public MetricsLogger setDimensions(boolean useDefault, DimensionSet ... dimensionSets) {
        return this.applyReadLock(() -> {
            this.context.setDimensions(useDefault, dimensionSets);
            return this;
        });
    }

    public MetricsLogger resetDimensions(boolean useDefault) {
        return this.applyReadLock(() -> {
            this.context.resetDimensions(useDefault);
            return this;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsLogger putMetric(String key, double value, Unit unit) throws InvalidMetricException {
        this.rwl.readLock().lock();
        try {
            this.context.putMetric(key, value, unit);
            MetricsLogger metricsLogger = this;
            return metricsLogger;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public MetricsLogger putMetric(String key, double value) throws InvalidMetricException {
        this.putMetric(key, value, Unit.NONE);
        return this;
    }

    public MetricsLogger putMetadata(String key, Object value) {
        return this.applyReadLock(() -> {
            this.context.putMetadata(key, value);
            return this;
        });
    }

    public MetricsLogger setNamespace(String namespace) throws InvalidNamespaceException {
        this.context.setNamespace(namespace);
        return this;
    }

    public MetricsLogger setTimestamp(Instant timestamp) throws InvalidTimestampException {
        this.context.setTimestamp(timestamp);
        return this;
    }

    private void configureContextForEnvironment(MetricsContext context, Environment environment) {
        if (context.hasDefaultDimensions()) {
            return;
        }
        DimensionSet defaultDimension = new DimensionSet();
        this.setDefaultDimension(defaultDimension, "LogGroup", environment.getLogGroupName());
        this.setDefaultDimension(defaultDimension, "ServiceName", environment.getName());
        this.setDefaultDimension(defaultDimension, "ServiceType", environment.getType());
        context.setDefaultDimensions(defaultDimension);
        environment.configureContext(context);
    }

    private void setDefaultDimension(DimensionSet defaultDimension, String dimKey, String dimVal) {
        try {
            defaultDimension.addDimension(dimKey, dimVal);
        }
        catch (DimensionSetExceededException | InvalidDimensionException exception) {
            // empty catch block
        }
    }

    private MetricsLogger applyReadLock(Supplier<MetricsLogger> any) {
        this.rwl.readLock().lock();
        try {
            MetricsLogger metricsLogger = any.get();
            return metricsLogger;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public boolean isFlushPreserveDimensions() {
        return this.flushPreserveDimensions;
    }

    public void setFlushPreserveDimensions(boolean flushPreserveDimensions) {
        this.flushPreserveDimensions = flushPreserveDimensions;
    }
}

