/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.sinks;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.cloudwatchlogs.emf.sinks.Endpoint;
import software.amazon.cloudwatchlogs.emf.sinks.SocketClient;

class UDPClient
implements SocketClient {
    private static final Logger log = LoggerFactory.getLogger(UDPClient.class);
    private InetSocketAddress inetAddress;
    private DatagramSocket datagramSocket;
    private Endpoint endpoint;

    UDPClient(Endpoint endpoint) {
        this.inetAddress = new InetSocketAddress(endpoint.getHost(), endpoint.getPort());
        this.endpoint = endpoint;
    }

    @Override
    public void sendMessage(String message) {
        byte[] data = message.getBytes(StandardCharsets.UTF_8);
        DatagramPacket packet = new DatagramPacket(data, data.length, this.inetAddress);
        this.flush(packet);
    }

    private synchronized void flush(DatagramPacket packet) {
        try {
            if (this.datagramSocket == null) {
                this.createSocket();
            }
            if (this.datagramSocket != null) {
                this.datagramSocket.send(packet);
            } else {
                log.warn("No DatagramSocket available. Message would be dropped");
            }
        }
        catch (IOException ex) {
            String msg = "Failed to send DatagramPacket to " + this.inetAddress;
            log.error(msg, (Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.datagramSocket != null) {
            this.datagramSocket.close();
        }
    }

    private void createSocket() {
        try {
            this.datagramSocket = new DatagramSocket();
        }
        catch (SocketException ex) {
            String msg = "Could not instantiate DatagramSocket to " + this.endpoint.getHost();
            log.error(msg, (Throwable)ex);
        }
    }
}

