/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.environment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.cloudwatchlogs.emf.config.Configuration;
import software.amazon.cloudwatchlogs.emf.environment.AgentBasedEnvironment;
import software.amazon.cloudwatchlogs.emf.environment.ResourceFetcher;
import software.amazon.cloudwatchlogs.emf.exception.EMFClientException;
import software.amazon.cloudwatchlogs.emf.model.MetricsContext;

class EC2Environment
extends AgentBasedEnvironment {
    private static final Logger log = LoggerFactory.getLogger(EC2Environment.class);
    private Configuration config;
    private EC2Metadata metadata;
    private ResourceFetcher fetcher;
    private static final String INSTANCE_IDENTITY_URL = "http://169.254.169.254/latest/dynamic/instance-identity/document";
    private static final String CFN_EC2_TYPE = "AWS::EC2::Instance";

    EC2Environment(Configuration config, ResourceFetcher fetcher) {
        super(config);
        this.config = config;
        this.fetcher = fetcher;
    }

    @Override
    public boolean probe() {
        URI endpoint = null;
        try {
            endpoint = new URI(INSTANCE_IDENTITY_URL);
        }
        catch (Exception ex) {
            log.debug("Failed to construct url: http://169.254.169.254/latest/dynamic/instance-identity/document");
            return false;
        }
        try {
            this.metadata = this.fetcher.fetch(endpoint, EC2Metadata.class);
            return true;
        }
        catch (EMFClientException ex) {
            log.debug("Failed to get response from: " + endpoint, (Throwable)ex);
            return false;
        }
    }

    @Override
    public String getType() {
        if (this.config.getServiceType().isPresent()) {
            return this.config.getServiceType().get();
        }
        if (this.metadata != null) {
            return CFN_EC2_TYPE;
        }
        return "Unknown";
    }

    @Override
    public void configureContext(MetricsContext context) {
        if (this.metadata != null) {
            context.putProperty("imageId", this.metadata.imageId);
            context.putProperty("instanceId", this.metadata.instanceId);
            context.putProperty("instanceType", this.metadata.instanceType);
            context.putProperty("privateIp", this.metadata.privateIp);
            context.putProperty("availabilityZone", this.metadata.availabilityZone);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class EC2Metadata {
        private String imageId;
        private String availabilityZone;
        private String privateIp;
        private String instanceId;
        private String instanceType;

        public String getImageId() {
            return this.imageId;
        }

        public String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public String getPrivateIp() {
            return this.privateIp;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EC2Metadata)) {
                return false;
            }
            EC2Metadata other = (EC2Metadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$imageId = this.getImageId();
            String other$imageId = other.getImageId();
            if (this$imageId == null ? other$imageId != null : !this$imageId.equals(other$imageId)) {
                return false;
            }
            String this$availabilityZone = this.getAvailabilityZone();
            String other$availabilityZone = other.getAvailabilityZone();
            if (this$availabilityZone == null ? other$availabilityZone != null : !this$availabilityZone.equals(other$availabilityZone)) {
                return false;
            }
            String this$privateIp = this.getPrivateIp();
            String other$privateIp = other.getPrivateIp();
            if (this$privateIp == null ? other$privateIp != null : !this$privateIp.equals(other$privateIp)) {
                return false;
            }
            String this$instanceId = this.getInstanceId();
            String other$instanceId = other.getInstanceId();
            if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
                return false;
            }
            String this$instanceType = this.getInstanceType();
            String other$instanceType = other.getInstanceType();
            return !(this$instanceType == null ? other$instanceType != null : !this$instanceType.equals(other$instanceType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EC2Metadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $imageId = this.getImageId();
            result = result * 59 + ($imageId == null ? 43 : $imageId.hashCode());
            String $availabilityZone = this.getAvailabilityZone();
            result = result * 59 + ($availabilityZone == null ? 43 : $availabilityZone.hashCode());
            String $privateIp = this.getPrivateIp();
            result = result * 59 + ($privateIp == null ? 43 : $privateIp.hashCode());
            String $instanceId = this.getInstanceId();
            result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
            String $instanceType = this.getInstanceType();
            result = result * 59 + ($instanceType == null ? 43 : $instanceType.hashCode());
            return result;
        }

        public String toString() {
            return "EC2Environment.EC2Metadata(imageId=" + this.getImageId() + ", availabilityZone=" + this.getAvailabilityZone() + ", privateIp=" + this.getPrivateIp() + ", instanceId=" + this.getInstanceId() + ", instanceType=" + this.getInstanceType() + ")";
        }
    }
}

