/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.sinks;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.cloudwatchlogs.emf.model.MetricsContext;
import software.amazon.cloudwatchlogs.emf.sinks.Endpoint;
import software.amazon.cloudwatchlogs.emf.sinks.ISink;
import software.amazon.cloudwatchlogs.emf.sinks.SocketClient;
import software.amazon.cloudwatchlogs.emf.sinks.SocketClientFactory;
import software.amazon.cloudwatchlogs.emf.util.StringUtils;

public class AgentSink
implements ISink {
    private static final Logger log = LoggerFactory.getLogger(AgentSink.class);
    private final String logGroupName;
    private final String logStreamName;
    private final SocketClient client;

    public AgentSink(String logGroupName, String logStreamName, Endpoint endpoint, SocketClientFactory clientFactory) {
        this.logGroupName = logGroupName;
        this.logStreamName = logStreamName;
        this.client = clientFactory.getClient(endpoint);
    }

    @Override
    public void accept(MetricsContext context) {
        if (!StringUtils.isNullOrEmpty(this.logGroupName)) {
            context.putMetadata("LogGroupName", this.logGroupName);
        }
        if (!StringUtils.isNullOrEmpty(this.logStreamName)) {
            context.putMetadata("LogStreamName", this.logStreamName);
        }
        try {
            this.client.sendMessage(context.serialize() + "\n");
        }
        catch (JsonProcessingException e) {
            log.error("Failed to serialize the metrics with the exception: ", (Throwable)e);
        }
    }
}

