/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.resource.exceptions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = 42L;
    private static final List<String> SAFE_KEYWORDS = Arrays.asList("required", "minProperties", "maxProperties", "dependencies", "additionalProperties", "minLength", "maxLength", "minItems", "maxItems", "uniqueItems", "contains", "type", "allOf", "anyOf", "oneOf");
    private final List<ValidationException> causingExceptions;
    private final String keyword;
    private final String schemaPointer;

    public ValidationException(String message, String keyword, String schemaPointer) {
        this(message, Collections.emptyList(), keyword, schemaPointer);
    }

    public ValidationException(String message, String schemaPointer, Exception cause) {
        super(message, cause);
        this.causingExceptions = Collections.emptyList();
        this.keyword = "";
        this.schemaPointer = schemaPointer;
    }

    public ValidationException(String message, List<ValidationException> causingExceptions, String keyword, String schemaPointer) {
        super(message);
        this.causingExceptions = Collections.unmodifiableList(causingExceptions == null ? Collections.emptyList() : causingExceptions);
        this.keyword = keyword;
        this.schemaPointer = schemaPointer;
    }

    private ValidationException(org.everit.json.schema.ValidationException validationException) {
        this(validationException.getMessage(), validationException);
    }

    private ValidationException(String errorMessage, org.everit.json.schema.ValidationException validationException) {
        super(errorMessage);
        this.keyword = validationException.getKeyword();
        this.schemaPointer = validationException.getPointerToViolation();
        ArrayList<ValidationException> causingExceptions = new ArrayList<ValidationException>();
        if (validationException.getCausingExceptions() != null) {
            for (org.everit.json.schema.ValidationException e : validationException.getCausingExceptions()) {
                causingExceptions.add(ValidationException.newScrubbedException(e));
            }
        }
        this.causingExceptions = Collections.unmodifiableList(causingExceptions);
    }

    public static ValidationException newScrubbedException(org.everit.json.schema.ValidationException e) {
        boolean isParentException;
        boolean bl = isParentException = e.getKeyword() == null && e.getCausingExceptions() != null && !e.getCausingExceptions().isEmpty();
        if (isParentException || SAFE_KEYWORDS.contains(e.getKeyword())) {
            return new ValidationException(e);
        }
        String errorMessage = String.format("%s: failed validation constraint for keyword [%s]", e.getPointerToViolation(), e.getKeyword());
        return new ValidationException(errorMessage, e);
    }

    public static String buildFullExceptionMessage(ValidationException e) {
        return ValidationException.buildFullExceptionMessageHelper(e).trim();
    }

    private static String buildFullExceptionMessageHelper(ValidationException e) {
        boolean isParentException;
        StringBuilder builder = new StringBuilder();
        boolean bl = isParentException = e.getKeyword() == null && e.getCausingExceptions() != null && !e.getCausingExceptions().isEmpty();
        if (!isParentException && e.getMessage() != null) {
            builder.append(e.getMessage() + "\n");
        }
        if (e.getCausingExceptions() != null) {
            for (ValidationException cause : e.getCausingExceptions()) {
                builder.append(ValidationException.buildFullExceptionMessageHelper(cause));
            }
        }
        return builder.toString();
    }

    @Generated
    public List<ValidationException> getCausingExceptions() {
        return this.causingExceptions;
    }

    @Generated
    public String getKeyword() {
        return this.keyword;
    }

    @Generated
    public String getSchemaPointer() {
        return this.schemaPointer;
    }
}

