/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.resource;

import lombok.Generated;
import org.everit.json.schema.JSONPointer;
import org.everit.json.schema.Schema;
import software.amazon.cloudformation.resource.exceptions.ValidationException;

public class ResourceTagging {
    public static final String TAGGABLE = "taggable";
    public static final String TAG_ON_CREATE = "tagOnCreate";
    public static final String TAG_UPDATABLE = "tagUpdatable";
    public static final String CLOUDFORMATION_SYSTEM_TAGS = "cloudFormationSystemTags";
    public static final String TAG_PROPERTY = "tagProperty";
    public static final ResourceTagging DEFAULT = new ResourceTagging(true, true, true, true, new JSONPointer("/properties/Tags"));
    private boolean taggable;
    private boolean tagOnCreate;
    private boolean tagUpdatable;
    private boolean cloudFormationSystemTags;
    private JSONPointer tagProperty;

    public void resetTaggable(boolean taggableValue) {
        this.taggable = taggableValue;
        this.tagOnCreate = taggableValue;
        this.tagUpdatable = taggableValue;
        this.cloudFormationSystemTags = taggableValue;
    }

    public void validateTaggingMetadata(boolean containUpdateHandler, Schema schema) {
        if (this.tagUpdatable && !containUpdateHandler) {
            throw new ValidationException("Invalid tagUpdatable value since update handler is missing", "tagging", "#/tagging/tagUpdatable");
        }
        String propertyName = this.tagProperty.toString().substring(this.tagProperty.toString().lastIndexOf(47) + 1);
        if (this.taggable && !schema.definesProperty(propertyName)) {
            String errorMessage = String.format("Invalid tagProperty value since %s not found in schema", propertyName);
            throw new ValidationException(errorMessage, "tagging", "#/tagging/tagProperty");
        }
    }

    @Generated
    public boolean isTaggable() {
        return this.taggable;
    }

    @Generated
    public boolean isTagOnCreate() {
        return this.tagOnCreate;
    }

    @Generated
    public boolean isTagUpdatable() {
        return this.tagUpdatable;
    }

    @Generated
    public boolean isCloudFormationSystemTags() {
        return this.cloudFormationSystemTags;
    }

    @Generated
    public JSONPointer getTagProperty() {
        return this.tagProperty;
    }

    @Generated
    public void setTaggable(boolean taggable) {
        this.taggable = taggable;
    }

    @Generated
    public void setTagOnCreate(boolean tagOnCreate) {
        this.tagOnCreate = tagOnCreate;
    }

    @Generated
    public void setTagUpdatable(boolean tagUpdatable) {
        this.tagUpdatable = tagUpdatable;
    }

    @Generated
    public void setCloudFormationSystemTags(boolean cloudFormationSystemTags) {
        this.cloudFormationSystemTags = cloudFormationSystemTags;
    }

    @Generated
    public void setTagProperty(JSONPointer tagProperty) {
        this.tagProperty = tagProperty;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceTagging)) {
            return false;
        }
        ResourceTagging other = (ResourceTagging)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTaggable() != other.isTaggable()) {
            return false;
        }
        if (this.isTagOnCreate() != other.isTagOnCreate()) {
            return false;
        }
        if (this.isTagUpdatable() != other.isTagUpdatable()) {
            return false;
        }
        if (this.isCloudFormationSystemTags() != other.isCloudFormationSystemTags()) {
            return false;
        }
        JSONPointer this$tagProperty = this.getTagProperty();
        JSONPointer other$tagProperty = other.getTagProperty();
        return !(this$tagProperty == null ? other$tagProperty != null : !this$tagProperty.equals(other$tagProperty));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResourceTagging;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTaggable() ? 79 : 97);
        result = result * 59 + (this.isTagOnCreate() ? 79 : 97);
        result = result * 59 + (this.isTagUpdatable() ? 79 : 97);
        result = result * 59 + (this.isCloudFormationSystemTags() ? 79 : 97);
        JSONPointer $tagProperty = this.getTagProperty();
        result = result * 59 + ($tagProperty == null ? 43 : $tagProperty.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResourceTagging(taggable=" + this.isTaggable() + ", tagOnCreate=" + this.isTagOnCreate() + ", tagUpdatable=" + this.isTagUpdatable() + ", cloudFormationSystemTags=" + this.isCloudFormationSystemTags() + ", tagProperty=" + this.getTagProperty() + ")";
    }

    @Generated
    public ResourceTagging(boolean taggable, boolean tagOnCreate, boolean tagUpdatable, boolean cloudFormationSystemTags, JSONPointer tagProperty) {
        this.taggable = taggable;
        this.tagOnCreate = tagOnCreate;
        this.tagUpdatable = tagUpdatable;
        this.cloudFormationSystemTags = cloudFormationSystemTags;
        this.tagProperty = tagProperty;
    }
}

