/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.resource;

import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.internal.DefaultSchemaClient;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import software.amazon.cloudformation.resource.SchemaValidator;
import software.amazon.cloudformation.resource.exceptions.ValidationException;

public class Validator
implements SchemaValidator {
    private static final URI JSON_SCHEMA_URI_HTTP = Validator.newURI("http://json-schema.org/draft-07/schema");
    private static final URI RESOURCE_DEFINITION_SCHEMA_URI = Validator.newURI("https://schema.cloudformation.us-east-1.amazonaws.com/provider.definition.schema.v1.json");
    private static final String ID_KEY = "$id";
    private static final String JSON_SCHEMA_PATH = "/schema/schema";
    private static final String RESOURCE_DEFINITION_SCHEMA_PATH = "/schema/provider.definition.schema.v1.json";
    private final JSONObject definitionSchemaJsonObject;
    private final JSONObject jsonSchemaObject;
    private final SchemaClient downloader;

    public Validator(SchemaClient downloader) {
        this(Validator.loadResourceAsJSON(JSON_SCHEMA_PATH), Validator.loadResourceAsJSON(RESOURCE_DEFINITION_SCHEMA_PATH), downloader);
    }

    private Validator(JSONObject jsonSchema, JSONObject definitionSchema, SchemaClient downloader) {
        this.jsonSchemaObject = jsonSchema;
        this.definitionSchemaJsonObject = definitionSchema;
        this.downloader = downloader;
    }

    public Validator() {
        this((SchemaClient)new DefaultSchemaClient());
    }

    private Schema makeResourceDefinitionSchema() {
        SchemaLoader.SchemaLoaderBuilder builder = this.getSchemaLoader();
        builder.schemaJson(this.definitionSchemaJsonObject);
        return builder.build().load().build();
    }

    @Override
    public void validateObject(JSONObject modelObject, JSONObject definitionSchemaObject) throws ValidationException {
        SchemaLoader.SchemaLoaderBuilder loader = this.getSchemaLoader(definitionSchemaObject);
        try {
            Schema schema = loader.build().load().build();
            schema.validate((Object)modelObject);
        }
        catch (org.everit.json.schema.ValidationException e) {
            throw ValidationException.newScrubbedException(e);
        }
    }

    void validateResourceDefinition(JSONObject resourceDefinition) {
        this.loadResourceDefinitionSchema(resourceDefinition);
    }

    public Schema loadResourceDefinitionSchema(JSONObject resourceDefinition) {
        resourceDefinition.put("$schema", (Object)RESOURCE_DEFINITION_SCHEMA_URI.toString());
        try {
            Schema resourceDefValidator = this.makeResourceDefinitionSchema();
            resourceDefValidator.validate((Object)resourceDefinition);
            SchemaLoader.SchemaLoaderBuilder builder = this.getSchemaLoader();
            this.registerMetaSchema(builder, this.jsonSchemaObject);
            builder.schemaJson(resourceDefinition);
            return builder.build().load().build();
        }
        catch (org.everit.json.schema.ValidationException e) {
            throw ValidationException.newScrubbedException(e);
        }
        catch (SchemaException e) {
            throw new ValidationException(e.getMessage(), e.getSchemaLocation(), (Exception)((Object)e));
        }
    }

    private SchemaLoader.SchemaLoaderBuilder getSchemaLoader(JSONObject schemaObject) {
        return this.getSchemaLoader().schemaJson(schemaObject);
    }

    private SchemaLoader.SchemaLoaderBuilder getSchemaLoader() {
        SchemaLoader.SchemaLoaderBuilder builder = SchemaLoader.builder().draftV7Support().schemaClient(this.downloader);
        builder.registerSchemaByURI(JSON_SCHEMA_URI_HTTP, (Object)this.jsonSchemaObject);
        return builder;
    }

    private static JSONObject loadResourceAsJSON(String path) {
        return new JSONObject(new JSONTokener(Validator.class.getResourceAsStream(path)));
    }

    static URI newURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(uri);
        }
    }

    void registerMetaSchema(SchemaLoader.SchemaLoaderBuilder loaderBuilder, JSONObject schema) {
        try {
            String id = schema.getString(ID_KEY);
            if (id.isEmpty()) {
                throw new ValidationException("Invalid $id value", ID_KEY, "[empty string]");
            }
            URI uri = new URI(id);
            loaderBuilder.registerSchemaByURI(uri, (Object)schema);
        }
        catch (URISyntaxException e) {
            throw new ValidationException("Invalid $id value", ID_KEY, e);
        }
        catch (JSONException e) {
            throw new ValidationException("Invalid $id value", ID_KEY, (Exception)((Object)e));
        }
    }

    @Generated
    public static ValidatorBuilder builder() {
        return new ValidatorBuilder();
    }

    @Generated
    public static class ValidatorBuilder {
        @Generated
        ValidatorBuilder() {
        }

        @Generated
        public Validator build() {
            return new Validator();
        }

        @Generated
        public String toString() {
            return "Validator.ValidatorBuilder()";
        }
    }
}

