/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.resource;

import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import software.amazon.cloudformation.resource.SchemaValidator;
import software.amazon.cloudformation.resource.exceptions.ValidationException;

public class Validator
implements SchemaValidator {
    private static final String JSON_SCHEMA_ID = "https://json-schema.org/draft-07/schema";
    private static final String JSON_SCHEMA_PATH = "/schema/schema";
    private static final String METASCHEMA_PATH = "/schema/provider.definition.schema.v1.json";
    private final JSONObject definitionSchemaJsonObject;
    private final JSONObject jsonSchemaObject = new JSONObject(new JSONTokener(this.getClass().getResourceAsStream("/schema/schema")));

    public Validator() {
        this.definitionSchemaJsonObject = new JSONObject(new JSONTokener(this.getClass().getResourceAsStream(METASCHEMA_PATH)));
    }

    @Override
    public void validateObject(JSONObject modelObject, JSONObject definitionSchemaObject) throws ValidationException {
        try {
            URI schemaURI = new URI(JSON_SCHEMA_ID);
            SchemaLoader loader = SchemaLoader.builder().schemaJson(definitionSchemaObject).registerSchemaByURI(schemaURI, (Object)this.jsonSchemaObject).draftV7Support().build();
            Schema schema = loader.load().build();
            try {
                schema.validate((Object)modelObject);
            }
            catch (org.everit.json.schema.ValidationException e) {
                throw ValidationException.newScrubbedException(e);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URI format for JSON schema.");
        }
    }

    public void validateResourceDefinition(JSONObject definition) throws ValidationException {
        this.validateObject(definition, this.definitionSchemaJsonObject);
    }

    @Generated
    public static ValidatorBuilder builder() {
        return new ValidatorBuilder();
    }

    @Generated
    public static class ValidatorBuilder {
        @Generated
        ValidatorBuilder() {
        }

        @Generated
        public Validator build() {
            return new Validator();
        }

        @Generated
        public String toString() {
            return "Validator.ValidatorBuilder()";
        }
    }
}

