/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayAsyncClient;
import software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest;
import software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsResponse;
import software.amazon.awssdk.services.xray.model.TimeSeriesServiceStatistics;

public class GetTimeSeriesServiceStatisticsPublisher
implements SdkPublisher<GetTimeSeriesServiceStatisticsResponse> {
    private final XRayAsyncClient client;
    private final GetTimeSeriesServiceStatisticsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTimeSeriesServiceStatisticsPublisher(XRayAsyncClient client, GetTimeSeriesServiceStatisticsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTimeSeriesServiceStatisticsPublisher(XRayAsyncClient client, GetTimeSeriesServiceStatisticsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTimeSeriesServiceStatisticsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTimeSeriesServiceStatisticsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TimeSeriesServiceStatistics> timeSeriesServiceStatistics() {
        Function<GetTimeSeriesServiceStatisticsResponse, Iterator> getIterator = response -> {
            if (response != null && response.timeSeriesServiceStatistics() != null) {
                return response.timeSeriesServiceStatistics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetTimeSeriesServiceStatisticsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetTimeSeriesServiceStatisticsResponseFetcher
    implements AsyncPageFetcher<GetTimeSeriesServiceStatisticsResponse> {
        private GetTimeSeriesServiceStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(GetTimeSeriesServiceStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetTimeSeriesServiceStatisticsResponse> nextPage(GetTimeSeriesServiceStatisticsResponse previousPage) {
            if (previousPage == null) {
                return GetTimeSeriesServiceStatisticsPublisher.this.client.getTimeSeriesServiceStatistics(GetTimeSeriesServiceStatisticsPublisher.this.firstRequest);
            }
            return GetTimeSeriesServiceStatisticsPublisher.this.client.getTimeSeriesServiceStatistics((GetTimeSeriesServiceStatisticsRequest)((Object)GetTimeSeriesServiceStatisticsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

