/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request anomaly stats for a single rule from a service. Results are for the last 10 seconds unless the service has
 * been assigned a longer reporting interval after a previous call to <a
 * href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html">GetSamplingTargets</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamplingBoostStatisticsDocument implements SdkPojo, Serializable,
        ToCopyableBuilder<SamplingBoostStatisticsDocument.Builder, SamplingBoostStatisticsDocument> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(SamplingBoostStatisticsDocument::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(SamplingBoostStatisticsDocument::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(SamplingBoostStatisticsDocument::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<Integer> ANOMALY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AnomalyCount").getter(getter(SamplingBoostStatisticsDocument::anomalyCount))
            .setter(setter(Builder::anomalyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyCount").build()).build();

    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalCount").getter(getter(SamplingBoostStatisticsDocument::totalCount))
            .setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final SdkField<Integer> SAMPLED_ANOMALY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SampledAnomalyCount").getter(getter(SamplingBoostStatisticsDocument::sampledAnomalyCount))
            .setter(setter(Builder::sampledAnomalyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledAnomalyCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            SERVICE_NAME_FIELD, TIMESTAMP_FIELD, ANOMALY_COUNT_FIELD, TOTAL_COUNT_FIELD, SAMPLED_ANOMALY_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ruleName;

    private final String serviceName;

    private final Instant timestamp;

    private final Integer anomalyCount;

    private final Integer totalCount;

    private final Integer sampledAnomalyCount;

    private SamplingBoostStatisticsDocument(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.serviceName = builder.serviceName;
        this.timestamp = builder.timestamp;
        this.anomalyCount = builder.anomalyCount;
        this.totalCount = builder.totalCount;
        this.sampledAnomalyCount = builder.sampledAnomalyCount;
    }

    /**
     * <p>
     * The name of the sampling rule.
     * </p>
     * 
     * @return The name of the sampling rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * Matches the <code>name</code> that the service uses to identify itself in segments.
     * </p>
     * 
     * @return Matches the <code>name</code> that the service uses to identify itself in segments.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The current time.
     * </p>
     * 
     * @return The current time.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The number of requests with anomaly.
     * </p>
     * 
     * @return The number of requests with anomaly.
     */
    public final Integer anomalyCount() {
        return anomalyCount;
    }

    /**
     * <p>
     * The number of requests that associated to the rule.
     * </p>
     * 
     * @return The number of requests that associated to the rule.
     */
    public final Integer totalCount() {
        return totalCount;
    }

    /**
     * <p>
     * The number of requests with anomaly recorded.
     * </p>
     * 
     * @return The number of requests with anomaly recorded.
     */
    public final Integer sampledAnomalyCount() {
        return sampledAnomalyCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(sampledAnomalyCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingBoostStatisticsDocument)) {
            return false;
        }
        SamplingBoostStatisticsDocument other = (SamplingBoostStatisticsDocument) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(timestamp(), other.timestamp()) && Objects.equals(anomalyCount(), other.anomalyCount())
                && Objects.equals(totalCount(), other.totalCount())
                && Objects.equals(sampledAnomalyCount(), other.sampledAnomalyCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SamplingBoostStatisticsDocument").add("RuleName", ruleName()).add("ServiceName", serviceName())
                .add("Timestamp", timestamp()).add("AnomalyCount", anomalyCount()).add("TotalCount", totalCount())
                .add("SampledAnomalyCount", sampledAnomalyCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "AnomalyCount":
            return Optional.ofNullable(clazz.cast(anomalyCount()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        case "SampledAnomalyCount":
            return Optional.ofNullable(clazz.cast(sampledAnomalyCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("AnomalyCount", ANOMALY_COUNT_FIELD);
        map.put("TotalCount", TOTAL_COUNT_FIELD);
        map.put("SampledAnomalyCount", SAMPLED_ANOMALY_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SamplingBoostStatisticsDocument, T> g) {
        return obj -> g.apply((SamplingBoostStatisticsDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamplingBoostStatisticsDocument> {
        /**
         * <p>
         * The name of the sampling rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the sampling rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * Matches the <code>name</code> that the service uses to identify itself in segments.
         * </p>
         * 
         * @param serviceName
         *        Matches the <code>name</code> that the service uses to identify itself in segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The current time.
         * </p>
         * 
         * @param timestamp
         *        The current time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The number of requests with anomaly.
         * </p>
         * 
         * @param anomalyCount
         *        The number of requests with anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyCount(Integer anomalyCount);

        /**
         * <p>
         * The number of requests that associated to the rule.
         * </p>
         * 
         * @param totalCount
         *        The number of requests that associated to the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);

        /**
         * <p>
         * The number of requests with anomaly recorded.
         * </p>
         * 
         * @param sampledAnomalyCount
         *        The number of requests with anomaly recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampledAnomalyCount(Integer sampledAnomalyCount);
    }

    static final class BuilderImpl implements Builder {
        private String ruleName;

        private String serviceName;

        private Instant timestamp;

        private Integer anomalyCount;

        private Integer totalCount;

        private Integer sampledAnomalyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingBoostStatisticsDocument model) {
            ruleName(model.ruleName);
            serviceName(model.serviceName);
            timestamp(model.timestamp);
            anomalyCount(model.anomalyCount);
            totalCount(model.totalCount);
            sampledAnomalyCount(model.sampledAnomalyCount);
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Integer getAnomalyCount() {
            return anomalyCount;
        }

        public final void setAnomalyCount(Integer anomalyCount) {
            this.anomalyCount = anomalyCount;
        }

        @Override
        public final Builder anomalyCount(Integer anomalyCount) {
            this.anomalyCount = anomalyCount;
            return this;
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final Integer getSampledAnomalyCount() {
            return sampledAnomalyCount;
        }

        public final void setSampledAnomalyCount(Integer sampledAnomalyCount) {
            this.sampledAnomalyCount = sampledAnomalyCount;
        }

        @Override
        public final Builder sampledAnomalyCount(Integer sampledAnomalyCount) {
            this.sampledAnomalyCount = sampledAnomalyCount;
            return this;
        }

        @Override
        public SamplingBoostStatisticsDocument build() {
            return new SamplingBoostStatisticsDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
