/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRetrievedTracesRequest extends XRayRequest implements
        ToCopyableBuilder<ListRetrievedTracesRequest.Builder, ListRetrievedTracesRequest> {
    private static final SdkField<String> RETRIEVAL_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetrievalToken").getter(getter(ListRetrievedTracesRequest::retrievalToken))
            .setter(setter(Builder::retrievalToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalToken").build()).build();

    private static final SdkField<String> TRACE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TraceFormat").getter(getter(ListRetrievedTracesRequest::traceFormatAsString))
            .setter(setter(Builder::traceFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceFormat").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRetrievedTracesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVAL_TOKEN_FIELD,
            TRACE_FORMAT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String retrievalToken;

    private final String traceFormat;

    private final String nextToken;

    private ListRetrievedTracesRequest(BuilderImpl builder) {
        super(builder);
        this.retrievalToken = builder.retrievalToken;
        this.traceFormat = builder.traceFormat;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Retrieval token.
     * </p>
     * 
     * @return Retrieval token.
     */
    public final String retrievalToken() {
        return retrievalToken;
    }

    /**
     * <p>
     * Format of the requested traces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #traceFormat} will
     * return {@link TraceFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traceFormatAsString}.
     * </p>
     * 
     * @return Format of the requested traces.
     * @see TraceFormatType
     */
    public final TraceFormatType traceFormat() {
        return TraceFormatType.fromValue(traceFormat);
    }

    /**
     * <p>
     * Format of the requested traces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #traceFormat} will
     * return {@link TraceFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traceFormatAsString}.
     * </p>
     * 
     * @return Format of the requested traces.
     * @see TraceFormatType
     */
    public final String traceFormatAsString() {
        return traceFormat;
    }

    /**
     * <p>
     * Specify the pagination token returned by a previous request to retrieve the next page of indexes.
     * </p>
     * 
     * @return Specify the pagination token returned by a previous request to retrieve the next page of indexes.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(retrievalToken());
        hashCode = 31 * hashCode + Objects.hashCode(traceFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetrievedTracesRequest)) {
            return false;
        }
        ListRetrievedTracesRequest other = (ListRetrievedTracesRequest) obj;
        return Objects.equals(retrievalToken(), other.retrievalToken())
                && Objects.equals(traceFormatAsString(), other.traceFormatAsString())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRetrievedTracesRequest").add("RetrievalToken", retrievalToken())
                .add("TraceFormat", traceFormatAsString()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetrievalToken":
            return Optional.ofNullable(clazz.cast(retrievalToken()));
        case "TraceFormat":
            return Optional.ofNullable(clazz.cast(traceFormatAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RetrievalToken", RETRIEVAL_TOKEN_FIELD);
        map.put("TraceFormat", TRACE_FORMAT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRetrievedTracesRequest, T> g) {
        return obj -> g.apply((ListRetrievedTracesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends XRayRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRetrievedTracesRequest> {
        /**
         * <p>
         * Retrieval token.
         * </p>
         * 
         * @param retrievalToken
         *        Retrieval token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalToken(String retrievalToken);

        /**
         * <p>
         * Format of the requested traces.
         * </p>
         * 
         * @param traceFormat
         *        Format of the requested traces.
         * @see TraceFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TraceFormatType
         */
        Builder traceFormat(String traceFormat);

        /**
         * <p>
         * Format of the requested traces.
         * </p>
         * 
         * @param traceFormat
         *        Format of the requested traces.
         * @see TraceFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TraceFormatType
         */
        Builder traceFormat(TraceFormatType traceFormat);

        /**
         * <p>
         * Specify the pagination token returned by a previous request to retrieve the next page of indexes.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token returned by a previous request to retrieve the next page of indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private String retrievalToken;

        private String traceFormat;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRetrievedTracesRequest model) {
            super(model);
            retrievalToken(model.retrievalToken);
            traceFormat(model.traceFormat);
            nextToken(model.nextToken);
        }

        public final String getRetrievalToken() {
            return retrievalToken;
        }

        public final void setRetrievalToken(String retrievalToken) {
            this.retrievalToken = retrievalToken;
        }

        @Override
        public final Builder retrievalToken(String retrievalToken) {
            this.retrievalToken = retrievalToken;
            return this;
        }

        public final String getTraceFormat() {
            return traceFormat;
        }

        public final void setTraceFormat(String traceFormat) {
            this.traceFormat = traceFormat;
        }

        @Override
        public final Builder traceFormat(String traceFormat) {
            this.traceFormat = traceFormat;
            return this;
        }

        @Override
        public final Builder traceFormat(TraceFormatType traceFormat) {
            this.traceFormat(traceFormat == null ? null : traceFormat.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRetrievedTracesRequest build() {
            return new ListRetrievedTracesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
