/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTraceSegmentDestinationResponse extends XRayResponse implements
        ToCopyableBuilder<GetTraceSegmentDestinationResponse.Builder, GetTraceSegmentDestinationResponse> {
    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(GetTraceSegmentDestinationResponse::destinationAsString))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetTraceSegmentDestinationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String destination;

    private final String status;

    private GetTraceSegmentDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.destination = builder.destination;
        this.status = builder.status;
    }

    /**
     * <p>
     * Retrieves the current destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link TraceSegmentDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationAsString}.
     * </p>
     * 
     * @return Retrieves the current destination.
     * @see TraceSegmentDestination
     */
    public final TraceSegmentDestination destination() {
        return TraceSegmentDestination.fromValue(destination);
    }

    /**
     * <p>
     * Retrieves the current destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link TraceSegmentDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationAsString}.
     * </p>
     * 
     * @return Retrieves the current destination.
     * @see TraceSegmentDestination
     */
    public final String destinationAsString() {
        return destination;
    }

    /**
     * <p>
     * Status of the retrieval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TraceSegmentDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the retrieval.
     * @see TraceSegmentDestinationStatus
     */
    public final TraceSegmentDestinationStatus status() {
        return TraceSegmentDestinationStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the retrieval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TraceSegmentDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the retrieval.
     * @see TraceSegmentDestinationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTraceSegmentDestinationResponse)) {
            return false;
        }
        GetTraceSegmentDestinationResponse other = (GetTraceSegmentDestinationResponse) obj;
        return Objects.equals(destinationAsString(), other.destinationAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTraceSegmentDestinationResponse").add("Destination", destinationAsString())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destinationAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Destination", DESTINATION_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTraceSegmentDestinationResponse, T> g) {
        return obj -> g.apply((GetTraceSegmentDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTraceSegmentDestinationResponse> {
        /**
         * <p>
         * Retrieves the current destination.
         * </p>
         * 
         * @param destination
         *        Retrieves the current destination.
         * @see TraceSegmentDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TraceSegmentDestination
         */
        Builder destination(String destination);

        /**
         * <p>
         * Retrieves the current destination.
         * </p>
         * 
         * @param destination
         *        Retrieves the current destination.
         * @see TraceSegmentDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TraceSegmentDestination
         */
        Builder destination(TraceSegmentDestination destination);

        /**
         * <p>
         * Status of the retrieval.
         * </p>
         * 
         * @param status
         *        Status of the retrieval.
         * @see TraceSegmentDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TraceSegmentDestinationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the retrieval.
         * </p>
         * 
         * @param status
         *        Status of the retrieval.
         * @see TraceSegmentDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TraceSegmentDestinationStatus
         */
        Builder status(TraceSegmentDestinationStatus status);
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private String destination;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTraceSegmentDestinationResponse model) {
            super(model);
            destination(model.destination);
            status(model.status);
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(TraceSegmentDestination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TraceSegmentDestinationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetTraceSegmentDestinationResponse build() {
            return new GetTraceSegmentDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
