/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInsightSummariesResponse extends XRayResponse implements
        ToCopyableBuilder<GetInsightSummariesResponse.Builder, GetInsightSummariesResponse> {
    private static final SdkField<List<InsightSummary>> INSIGHT_SUMMARIES_FIELD = SdkField
            .<List<InsightSummary>> builder(MarshallingType.LIST)
            .memberName("InsightSummaries")
            .getter(getter(GetInsightSummariesResponse::insightSummaries))
            .setter(setter(Builder::insightSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InsightSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(InsightSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetInsightSummariesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InsightSummary> insightSummaries;

    private final String nextToken;

    private GetInsightSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.insightSummaries = builder.insightSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsightSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInsightSummaries() {
        return insightSummaries != null && !(insightSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summary of each insight within the group matching the provided filters. The summary contains the InsightID,
     * start and end time, the root cause service, the root cause and client impact statistics, the top anomalous
     * services, and the status of the insight.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsightSummaries} method.
     * </p>
     * 
     * @return The summary of each insight within the group matching the provided filters. The summary contains the
     *         InsightID, start and end time, the root cause service, the root cause and client impact statistics, the
     *         top anomalous services, and the status of the insight.
     */
    public final List<InsightSummary> insightSummaries() {
        return insightSummaries;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInsightSummaries() ? insightSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightSummariesResponse)) {
            return false;
        }
        GetInsightSummariesResponse other = (GetInsightSummariesResponse) obj;
        return hasInsightSummaries() == other.hasInsightSummaries()
                && Objects.equals(insightSummaries(), other.insightSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInsightSummariesResponse")
                .add("InsightSummaries", hasInsightSummaries() ? insightSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightSummaries":
            return Optional.ofNullable(clazz.cast(insightSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InsightSummaries", INSIGHT_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInsightSummariesResponse, T> g) {
        return obj -> g.apply((GetInsightSummariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInsightSummariesResponse> {
        /**
         * <p>
         * The summary of each insight within the group matching the provided filters. The summary contains the
         * InsightID, start and end time, the root cause service, the root cause and client impact statistics, the top
         * anomalous services, and the status of the insight.
         * </p>
         * 
         * @param insightSummaries
         *        The summary of each insight within the group matching the provided filters. The summary contains the
         *        InsightID, start and end time, the root cause service, the root cause and client impact statistics,
         *        the top anomalous services, and the status of the insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightSummaries(Collection<InsightSummary> insightSummaries);

        /**
         * <p>
         * The summary of each insight within the group matching the provided filters. The summary contains the
         * InsightID, start and end time, the root cause service, the root cause and client impact statistics, the top
         * anomalous services, and the status of the insight.
         * </p>
         * 
         * @param insightSummaries
         *        The summary of each insight within the group matching the provided filters. The summary contains the
         *        InsightID, start and end time, the root cause service, the root cause and client impact statistics,
         *        the top anomalous services, and the status of the insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightSummaries(InsightSummary... insightSummaries);

        /**
         * <p>
         * The summary of each insight within the group matching the provided filters. The summary contains the
         * InsightID, start and end time, the root cause service, the root cause and client impact statistics, the top
         * anomalous services, and the status of the insight.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.InsightSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.xray.model.InsightSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.InsightSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #insightSummaries(List<InsightSummary>)}.
         * 
         * @param insightSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.InsightSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightSummaries(java.util.Collection<InsightSummary>)
         */
        Builder insightSummaries(Consumer<InsightSummary.Builder>... insightSummaries);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private List<InsightSummary> insightSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightSummariesResponse model) {
            super(model);
            insightSummaries(model.insightSummaries);
            nextToken(model.nextToken);
        }

        public final List<InsightSummary.Builder> getInsightSummaries() {
            List<InsightSummary.Builder> result = InsightSummaryListCopier.copyToBuilder(this.insightSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsightSummaries(Collection<InsightSummary.BuilderImpl> insightSummaries) {
            this.insightSummaries = InsightSummaryListCopier.copyFromBuilder(insightSummaries);
        }

        @Override
        public final Builder insightSummaries(Collection<InsightSummary> insightSummaries) {
            this.insightSummaries = InsightSummaryListCopier.copy(insightSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSummaries(InsightSummary... insightSummaries) {
            insightSummaries(Arrays.asList(insightSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSummaries(Consumer<InsightSummary.Builder>... insightSummaries) {
            insightSummaries(Stream.of(insightSummaries).map(c -> InsightSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetInsightSummariesResponse build() {
            return new GetInsightSummariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
