/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamplingBoostStatisticsDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SamplingBoostStatisticsDocument> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(SamplingBoostStatisticsDocument.getter(SamplingBoostStatisticsDocument::ruleName)).setter(SamplingBoostStatisticsDocument.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(SamplingBoostStatisticsDocument.getter(SamplingBoostStatisticsDocument::serviceName)).setter(SamplingBoostStatisticsDocument.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(SamplingBoostStatisticsDocument.getter(SamplingBoostStatisticsDocument::timestamp)).setter(SamplingBoostStatisticsDocument.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<Integer> ANOMALY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AnomalyCount").getter(SamplingBoostStatisticsDocument.getter(SamplingBoostStatisticsDocument::anomalyCount)).setter(SamplingBoostStatisticsDocument.setter(Builder::anomalyCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyCount").build()}).build();
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCount").getter(SamplingBoostStatisticsDocument.getter(SamplingBoostStatisticsDocument::totalCount)).setter(SamplingBoostStatisticsDocument.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final SdkField<Integer> SAMPLED_ANOMALY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SampledAnomalyCount").getter(SamplingBoostStatisticsDocument.getter(SamplingBoostStatisticsDocument::sampledAnomalyCount)).setter(SamplingBoostStatisticsDocument.setter(Builder::sampledAnomalyCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledAnomalyCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, SERVICE_NAME_FIELD, TIMESTAMP_FIELD, ANOMALY_COUNT_FIELD, TOTAL_COUNT_FIELD, SAMPLED_ANOMALY_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SamplingBoostStatisticsDocument.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ruleName;
    private final String serviceName;
    private final Instant timestamp;
    private final Integer anomalyCount;
    private final Integer totalCount;
    private final Integer sampledAnomalyCount;

    private SamplingBoostStatisticsDocument(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.serviceName = builder.serviceName;
        this.timestamp = builder.timestamp;
        this.anomalyCount = builder.anomalyCount;
        this.totalCount = builder.totalCount;
        this.sampledAnomalyCount = builder.sampledAnomalyCount;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final Integer anomalyCount() {
        return this.anomalyCount;
    }

    public final Integer totalCount() {
        return this.totalCount;
    }

    public final Integer sampledAnomalyCount() {
        return this.sampledAnomalyCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampledAnomalyCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingBoostStatisticsDocument)) {
            return false;
        }
        SamplingBoostStatisticsDocument other = (SamplingBoostStatisticsDocument)obj;
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.anomalyCount(), other.anomalyCount()) && Objects.equals(this.totalCount(), other.totalCount()) && Objects.equals(this.sampledAnomalyCount(), other.sampledAnomalyCount());
    }

    public final String toString() {
        return ToString.builder((String)"SamplingBoostStatisticsDocument").add("RuleName", (Object)this.ruleName()).add("ServiceName", (Object)this.serviceName()).add("Timestamp", (Object)this.timestamp()).add("AnomalyCount", (Object)this.anomalyCount()).add("TotalCount", (Object)this.totalCount()).add("SampledAnomalyCount", (Object)this.sampledAnomalyCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "AnomalyCount": {
                return Optional.ofNullable(clazz.cast(this.anomalyCount()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
            case "SampledAnomalyCount": {
                return Optional.ofNullable(clazz.cast(this.sampledAnomalyCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("AnomalyCount", ANOMALY_COUNT_FIELD);
        map.put("TotalCount", TOTAL_COUNT_FIELD);
        map.put("SampledAnomalyCount", SAMPLED_ANOMALY_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SamplingBoostStatisticsDocument, T> g) {
        return obj -> g.apply((SamplingBoostStatisticsDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleName;
        private String serviceName;
        private Instant timestamp;
        private Integer anomalyCount;
        private Integer totalCount;
        private Integer sampledAnomalyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingBoostStatisticsDocument model) {
            this.ruleName(model.ruleName);
            this.serviceName(model.serviceName);
            this.timestamp(model.timestamp);
            this.anomalyCount(model.anomalyCount);
            this.totalCount(model.totalCount);
            this.sampledAnomalyCount(model.sampledAnomalyCount);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Integer getAnomalyCount() {
            return this.anomalyCount;
        }

        public final void setAnomalyCount(Integer anomalyCount) {
            this.anomalyCount = anomalyCount;
        }

        @Override
        public final Builder anomalyCount(Integer anomalyCount) {
            this.anomalyCount = anomalyCount;
            return this;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final Integer getSampledAnomalyCount() {
            return this.sampledAnomalyCount;
        }

        public final void setSampledAnomalyCount(Integer sampledAnomalyCount) {
            this.sampledAnomalyCount = sampledAnomalyCount;
        }

        @Override
        public final Builder sampledAnomalyCount(Integer sampledAnomalyCount) {
            this.sampledAnomalyCount = sampledAnomalyCount;
            return this;
        }

        public SamplingBoostStatisticsDocument build() {
            return new SamplingBoostStatisticsDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SamplingBoostStatisticsDocument> {
        public Builder ruleName(String var1);

        public Builder serviceName(String var1);

        public Builder timestamp(Instant var1);

        public Builder anomalyCount(Integer var1);

        public Builder totalCount(Integer var1);

        public Builder sampledAnomalyCount(Integer var1);
    }
}

