/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.RetrievalStatus;
import software.amazon.awssdk.services.xray.model.RetrievedService;
import software.amazon.awssdk.services.xray.model.RetrievedServicesListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRetrievedTracesGraphResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetRetrievedTracesGraphResponse> {
    private static final SdkField<String> RETRIEVAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetrievalStatus").getter(GetRetrievedTracesGraphResponse.getter(GetRetrievedTracesGraphResponse::retrievalStatusAsString)).setter(GetRetrievedTracesGraphResponse.setter(Builder::retrievalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalStatus").build()}).build();
    private static final SdkField<List<RetrievedService>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Services").getter(GetRetrievedTracesGraphResponse.getter(GetRetrievedTracesGraphResponse::services)).setter(GetRetrievedTracesGraphResponse.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RetrievedService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetRetrievedTracesGraphResponse.getter(GetRetrievedTracesGraphResponse::nextToken)).setter(GetRetrievedTracesGraphResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVAL_STATUS_FIELD, SERVICES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRetrievedTracesGraphResponse.memberNameToFieldInitializer();
    private final String retrievalStatus;
    private final List<RetrievedService> services;
    private final String nextToken;

    private GetRetrievedTracesGraphResponse(BuilderImpl builder) {
        super(builder);
        this.retrievalStatus = builder.retrievalStatus;
        this.services = builder.services;
        this.nextToken = builder.nextToken;
    }

    public final RetrievalStatus retrievalStatus() {
        return RetrievalStatus.fromValue(this.retrievalStatus);
    }

    public final String retrievalStatusAsString() {
        return this.retrievalStatus;
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public final List<RetrievedService> services() {
        return this.services;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRetrievedTracesGraphResponse)) {
            return false;
        }
        GetRetrievedTracesGraphResponse other = (GetRetrievedTracesGraphResponse)((Object)obj);
        return Objects.equals(this.retrievalStatusAsString(), other.retrievalStatusAsString()) && this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetRetrievedTracesGraphResponse").add("RetrievalStatus", (Object)this.retrievalStatusAsString()).add("Services", this.hasServices() ? this.services() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RetrievalStatus": {
                return Optional.ofNullable(clazz.cast(this.retrievalStatusAsString()));
            }
            case "Services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RetrievalStatus", RETRIEVAL_STATUS_FIELD);
        map.put("Services", SERVICES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRetrievedTracesGraphResponse, T> g) {
        return obj -> g.apply((GetRetrievedTracesGraphResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private String retrievalStatus;
        private List<RetrievedService> services = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRetrievedTracesGraphResponse model) {
            super(model);
            this.retrievalStatus(model.retrievalStatus);
            this.services(model.services);
            this.nextToken(model.nextToken);
        }

        public final String getRetrievalStatus() {
            return this.retrievalStatus;
        }

        public final void setRetrievalStatus(String retrievalStatus) {
            this.retrievalStatus = retrievalStatus;
        }

        @Override
        public final Builder retrievalStatus(String retrievalStatus) {
            this.retrievalStatus = retrievalStatus;
            return this;
        }

        @Override
        public final Builder retrievalStatus(RetrievalStatus retrievalStatus) {
            this.retrievalStatus(retrievalStatus == null ? null : retrievalStatus.toString());
            return this;
        }

        public final List<RetrievedService.Builder> getServices() {
            List<RetrievedService.Builder> result = RetrievedServicesListCopier.copyToBuilder(this.services);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServices(Collection<RetrievedService.BuilderImpl> services) {
            this.services = RetrievedServicesListCopier.copyFromBuilder(services);
        }

        @Override
        public final Builder services(Collection<RetrievedService> services) {
            this.services = RetrievedServicesListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(RetrievedService ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<RetrievedService.Builder> ... services) {
            this.services(Stream.of(services).map(c -> (RetrievedService)((RetrievedService.Builder)RetrievedService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetRetrievedTracesGraphResponse build() {
            return new GetRetrievedTracesGraphResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRetrievedTracesGraphResponse> {
        public Builder retrievalStatus(String var1);

        public Builder retrievalStatus(RetrievalStatus var1);

        public Builder services(Collection<RetrievedService> var1);

        public Builder services(RetrievedService ... var1);

        public Builder services(Consumer<RetrievedService.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

