/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamplingStatisticSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SamplingStatisticSummary> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(SamplingStatisticSummary.getter(SamplingStatisticSummary::ruleName)).setter(SamplingStatisticSummary.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(SamplingStatisticSummary.getter(SamplingStatisticSummary::timestamp)).setter(SamplingStatisticSummary.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<Integer> REQUEST_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RequestCount").getter(SamplingStatisticSummary.getter(SamplingStatisticSummary::requestCount)).setter(SamplingStatisticSummary.setter(Builder::requestCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestCount").build()}).build();
    private static final SdkField<Integer> BORROW_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BorrowCount").getter(SamplingStatisticSummary.getter(SamplingStatisticSummary::borrowCount)).setter(SamplingStatisticSummary.setter(Builder::borrowCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorrowCount").build()}).build();
    private static final SdkField<Integer> SAMPLED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SampledCount").getter(SamplingStatisticSummary.getter(SamplingStatisticSummary::sampledCount)).setter(SamplingStatisticSummary.setter(Builder::sampledCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, TIMESTAMP_FIELD, REQUEST_COUNT_FIELD, BORROW_COUNT_FIELD, SAMPLED_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SamplingStatisticSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ruleName;
    private final Instant timestamp;
    private final Integer requestCount;
    private final Integer borrowCount;
    private final Integer sampledCount;

    private SamplingStatisticSummary(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.timestamp = builder.timestamp;
        this.requestCount = builder.requestCount;
        this.borrowCount = builder.borrowCount;
        this.sampledCount = builder.sampledCount;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final Integer requestCount() {
        return this.requestCount;
    }

    public final Integer borrowCount() {
        return this.borrowCount;
    }

    public final Integer sampledCount() {
        return this.sampledCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.borrowCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampledCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingStatisticSummary)) {
            return false;
        }
        SamplingStatisticSummary other = (SamplingStatisticSummary)obj;
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.requestCount(), other.requestCount()) && Objects.equals(this.borrowCount(), other.borrowCount()) && Objects.equals(this.sampledCount(), other.sampledCount());
    }

    public final String toString() {
        return ToString.builder((String)"SamplingStatisticSummary").add("RuleName", (Object)this.ruleName()).add("Timestamp", (Object)this.timestamp()).add("RequestCount", (Object)this.requestCount()).add("BorrowCount", (Object)this.borrowCount()).add("SampledCount", (Object)this.sampledCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "RequestCount": {
                return Optional.ofNullable(clazz.cast(this.requestCount()));
            }
            case "BorrowCount": {
                return Optional.ofNullable(clazz.cast(this.borrowCount()));
            }
            case "SampledCount": {
                return Optional.ofNullable(clazz.cast(this.sampledCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("RequestCount", REQUEST_COUNT_FIELD);
        map.put("BorrowCount", BORROW_COUNT_FIELD);
        map.put("SampledCount", SAMPLED_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SamplingStatisticSummary, T> g) {
        return obj -> g.apply((SamplingStatisticSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleName;
        private Instant timestamp;
        private Integer requestCount;
        private Integer borrowCount;
        private Integer sampledCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingStatisticSummary model) {
            this.ruleName(model.ruleName);
            this.timestamp(model.timestamp);
            this.requestCount(model.requestCount);
            this.borrowCount(model.borrowCount);
            this.sampledCount(model.sampledCount);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Integer getRequestCount() {
            return this.requestCount;
        }

        public final void setRequestCount(Integer requestCount) {
            this.requestCount = requestCount;
        }

        @Override
        public final Builder requestCount(Integer requestCount) {
            this.requestCount = requestCount;
            return this;
        }

        public final Integer getBorrowCount() {
            return this.borrowCount;
        }

        public final void setBorrowCount(Integer borrowCount) {
            this.borrowCount = borrowCount;
        }

        @Override
        public final Builder borrowCount(Integer borrowCount) {
            this.borrowCount = borrowCount;
            return this;
        }

        public final Integer getSampledCount() {
            return this.sampledCount;
        }

        public final void setSampledCount(Integer sampledCount) {
            this.sampledCount = sampledCount;
        }

        @Override
        public final Builder sampledCount(Integer sampledCount) {
            this.sampledCount = sampledCount;
            return this;
        }

        public SamplingStatisticSummary build() {
            return new SamplingStatisticSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SamplingStatisticSummary> {
        public Builder ruleName(String var1);

        public Builder timestamp(Instant var1);

        public Builder requestCount(Integer var1);

        public Builder borrowCount(Integer var1);

        public Builder sampledCount(Integer var1);
    }
}

